/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector;

import java.awt.Color;
import org.opentripplanner.inspector.DefaultScalarColorPalette;
import org.opentripplanner.inspector.EdgeVertexTileRenderer;
import org.opentripplanner.inspector.ScalarColorPalette;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetVehicleRentalLink;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalPlaceVertex;

public class BikeSafetyEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private static final Color VEHICLE_RENTAL_COLOR_VERTEX = new Color(0.0f, 0.7f, 0.0f);
    private final ScalarColorPalette palette = new DefaultScalarColorPalette(1.0, 3.0, 10.0);

    @Override
    public boolean renderEdge(Edge e, EdgeVertexTileRenderer.EdgeVisualAttributes attrs) {
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            if (pse.getPermission().allows(TraverseMode.BICYCLE)) {
                double bikeSafety = pse.getBicycleSafetyFactor();
                attrs.color = this.palette.getColor(bikeSafety);
                attrs.label = String.format("%.02f", bikeSafety);
            } else {
                attrs.color = Color.LIGHT_GRAY;
                attrs.label = "no bikes";
            }
        } else if (e instanceof StreetVehicleRentalLink) {
            attrs.color = this.palette.getColor(1.0);
            attrs.label = "link";
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean renderVertex(Vertex v, EdgeVertexTileRenderer.VertexVisualAttributes attrs) {
        if (v instanceof VehicleRentalPlaceVertex) {
            attrs.color = VEHICLE_RENTAL_COLOR_VERTEX;
            attrs.label = v.getDefaultName();
        } else if (v instanceof IntersectionVertex) {
            attrs.color = Color.DARK_GRAY;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "Bike safety";
    }
}

