/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.index;

import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.api.mapping.AgencyMapper;
import org.opentripplanner.api.mapping.AlertMapper;
import org.opentripplanner.api.mapping.FeedInfoMapper;
import org.opentripplanner.api.mapping.FeedScopedIdMapper;
import org.opentripplanner.api.mapping.RouteMapper;
import org.opentripplanner.api.mapping.StopMapper;
import org.opentripplanner.api.mapping.StopTimesInPatternMapper;
import org.opentripplanner.api.mapping.TransferMapper;
import org.opentripplanner.api.mapping.TripMapper;
import org.opentripplanner.api.mapping.TripPatternMapper;
import org.opentripplanner.api.mapping.TripTimeMapper;
import org.opentripplanner.api.model.ApiAgency;
import org.opentripplanner.api.model.ApiAlert;
import org.opentripplanner.api.model.ApiFeedInfo;
import org.opentripplanner.api.model.ApiPatternShort;
import org.opentripplanner.api.model.ApiRoute;
import org.opentripplanner.api.model.ApiRouteShort;
import org.opentripplanner.api.model.ApiStop;
import org.opentripplanner.api.model.ApiStopShort;
import org.opentripplanner.api.model.ApiStopTimesInPattern;
import org.opentripplanner.api.model.ApiTransfer;
import org.opentripplanner.api.model.ApiTrip;
import org.opentripplanner.api.model.ApiTripShort;
import org.opentripplanner.api.model.ApiTripTimeShort;
import org.opentripplanner.api.support.SemanticHash;
import org.opentripplanner.index.ValidateParameters;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.graphfinder.DirectGraphFinder;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.PolylineEncoder;
import org.opentripplanner.util.model.EncodedPolyline;
import org.opentripplanner.util.time.ServiceDateUtils;

@Path(value="/routers/{ignoreRouterId}/index")
@Produces(value={"application/json"})
public class IndexAPI {
    private static final double MAX_STOP_SEARCH_RADIUS = 5000.0;
    private final OtpServerRequestContext serverContext;
    @Context
    UriInfo uriInfo;

    public IndexAPI(@Context OtpServerRequestContext serverContext, @PathParam(value="ignoreRouterId") String ignoreRouterId) {
        this.serverContext = serverContext;
    }

    @GET
    @Path(value="/feeds")
    public Collection<String> getFeeds() {
        return this.transitService().getFeedIds();
    }

    @GET
    @Path(value="/feeds/{feedId}")
    public ApiFeedInfo getFeedInfo(@PathParam(value="feedId") String feedId) {
        ApiFeedInfo feedInfo = FeedInfoMapper.mapToApi(this.transitService().getFeedInfo(feedId));
        return IndexAPI.validateExist("FeedInfo", feedInfo, "feedId", feedId);
    }

    @GET
    @Path(value="/agencies/{feedId}")
    public Collection<ApiAgency> getAgencies(@PathParam(value="feedId") String feedId) {
        Collection agencies = this.transitService().getAgencies().stream().filter(agency -> agency.getId().getFeedId().equals(feedId)).collect(Collectors.toList());
        IndexAPI.validateExist("Agency", agencies, "feedId", feedId);
        return AgencyMapper.mapToApi(agencies);
    }

    @GET
    @Path(value="/agencies/{feedId}/{agencyId}")
    public ApiAgency httpGgetAgency(@PathParam(value="feedId") String feedId, @PathParam(value="agencyId") String agencyId) {
        return AgencyMapper.mapToApi(this.agency(feedId, agencyId));
    }

    @GET
    @Path(value="/agencies/{feedId}/{agencyId}/routes")
    public Response getAgencyRoutes(@PathParam(value="feedId") String feedId, @PathParam(value="agencyId") String agencyId, @QueryParam(value="detail") @DefaultValue(value="false") Boolean detail) {
        Agency agency = this.agency(feedId, agencyId);
        Collection routes = this.transitService().getAllRoutes().stream().filter(r -> r.getAgency() == agency).collect(Collectors.toList());
        if (detail.booleanValue()) {
            return Response.status((Response.Status)Response.Status.OK).entity(RouteMapper.mapToApi(routes)).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(RouteMapper.mapToApiShort(routes)).build();
    }

    @GET
    @Path(value="/agencies/{feedId}/{agencyId}/alerts")
    public Collection<ApiAlert> getAlertsForTrip(@PathParam(value="feedId") String feedId, @PathParam(value="agencyId") String agencyId) {
        AlertMapper alertMapper = new AlertMapper(null);
        FeedScopedId id = new FeedScopedId(feedId, agencyId);
        return alertMapper.mapToApi(this.transitService().getTransitAlertService().getAgencyAlerts(id));
    }

    @GET
    @Path(value="/stops/{stopId}")
    public ApiStop getStop(@PathParam(value="stopId") String stopIdString) {
        return StopMapper.mapToApi(this.stop(stopIdString));
    }

    @GET
    @Path(value="/stops")
    public List<ApiStopShort> getStopsInRadius(@QueryParam(value="minLat") Double minLat, @QueryParam(value="minLon") Double minLon, @QueryParam(value="maxLat") Double maxLat, @QueryParam(value="maxLon") Double maxLon, @QueryParam(value="lat") Double lat, @QueryParam(value="lon") Double lon, @QueryParam(value="radius") Double radius) {
        boolean expectCircle;
        if (this.uriInfo.getQueryParameters().isEmpty()) {
            return StopMapper.mapToApiShort(this.transitService().listStopLocations());
        }
        boolean bl = expectCircle = lat != null || lon != null || radius != null;
        if (expectCircle) {
            IndexAPI.verifyParams().withinBounds("lat", lat, -90.0, 90.0).withinBounds("lon", lon, -180.0, 180.0).positiveOrZero("radius", radius).validate();
            radius = Math.min(radius, 5000.0);
            return new DirectGraphFinder(this.serverContext.transitService()::findRegularStop).findClosestStops(new Coordinate(lon.doubleValue(), lat.doubleValue()), radius).stream().map(it -> StopMapper.mapToApiShort(it.stop, it.distance)).collect(Collectors.toList());
        }
        IndexAPI.verifyParams().withinBounds("minLat", minLat, -90.0, 90.0).withinBounds("maxLat", maxLat, -90.0, 90.0).withinBounds("minLon", minLon, -180.0, 180.0).withinBounds("maxLon", maxLon, -180.0, 180.0).lessThan("minLat", minLat, "maxLat", maxLat).lessThan("minLon", minLon, "maxLon", maxLon).validate();
        Envelope envelope = new Envelope(new Coordinate(minLon.doubleValue(), minLat.doubleValue()), new Coordinate(maxLon.doubleValue(), maxLat.doubleValue()));
        Collection<RegularStop> stops = this.transitService().findRegularStop(envelope);
        return stops.stream().filter(stop -> envelope.contains(stop.getCoordinate().asJtsCoordinate())).map(StopMapper::mapToApiShort).toList();
    }

    @GET
    @Path(value="/stops/{stopId}/routes")
    public List<ApiRouteShort> getRoutesForStop(@PathParam(value="stopId") String stopId) {
        StopLocation stop = this.stop(stopId);
        return this.transitService().getPatternsForStop(stop).stream().map(TripPattern::getRoute).map(RouteMapper::mapToApiShort).collect(Collectors.toList());
    }

    @GET
    @Path(value="/stops/{stopId}/patterns")
    public List<ApiPatternShort> getPatternsForStop(@PathParam(value="stopId") String stopId) {
        StopLocation stop = this.stop(stopId);
        return this.transitService().getPatternsForStop(stop).stream().map(TripPatternMapper::mapToApiShort).collect(Collectors.toList());
    }

    @GET
    @Path(value="/stops/{stopId}/stoptimes")
    public Collection<ApiStopTimesInPattern> getStopTimesForStop(@PathParam(value="stopId") String stopIdString, @QueryParam(value="startTime") long startTimeSeconds, @QueryParam(value="timeRange") @DefaultValue(value="86400") int timeRange, @QueryParam(value="numberOfDepartures") @DefaultValue(value="2") int numberOfDepartures, @QueryParam(value="omitNonPickups") boolean omitNonPickups) {
        Instant startTime = startTimeSeconds == 0L ? Instant.now() : Instant.ofEpochSecond(startTimeSeconds);
        return this.transitService().stopTimesForStop(this.stop(stopIdString), startTime, Duration.ofSeconds(timeRange), numberOfDepartures, omitNonPickups ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, false).stream().map(StopTimesInPatternMapper::mapToApi).collect(Collectors.toList());
    }

    @GET
    @Path(value="/stops/{stopId}/stoptimes/{date}")
    public List<ApiStopTimesInPattern> getStoptimesForStopAndDate(@PathParam(value="stopId") String stopId, @PathParam(value="date") String date, @QueryParam(value="omitNonPickups") boolean omitNonPickups) {
        StopLocation stop = this.stop(stopId);
        LocalDate serviceDate = IndexAPI.parseServiceDate("date", date);
        List<StopTimesInPattern> stopTimes = this.transitService().getStopTimesForStop(stop, serviceDate, omitNonPickups ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, true);
        return StopTimesInPatternMapper.mapToApi(stopTimes);
    }

    @GET
    @Path(value="/stops/{stopId}/transfers")
    public Collection<ApiTransfer> getTransfers(@PathParam(value="stopId") String stopId) {
        StopLocation stop = this.stop(stopId);
        return this.transitService().getTransfersByStop(stop).stream().map(TransferMapper::mapToApi).collect(Collectors.toList());
    }

    @GET
    @Path(value="/stops/{stopId}/alerts")
    public Collection<ApiAlert> getAlertsForStop(@PathParam(value="stopId") String stopId) {
        AlertMapper alertMapper = new AlertMapper(null);
        FeedScopedId id = IndexAPI.createId("stopId", stopId);
        return alertMapper.mapToApi(this.transitService().getTransitAlertService().getStopAlerts(id));
    }

    @GET
    @Path(value="/routes")
    public List<ApiRouteShort> getRoutes(@QueryParam(value="hasStop") List<String> stopIds) {
        Collection<Route> routes = this.transitService().getAllRoutes();
        if (stopIds != null) {
            routes = new ArrayList<Route>(routes);
            for (String stopId : stopIds) {
                StopLocation stop = this.stop(stopId);
                HashSet<Route> routesHere = new HashSet<Route>();
                for (TripPattern pattern : this.transitService().getPatternsForStop(stop)) {
                    routesHere.add(pattern.getRoute());
                }
                routes.retainAll(routesHere);
            }
        }
        return RouteMapper.mapToApiShort(routes);
    }

    @GET
    @Path(value="/routes/{routeId}")
    public ApiRoute getRoute(@PathParam(value="routeId") String routeId) {
        return RouteMapper.mapToApi(this.route(routeId));
    }

    @GET
    @Path(value="/routes/{routeId}/patterns")
    public List<ApiPatternShort> getPatternsForRoute(@PathParam(value="routeId") String routeId) {
        Collection<TripPattern> patterns = this.transitService().getPatternsForRoute(this.route(routeId));
        return TripPatternMapper.mapToApiShort(patterns);
    }

    @GET
    @Path(value="/routes/{routeId}/stops")
    public List<ApiStopShort> getStopsForRoute(@PathParam(value="routeId") String routeId) {
        Route route = this.route(routeId);
        HashSet<StopLocation> stops = new HashSet<StopLocation>();
        Collection<TripPattern> patterns = this.transitService().getPatternsForRoute(route);
        for (TripPattern pattern : patterns) {
            stops.addAll(pattern.getStops());
        }
        return StopMapper.mapToApiShort(stops);
    }

    @GET
    @Path(value="/routes/{routeId}/trips")
    public List<ApiTripShort> getTripsForRoute(@PathParam(value="routeId") String routeId) {
        Route route = this.route(routeId);
        Collection<TripPattern> patterns = this.transitService().getPatternsForRoute(route);
        return patterns.stream().flatMap(TripPattern::scheduledTripsAsStream).map(TripMapper::mapToApiShort).collect(Collectors.toList());
    }

    @GET
    @Path(value="/routes/{routeId}/alerts")
    public Collection<ApiAlert> getAlertsForRoute(@PathParam(value="routeId") String routeId) {
        AlertMapper alertMapper = new AlertMapper(null);
        FeedScopedId id = IndexAPI.createId("routeId", routeId);
        return alertMapper.mapToApi(this.transitService().getTransitAlertService().getRouteAlerts(id));
    }

    @GET
    @Path(value="/trips/{tripId}")
    public ApiTrip getTrip(@PathParam(value="tripId") String tripId) {
        return TripMapper.mapToApi(this.trip(tripId));
    }

    @GET
    @Path(value="/trips/{tripId}/stops")
    public List<ApiStopShort> getStopsForTrip(@PathParam(value="tripId") String tripId) {
        List<StopLocation> stops = this.tripPatternForTripId(tripId).getStops();
        return StopMapper.mapToApiShort(stops);
    }

    @GET
    @Path(value="/trips/{tripId}/semanticHash")
    public String getSemanticHashForTrip(@PathParam(value="tripId") String tripId) {
        Trip trip = this.trip(tripId);
        return SemanticHash.forTripPattern(this.tripPattern(trip), trip);
    }

    @GET
    @Path(value="/trips/{tripId}/stoptimes")
    public List<ApiTripTimeShort> getStoptimesForTrip(@PathParam(value="tripId") String tripId) {
        Trip trip = this.trip(tripId);
        TripPattern pattern = this.tripPattern(trip);
        Timetable table = this.transitService().getTimetableForTripPattern(pattern, LocalDate.now(this.transitService().getTimeZone()));
        List<TripTimeOnDate> tripTimesOnDate = TripTimeOnDate.fromTripTimes(table, trip);
        return TripTimeMapper.mapToApi(tripTimesOnDate);
    }

    @GET
    @Path(value="/trips/{tripId}/geometry")
    public EncodedPolyline getGeometryForTrip(@PathParam(value="tripId") String tripId) {
        TripPattern pattern = this.tripPatternForTripId(tripId);
        return PolylineEncoder.encodeGeometry((Geometry)pattern.getGeometry());
    }

    @GET
    @Path(value="/trips/{tripId}/alerts")
    public Collection<ApiAlert> getAlertsForTrip(@PathParam(value="tripId") String tripId) {
        AlertMapper alertMapper = new AlertMapper(null);
        FeedScopedId id = IndexAPI.createId("tripId", tripId);
        return alertMapper.mapToApi(this.transitService().getTransitAlertService().getTripAlerts(id, null));
    }

    @GET
    @Path(value="/patterns")
    public List<ApiPatternShort> getPatterns() {
        Collection<TripPattern> patterns = this.transitService().getAllTripPatterns();
        return TripPatternMapper.mapToApiShort(patterns);
    }

    @GET
    @Path(value="/patterns/{patternId}")
    public ApiPatternShort getPattern(@PathParam(value="patternId") String patternId) {
        TripPattern pattern = this.tripPattern(patternId);
        return TripPatternMapper.mapToApiDetailed(pattern);
    }

    @GET
    @Path(value="/patterns/{patternId}/trips")
    public List<ApiTripShort> getTripsForPattern(@PathParam(value="patternId") String patternId) {
        Stream<Trip> trips = this.tripPattern(patternId).scheduledTripsAsStream();
        return TripMapper.mapToApiShort(trips);
    }

    @GET
    @Path(value="/patterns/{patternId}/stops")
    public List<ApiStopShort> getStopsForPattern(@PathParam(value="patternId") String patternId) {
        List<StopLocation> stops = this.tripPattern(patternId).getStops();
        return StopMapper.mapToApiShort(stops);
    }

    @GET
    @Path(value="/patterns/{patternId}/semanticHash")
    public String getSemanticHashForPattern(@PathParam(value="patternId") String patternId) {
        TripPattern tripPattern = this.tripPattern(patternId);
        return SemanticHash.forTripPattern(tripPattern, null);
    }

    @GET
    @Path(value="/patterns/{patternId}/geometry")
    public EncodedPolyline getGeometryForPattern(@PathParam(value="patternId") String patternId) {
        LineString line = this.tripPattern(patternId).getGeometry();
        return PolylineEncoder.encodeGeometry((Geometry)line);
    }

    @GET
    @Path(value="/patterns/{patternId}/alerts")
    public Collection<ApiAlert> getAlertsForPattern(@PathParam(value="patternId") String patternId) {
        AlertMapper alertMapper = new AlertMapper(null);
        TripPattern pattern = this.tripPattern(patternId);
        return alertMapper.mapToApi(this.transitService().getTransitAlertService().getDirectionAndRouteAlerts(pattern.getDirection(), pattern.getRoute().getId()));
    }

    @GET
    @Path(value="/services")
    public Response getServices() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"NONE").build();
    }

    @GET
    @Path(value="/services/{serviceId}")
    public Response getServices(@PathParam(value="serviceId") String serviceId) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"NONE").build();
    }

    private static FeedScopedId createId(String name, String value) {
        return FeedScopedIdMapper.mapToDomain(name, value);
    }

    private static LocalDate parseServiceDate(String label, String date) {
        try {
            return ServiceDateUtils.parseString(date);
        }
        catch (ParseException e) {
            throw new BadRequestException("Unable to parse date, not on format: YYYY-MM-DD. " + label + ": '" + date + "'");
        }
    }

    private static ValidateParameters verifyParams() {
        return new ValidateParameters();
    }

    private static <T> T validateExist(String eName, T entity, String keyLabel, Object key) {
        if (entity != null) {
            return entity;
        }
        throw IndexAPI.notFoundException(eName, keyLabel, key);
    }

    private static NotFoundException notFoundException(String eName, String keyLbl, Object key) {
        return IndexAPI.notFoundException(eName, keyLbl + ": " + key);
    }

    private static NotFoundException notFoundException(String entity, String details) {
        return new NotFoundException(entity + " not found. " + details);
    }

    private Agency agency(String feedId, String agencyId) {
        Agency agency = this.transitService().getAgencyForId(new FeedScopedId(feedId, agencyId));
        if (agency == null) {
            throw IndexAPI.notFoundException("Agency", "feedId: " + feedId + ", agencyId: " + agencyId);
        }
        return agency;
    }

    private StopLocation stop(String stopId) {
        RegularStop stop = this.transitService().getRegularStop(IndexAPI.createId("stopId", stopId));
        return IndexAPI.validateExist("Stop", stop, "stopId", stop);
    }

    private Route route(String routeId) {
        Route route = this.transitService().getRouteForId(IndexAPI.createId("routeId", routeId));
        return IndexAPI.validateExist("Route", route, "routeId", routeId);
    }

    private Trip trip(String tripId) {
        Trip trip = this.transitService().getTripForId(IndexAPI.createId("tripId", tripId));
        return IndexAPI.validateExist("Trip", trip, "tripId", tripId);
    }

    private TripPattern tripPattern(String tripPatternId) {
        FeedScopedId id = IndexAPI.createId("patternId", tripPatternId);
        TripPattern pattern = this.transitService().getTripPatternForId(id);
        return IndexAPI.validateExist("TripPattern", pattern, "patternId", tripPatternId);
    }

    private TripPattern tripPatternForTripId(String tripId) {
        return this.tripPattern(this.trip(tripId));
    }

    private TripPattern tripPattern(Trip trip) {
        TripPattern pattern = this.transitService().getPatternForTrip(trip);
        return IndexAPI.validateExist("TripPattern", pattern, "trip", trip.getId());
    }

    private RoutingService routingService() {
        return this.serverContext.routingService();
    }

    private TransitService transitService() {
        return this.serverContext.transitService();
    }
}

