/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import org.opentripplanner.transit.model.basic.TransitMode;

public class TransitModeMapper {
    public static TransitMode mapMode(int routeType) {
        if (routeType == -999) {
            return null;
        }
        if (routeType >= 100 && routeType < 200) {
            return TransitMode.RAIL;
        }
        if (routeType >= 200 && routeType < 300) {
            return TransitMode.BUS;
        }
        if (routeType >= 300 && routeType < 500) {
            if (routeType >= 401 && routeType <= 402) {
                return TransitMode.SUBWAY;
            }
            if (routeType == 405) {
                return TransitMode.MONORAIL;
            }
            return TransitMode.RAIL;
        }
        if (routeType >= 500 && routeType < 700) {
            return TransitMode.SUBWAY;
        }
        if (routeType >= 700 && routeType < 900) {
            if (routeType == 800) {
                return TransitMode.TROLLEYBUS;
            }
            return TransitMode.BUS;
        }
        if (routeType >= 900 && routeType < 1000) {
            return TransitMode.TRAM;
        }
        if (routeType >= 1000 && routeType < 1100) {
            return TransitMode.FERRY;
        }
        if (routeType >= 1100 && routeType < 1200) {
            return TransitMode.AIRPLANE;
        }
        if (routeType >= 1200 && routeType < 1300) {
            return TransitMode.FERRY;
        }
        if (routeType >= 1300 && routeType < 1400) {
            return TransitMode.GONDOLA;
        }
        if (routeType >= 1400 && routeType < 1500) {
            return TransitMode.FUNICULAR;
        }
        if (routeType >= 1500 && routeType < 1600) {
            return null;
        }
        if (routeType >= 1600 && routeType < 1700) {
            return TransitMode.BUS;
        }
        if (routeType >= 1700 && routeType < 1800) {
            return null;
        }
        switch (routeType) {
            case 0: {
                return TransitMode.TRAM;
            }
            case 1: {
                return TransitMode.SUBWAY;
            }
            case 2: {
                return TransitMode.RAIL;
            }
            case 3: {
                return TransitMode.BUS;
            }
            case 4: {
                return TransitMode.FERRY;
            }
            case 5: {
                return TransitMode.CABLE_CAR;
            }
            case 6: {
                return TransitMode.GONDOLA;
            }
            case 7: {
                return TransitMode.FUNICULAR;
            }
            case 11: {
                return TransitMode.TROLLEYBUS;
            }
            case 12: {
                return TransitMode.MONORAIL;
            }
        }
        throw new IllegalArgumentException("unknown gtfs route type " + routeType);
    }
}

