/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.services.osm;

import com.fasterxml.jackson.databind.JsonNode;
import org.opentripplanner.graph_builder.module.osm.PortlandCustomNamer;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public interface CustomNamer {
    public String name(OSMWithTags var1, String var2);

    public void nameWithEdge(OSMWithTags var1, StreetEdge var2);

    public void postprocess(Graph var1);

    public void configure();

    public static class CustomNamerFactory {
        public static CustomNamer fromConfig(NodeAdapter root, String parameterName) {
            NodeAdapter osmNaming = root.of(parameterName).summary("A custom OSM namer to use.").since(OtpVersion.V2_0).asObject();
            return CustomNamerFactory.fromConfig(osmNaming.rawNode());
        }

        public static CustomNamer fromConfig(JsonNode config) {
            String type = null;
            if (config == null) {
                return null;
            }
            if (config.isTextual()) {
                type = config.asText();
            } else if (config.has("type")) {
                type = config.path("type").asText(null);
            }
            if (type == null) {
                return null;
            }
            PortlandCustomNamer retval = switch (type) {
                case "portland" -> new PortlandCustomNamer();
                default -> throw new IllegalArgumentException(String.format("Unknown osmNaming type: '%s'", type));
            };
            retval.configure();
            return retval;
        }
    }
}

