/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.tagmapping;

import org.opentripplanner.graph_builder.module.osm.WayProperties;
import org.opentripplanner.graph_builder.module.osm.WayPropertiesBuilder;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.specifier.BestMatchSpecifier;
import org.opentripplanner.graph_builder.module.osm.specifier.LogicalOrSpecifier;
import org.opentripplanner.graph_builder.module.osm.tagmapping.OsmTagMapper;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.services.notes.StreetNotesService;

public class DefaultMapper
implements OsmTagMapper {
    @Override
    public void populateProperties(WayPropertySet props) {
        WayProperties allWayProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).build();
        WayProperties noneWayProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE).build();
        WayProperties pedestrianWayProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).build();
        WayProperties pedestrianAndBicycleWayProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).build();
        props.setProperties("mtb:scale=3", noneWayProperties);
        props.setProperties("mtb:scale=4", noneWayProperties);
        props.setProperties("mtb:scale=5", noneWayProperties);
        props.setProperties("mtb:scale=6", noneWayProperties);
        props.setProperties("highway=corridor", pedestrianWayProperties);
        props.setProperties("highway=steps", pedestrianWayProperties);
        props.setProperties("highway=crossing", pedestrianWayProperties);
        props.setProperties("highway=platform", pedestrianWayProperties);
        props.setProperties("public_transport=platform", pedestrianWayProperties);
        props.setProperties("railway=platform", pedestrianWayProperties);
        props.setProperties("footway=sidewalk;highway=footway", pedestrianWayProperties);
        props.setProperties("mtb:scale=1", pedestrianWayProperties);
        props.setProperties("mtb:scale=2", pedestrianWayProperties);
        props.setProperties("mtb:scale=0", pedestrianAndBicycleWayProperties);
        props.setProperties("highway=cycleway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.6));
        props.setProperties("highway=path", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties("highway=pedestrian", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.9));
        props.setProperties("highway=footway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.1));
        props.setProperties("highway=bridleway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.3));
        props.setProperties("highway=living_street", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.9));
        props.setProperties("highway=unclassified", allWayProperties);
        props.setProperties("highway=road", allWayProperties);
        props.setProperties("highway=byway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setProperties("highway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setProperties("highway=service", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1));
        props.setProperties("highway=residential", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=residential_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=tertiary", allWayProperties);
        props.setProperties("highway=tertiary_link", allWayProperties);
        props.setProperties("highway=secondary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setProperties("highway=secondary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setProperties("highway=primary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=primary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=trunk_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(2.06));
        props.setProperties("highway=motorway_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(2.06));
        props.setProperties("highway=trunk", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(7.47));
        props.setProperties("highway=motorway", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(8.0));
        props.setProperties("highway=*;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.87));
        props.setProperties("highway=service;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=residential;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=residential_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=tertiary;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.87));
        props.setProperties("highway=tertiary_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.87));
        props.setProperties("highway=secondary;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.96));
        props.setProperties("highway=secondary_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.96));
        props.setProperties("highway=primary;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.15));
        props.setProperties("highway=primary_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.15));
        props.setProperties("highway=trunk;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(1.5));
        props.setProperties("highway=trunk_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(1.15));
        props.setProperties("highway=motorway;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.0));
        props.setProperties("highway=motorway_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(1.15));
        props.setProperties("highway=*;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.92));
        props.setProperties("highway=service;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=residential;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=residential_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=tertiary;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.92));
        props.setProperties("highway=tertiary_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.92));
        props.setProperties("highway=secondary;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.99));
        props.setProperties("highway=secondary_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.99));
        props.setProperties("highway=primary;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.25));
        props.setProperties("highway=primary_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.25));
        props.setProperties("highway=trunk;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(1.75));
        props.setProperties("highway=trunk_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(1.25));
        props.setProperties("highway=motorway;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.5));
        props.setProperties("highway=motorway_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(1.25));
        props.setProperties("highway=*;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0, 0.87));
        props.setProperties("highway=service;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1, 0.77));
        props.setProperties("highway=residential;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98, 0.77));
        props.setProperties("highway=residential_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98, 0.77));
        props.setProperties("highway=tertiary;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0, 0.87));
        props.setProperties("highway=tertiary_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0, 0.87));
        props.setProperties("highway=secondary;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5, 0.96));
        props.setProperties("highway=secondary_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5, 0.96));
        props.setProperties("highway=primary;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06, 1.15));
        props.setProperties("highway=primary_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06, 1.15));
        props.setProperties("highway=trunk;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(7.47, 1.5));
        props.setProperties("highway=trunk_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.06, 1.15));
        props.setProperties("highway=*;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties("highway=service;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=residential;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=residential_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=tertiary;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.75));
        props.setProperties("highway=tertiary_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.75));
        props.setProperties("highway=secondary;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.8));
        props.setProperties("highway=secondary_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.8));
        props.setProperties("highway=primary;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=primary_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=trunk;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(0.95));
        props.setProperties("highway=trunk_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(0.85));
        props.setProperties("highway=*;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0, 0.75));
        props.setProperties("highway=service;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1, 0.65));
        props.setProperties("highway=residential;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98, 0.65));
        props.setProperties("highway=residential_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98, 0.65));
        props.setProperties("highway=tertiary;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0, 0.75));
        props.setProperties("highway=tertiary_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0, 0.75));
        props.setProperties("highway=secondary;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5, 0.8));
        props.setProperties("highway=secondary_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5, 0.8));
        props.setProperties("highway=primary;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06, 0.85));
        props.setProperties("highway=primary_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06, 0.85));
        props.setProperties("highway=trunk;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(7.47, 0.95));
        props.setProperties("highway=trunk_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.06, 0.85));
        props.setProperties("highway=*;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.77));
        props.setProperties("highway=service;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.73));
        props.setProperties("highway=residential;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=residential_link;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=tertiary;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.83));
        props.setProperties("highway=tertiary_link;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.83));
        props.setProperties("highway=secondary;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.25));
        props.setProperties("highway=secondary_link;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.25));
        props.setProperties("highway=primary;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.75));
        props.setProperties("highway=primary_link;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.75));
        props.setProperties("highway=*;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0, 1.4));
        props.setProperties("highway=service;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1));
        props.setProperties("highway=residential;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=residential_link;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=tertiary;cycleway=opposite", allWayProperties);
        props.setProperties("highway=tertiary_link;cycleway=opposite", allWayProperties);
        props.setProperties("highway=secondary;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5, 1.71));
        props.setProperties("highway=secondary_link;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5, 1.71));
        props.setProperties("highway=primary;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06, 2.99));
        props.setProperties("highway=primary_link;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06, 2.99));
        props.setProperties("highway=path;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.6));
        props.setProperties("highway=footway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties("highway=footway;bicycle=yes;area=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.9));
        props.setProperties("highway=pedestrian;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties("footway=sidewalk;highway=footway;bicycle=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(2.5));
        props.setProperties("footway=sidewalk;highway=footway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.1));
        props.setProperties("highway=footway;footway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(2.5));
        props.setProperties("highway=footway;footway=crossing;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.1));
        props.setProperties("highway=track;bicycle=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.18));
        props.setProperties("highway=track;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.99));
        props.setProperties("highway=track;bicycle=yes;surface=*", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.18));
        props.setProperties("highway=track;bicycle=designated;surface=*", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.99));
        props.setProperties("highway=track;surface=*", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.3));
        props.setProperties("highway=*;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.97));
        props.setProperties("highway=service;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.84));
        props.setProperties("highway=residential;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.95));
        props.setProperties("highway=unclassified;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.95));
        props.setProperties("highway=residential_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.95));
        props.setProperties("highway=tertiary;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.97));
        props.setProperties("highway=tertiary_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.97));
        props.setProperties("highway=secondary;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.46));
        props.setProperties("highway=secondary_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.46));
        props.setProperties("highway=primary;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.0));
        props.setProperties("highway=primary_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.0));
        props.setProperties("highway=trunk;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(7.25));
        props.setProperties("highway=trunk_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.0));
        props.setProperties("highway=motorway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(7.76));
        props.setProperties("highway=motorway_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.0));
        props.setMixinProperties(new LogicalOrSpecifier("lcn=yes", "rcn=yes", "ncn=yes"), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.7));
        props.setCarSpeed("highway=motorway", 29.0f);
        props.setCarSpeed("highway=motorway_link", 15.0f);
        props.setCarSpeed("highway=trunk", 24.6f);
        props.setCarSpeed("highway=trunk_link", 15.0f);
        props.setCarSpeed("highway=primary", 20.0f);
        props.setCarSpeed("highway=primary_link", 11.2f);
        props.setCarSpeed("highway=secondary", 15.0f);
        props.setCarSpeed("highway=secondary_link", 11.2f);
        props.setCarSpeed("highway=tertiary", 11.2f);
        props.setCarSpeed("highway=tertiary_link", 11.2f);
        props.setCarSpeed("highway=living_street", 2.2f);
        props.setCarSpeed("highway=pedestrian", 2.2f);
        props.setCarSpeed("highway=residential", 11.2f);
        props.setCarSpeed("highway=unclassified", 11.2f);
        props.setCarSpeed("highway=service", 6.7f);
        props.setCarSpeed("highway=track", 4.5f);
        props.setCarSpeed("highway=road", 11.2f);
        props.defaultSpeed = Float.valueOf(11.2f);
        props.setMixinProperties("surface=unpaved", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.18));
        props.setMixinProperties("surface=compacted", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.18));
        props.setMixinProperties("surface=wood", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.18));
        props.setMixinProperties("surface=cobblestone", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setMixinProperties("surface=cobblestone:flattened", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setMixinProperties("surface=grass_paver", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setMixinProperties("surface=pebblestone", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setMixinProperties("surface=metal", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setMixinProperties("surface=ground", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setMixinProperties("surface=dirt", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setMixinProperties("surface=earth", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setMixinProperties("surface=grass", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setMixinProperties("surface=mud", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setMixinProperties("surface=woodchip", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setMixinProperties("surface=gravel", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setMixinProperties("surface=artifical_turf", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setMixinProperties("surface=sand", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(100.0));
        props.setMixinProperties("RLIS:bicycle=caution_area", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.45));
        props.setMixinProperties("RLIS:bicycle:right=caution_area", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.45, 1.0));
        props.setMixinProperties("RLIS:bicycle:left=caution_area", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0, 1.45));
        props.setMixinProperties("CCGIS:bicycle=caution_area", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.45));
        props.setMixinProperties("CCGIS:bicycle:right=caution_area", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.45, 1.0));
        props.setMixinProperties("CCGIS:bicycle:left=caution_area", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0, 1.45));
        this.populateNotesAndNames(props);
        props.setSlopeOverride(new BestMatchSpecifier("bridge=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("embankment=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("tunnel=*"), true);
    }

    public void populateNotesAndNames(WayPropertySet props) {
        props.createNotes("RLIS:bicycle=caution_area", "note.caution", StreetNotesService.BICYCLE_MATCHER);
        props.createNotes("CCGIS:bicycle=caution_area", "note.caution", StreetNotesService.BICYCLE_MATCHER);
        props.createNotes("surface=unpaved", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=compacted", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=ground", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=dirt", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=earth", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=grass", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=mud", "note.muddy_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("toll=yes", "note.toll", StreetNotesService.DRIVING_MATCHER);
        props.createNotes("toll:motorcar=yes", "note.toll", StreetNotesService.DRIVING_MATCHER);
        props.createNames("highway=cycleway", "name.bike_path");
        props.createNames("cycleway=track", "name.bike_path");
        props.createNames("highway=pedestrian", "name.pedestrian_path");
        props.createNames("highway=pedestrian;area=yes", "name.pedestrian_area");
        props.createNames("highway=path", "name.path");
        props.createNames("highway=footway", "name.pedestrian_path");
        props.createNames("highway=bridleway", "name.bridleway");
        props.createNames("highway=footway;bicycle=no", "name.pedestrian_path");
        props.createNames("otp:route_ref=*", "name.otp_route_ref");
        props.createNames("highway=platform;ref=*", "name.platform_ref");
        props.createNames("railway=platform;ref=*", "name.platform_ref");
        props.createNames("railway=platform;highway=footway;footway=sidewalk", "name.platform");
        props.createNames("railway=platform;highway=path;path=sidewalk", "name.platform");
        props.createNames("railway=platform;highway=pedestrian", "name.platform");
        props.createNames("railway=platform;highway=path", "name.platform");
        props.createNames("railway=platform;highway=footway", "name.platform");
        props.createNames("highway=platform", "name.platform");
        props.createNames("railway=platform", "name.platform");
        props.createNames("railway=platform;highway=footway;bicycle=no", "name.platform");
        props.createNames("highway=pedestrian;bridge=*", "name.footbridge");
        props.createNames("highway=path;bridge=*", "name.footbridge");
        props.createNames("highway=footway;bridge=*", "name.footbridge");
        props.createNames("highway=pedestrian;tunnel=*", "name.underpass");
        props.createNames("highway=path;tunnel=*", "name.underpass");
        props.createNames("highway=footway;tunnel=*", "name.underpass");
        props.createNames("highway=motorway", "name.road");
        props.createNames("highway=motorway_link", "name.ramp");
        props.createNames("highway=trunk", "name.road");
        props.createNames("highway=trunk_link", "name.ramp");
        props.createNames("highway=primary", "name.road");
        props.createNames("highway=primary_link", "name.link");
        props.createNames("highway=secondary", "name.road");
        props.createNames("highway=secondary_link", "name.link");
        props.createNames("highway=tertiary", "name.road");
        props.createNames("highway=tertiary_link", "name.link");
        props.createNames("highway=unclassified", "name.road");
        props.createNames("highway=residential", "name.road");
        props.createNames("highway=living_street", "name.road");
        props.createNames("highway=road", "name.road");
        props.createNames("highway=service", "name.service_road");
        props.createNames("highway=service;service=alley", "name.alley");
        props.createNames("highway=service;service=parking_aisle", "name.parking_aisle");
        props.createNames("highway=byway", "name.byway");
        props.createNames("highway=track", "name.track");
        props.createNames("highway=footway;footway=sidewalk", "name.sidewalk");
        props.createNames("highway=path;path=sidewalk", "name.sidewalk");
        props.createNames("highway=steps", "name.steps");
        props.createNames("amenity=bicycle_parking;name=*", "name.bicycle_parking_name");
        props.createNames("amenity=bicycle_parking", "name.bicycle_parking");
        props.createNames("amenity=parking;name=*", "name.park_and_ride_name");
        props.createNames("amenity=parking", "name.park_and_ride_station");
    }
}

