/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.specifier;

import java.util.List;
import java.util.Objects;
import org.opentripplanner.graph_builder.module.osm.specifier.OsmSpecifier;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public class ExactMatchSpecifier
implements OsmSpecifier {
    public static final int MATCH_MULTIPLIER = 200;
    public static final int NO_MATCH_SCORE = 0;
    private final List<OsmSpecifier.Tag> pairs;
    private final int bestMatchScore;

    public ExactMatchSpecifier(String spec) {
        this.pairs = OsmSpecifier.getTagsFromString(spec, ";");
        if (this.pairs.stream().anyMatch(OsmSpecifier.Tag::isWildcard)) {
            throw new IllegalArgumentException("Wildcards are not allowed in %s".formatted(this.getClass().getSimpleName()));
        }
        this.bestMatchScore = this.pairs.size() * 200;
    }

    @Override
    public OsmSpecifier.Scores matchScores(OSMWithTags way) {
        return OsmSpecifier.Scores.of(this.matchScore(way));
    }

    @Override
    public int matchScore(OSMWithTags way) {
        if (this.allTagsMatch(way)) {
            return this.bestMatchScore;
        }
        return 0;
    }

    public boolean allTagsMatch(OSMWithTags way) {
        return this.pairs.stream().allMatch(p -> ExactMatchSpecifier.matchValue(way.getTag(p.key()), p.value()));
    }

    private static boolean matchValue(String wayValue, String specValue) {
        return Objects.nonNull(wayValue) && wayValue.equals(specValue);
    }
}

