/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.parameters;

import java.net.URI;
import java.time.ZoneId;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParameters;
import org.opentripplanner.graph_builder.module.osm.tagmapping.OsmTagMapper;

public class OsmExtractParametersBuilder {
    private URI source;
    private OsmTagMapper osmTagMapper;
    private ZoneId timeZone;

    public OsmExtractParametersBuilder withSource(URI source) {
        this.source = source;
        return this;
    }

    public OsmExtractParametersBuilder withOsmTagMapper(OsmTagMapper mapper) {
        this.osmTagMapper = mapper;
        return this;
    }

    public OsmExtractParametersBuilder withTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public URI getSource() {
        return this.source;
    }

    public OsmTagMapper getOsmTagMapper() {
        return this.osmTagMapper;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public OsmExtractParameters build() {
        return new OsmExtractParameters(this);
    }
}

