/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.graph_builder.module.osm.CreativeNamer;
import org.opentripplanner.graph_builder.module.osm.CreativeNamerPicker;
import org.opentripplanner.graph_builder.module.osm.NotePicker;
import org.opentripplanner.graph_builder.module.osm.NoteProperties;
import org.opentripplanner.graph_builder.module.osm.SafetyFeatures;
import org.opentripplanner.graph_builder.module.osm.SlopeOverridePicker;
import org.opentripplanner.graph_builder.module.osm.SpeedPicker;
import org.opentripplanner.graph_builder.module.osm.WayProperties;
import org.opentripplanner.graph_builder.module.osm.WayPropertiesBuilder;
import org.opentripplanner.graph_builder.module.osm.WayPropertyPicker;
import org.opentripplanner.graph_builder.module.osm.specifier.BestMatchSpecifier;
import org.opentripplanner.graph_builder.module.osm.specifier.OsmSpecifier;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.services.notes.NoteMatcher;
import org.opentripplanner.transit.model.basic.I18NString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WayPropertySet {
    private static final Logger LOG = LoggerFactory.getLogger(WayPropertySet.class);
    private final BiFunction<StreetTraversalPermission, Float, Double> DEFAULT_SAFETY_RESOLVER = (permission, speedLimit) -> 1.0;
    private final List<WayPropertyPicker> wayProperties;
    private final List<CreativeNamerPicker> creativeNamers;
    private final List<SlopeOverridePicker> slopeOverrides;
    private final List<SpeedPicker> speedPickers;
    private final List<NotePicker> notes;
    private final Pattern maxSpeedPattern;
    public Float defaultSpeed = Float.valueOf(11.2f);
    private BiFunction<StreetTraversalPermission, Float, Double> defaultWalkSafetyForPermission;
    private BiFunction<StreetTraversalPermission, Float, Double> defaultBicycleSafetyForPermission;
    private final WayProperties defaultProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).build();

    public WayPropertySet() {
        this.wayProperties = new ArrayList<WayPropertyPicker>();
        this.creativeNamers = new ArrayList<CreativeNamerPicker>();
        this.slopeOverrides = new ArrayList<SlopeOverridePicker>();
        this.speedPickers = new ArrayList<SpeedPicker>();
        this.notes = new ArrayList<NotePicker>();
        this.maxSpeedPattern = Pattern.compile("^([0-9][.0-9]*)\\s*(kmh|km/h|kmph|kph|mph|knots)?$");
        this.defaultWalkSafetyForPermission = this.DEFAULT_SAFETY_RESOLVER;
        this.defaultBicycleSafetyForPermission = this.DEFAULT_SAFETY_RESOLVER;
    }

    public WayProperties getDataForWay(OSMWithTags way) {
        WayProperties leftResult = this.defaultProperties;
        WayProperties rightResult = this.defaultProperties;
        int bestLeftScore = 0;
        int bestRightScore = 0;
        ArrayList<WayProperties> leftMixins = new ArrayList<WayProperties>();
        ArrayList<WayProperties> rightMixins = new ArrayList<WayProperties>();
        for (WayPropertyPicker picker : this.wayProperties) {
            OsmSpecifier specifier = picker.specifier();
            WayProperties wayProperties = picker.properties();
            OsmSpecifier.Scores score = specifier.matchScores(way);
            if (picker.safetyMixin()) {
                if (score.left() > 0) {
                    leftMixins.add(wayProperties);
                }
                if (score.right() <= 0) continue;
                rightMixins.add(wayProperties);
                continue;
            }
            if (score.left() > bestLeftScore) {
                leftResult = wayProperties;
                bestLeftScore = score.left();
            }
            if (score.right() <= bestRightScore) continue;
            rightResult = wayProperties;
            bestRightScore = score.right();
        }
        float forwardSpeed = this.getCarSpeedForWay(way, false);
        float backSpeed = this.getCarSpeedForWay(way, true);
        StreetTraversalPermission permission = rightResult.getPermission();
        WayProperties result = rightResult.mutate().bicycleSafety(rightResult.getBicycleSafetyFeatures() != null ? rightResult.getBicycleSafetyFeatures().forward() : this.defaultBicycleSafetyForPermission.apply(permission, Float.valueOf(forwardSpeed)), leftResult.getBicycleSafetyFeatures() != null ? leftResult.getBicycleSafetyFeatures().back() : this.defaultBicycleSafetyForPermission.apply(permission, Float.valueOf(backSpeed))).walkSafety(rightResult.getWalkSafetyFeatures() != null ? rightResult.getWalkSafetyFeatures().forward() : this.defaultWalkSafetyForPermission.apply(permission, Float.valueOf(forwardSpeed)), leftResult.getWalkSafetyFeatures() != null ? leftResult.getWalkSafetyFeatures().back() : this.defaultWalkSafetyForPermission.apply(permission, Float.valueOf(backSpeed))).build();
        if (leftMixins.size() > 0) {
            result = this.applyMixins(result, leftMixins, false);
        }
        if (rightMixins.size() > 0) {
            result = this.applyMixins(result, rightMixins, true);
        }
        if (!(bestLeftScore != 0 && bestRightScore != 0 || leftMixins.size() != 0 && rightMixins.size() != 0)) {
            String all_tags = this.dumpTags(way);
            LOG.debug("Used default permissions: {}", (Object)all_tags);
        }
        return result;
    }

    public I18NString getCreativeNameForWay(OSMWithTags way) {
        CreativeNamer bestNamer = null;
        int bestScore = 0;
        for (CreativeNamerPicker picker : this.creativeNamers) {
            OsmSpecifier specifier = picker.specifier;
            CreativeNamer namer = picker.namer;
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            bestNamer = namer;
            bestScore = score;
        }
        if (bestNamer == null) {
            return null;
        }
        return bestNamer.generateCreativeName(way);
    }

    public float getCarSpeedForWay(OSMWithTags way, boolean back) {
        Float speed = null;
        if (way.hasTag("maxspeed:motorcar")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:motorcar"));
        }
        if (speed == null && !back && way.hasTag("maxspeed:forward")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:forward"));
        }
        if (speed == null && back && way.hasTag("maxspeed:reverse")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:reverse"));
        }
        if (speed == null && way.hasTag("maxspeed:lanes")) {
            for (String lane : way.getTag("maxspeed:lanes").split("\\|")) {
                Float currentSpeed = this.getMetersSecondFromSpeed(lane);
                if (currentSpeed == null || speed != null && !(currentSpeed.floatValue() > speed.floatValue())) continue;
                speed = currentSpeed;
            }
        }
        if (way.hasTag("maxspeed") && speed == null) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed"));
        }
        if (speed != null && (double)speed.floatValue() < 1.0E-4) {
            LOG.warn("Zero or negative automobile speed detected at {} based on OSM maxspeed tags; ignoring these tags", (Object)this);
        }
        if (speed != null && (double)speed.floatValue() > 1.0E-4) {
            return speed.floatValue();
        }
        int bestScore = 0;
        Float bestSpeed = null;
        for (SpeedPicker picker : this.speedPickers) {
            OsmSpecifier specifier = picker.specifier;
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            bestScore = score;
            bestSpeed = Float.valueOf(picker.speed);
        }
        if (bestSpeed != null) {
            return bestSpeed.floatValue();
        }
        return this.defaultSpeed.floatValue();
    }

    public Set<T2<StreetNote, NoteMatcher>> getNoteForWay(OSMWithTags way) {
        HashSet<T2<StreetNote, NoteMatcher>> out = new HashSet<T2<StreetNote, NoteMatcher>>();
        for (NotePicker picker : this.notes) {
            OsmSpecifier specifier = picker.specifier;
            NoteProperties noteProperties = picker.noteProperties;
            if (specifier.matchScore(way) <= 0) continue;
            out.add(noteProperties.generateNote(way));
        }
        if (out.size() == 0) {
            return null;
        }
        return out;
    }

    public boolean getSlopeOverride(OSMWithTags way) {
        boolean result = false;
        int bestScore = 0;
        for (SlopeOverridePicker picker : this.slopeOverrides) {
            OsmSpecifier specifier = picker.getSpecifier();
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            result = picker.getOverride();
            bestScore = score;
        }
        return result;
    }

    public void addProperties(OsmSpecifier spec, WayProperties properties, boolean mixin) {
        this.wayProperties.add(new WayPropertyPicker(spec, properties, mixin));
    }

    public void addProperties(OsmSpecifier spec, WayProperties properties) {
        this.wayProperties.add(new WayPropertyPicker(spec, properties, false));
    }

    public void addCreativeNamer(OsmSpecifier spec, CreativeNamer namer) {
        this.creativeNamers.add(new CreativeNamerPicker(spec, namer));
    }

    public void addNote(OsmSpecifier osmSpecifier, NoteProperties properties) {
        this.notes.add(new NotePicker(osmSpecifier, properties));
    }

    public void setSlopeOverride(OsmSpecifier spec, boolean override) {
        this.slopeOverrides.add(new SlopeOverridePicker(spec, override));
    }

    public int hashCode() {
        return this.defaultProperties.hashCode() + this.wayProperties.hashCode() + this.creativeNamers.hashCode() + this.slopeOverrides.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof WayPropertySet) {
            WayPropertySet other = (WayPropertySet)o;
            return this.defaultProperties.equals(other.defaultProperties) && this.wayProperties.equals(other.wayProperties) && this.creativeNamers.equals(other.creativeNamers) && this.slopeOverrides.equals(other.slopeOverrides) && this.notes.equals(other.notes);
        }
        return false;
    }

    public void addSpeedPicker(SpeedPicker picker) {
        this.speedPickers.add(picker);
    }

    public Float getMetersSecondFromSpeed(String speed) {
        float metersSecond;
        float originalUnits;
        Matcher m = this.maxSpeedPattern.matcher(speed.trim());
        if (!m.matches()) {
            return null;
        }
        try {
            originalUnits = (float)Double.parseDouble(m.group(1));
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse max speed {}", (Object)m.group(1));
            return null;
        }
        String units = m.group(2);
        if (units == null || units.equals("")) {
            units = "kmh";
        }
        switch (units = units.intern()) {
            case "kmh": 
            case "km/h": 
            case "kmph": 
            case "kph": {
                metersSecond = 0.277778f * originalUnits;
                break;
            }
            case "mph": {
                metersSecond = 0.446944f * originalUnits;
                break;
            }
            case "knots": {
                metersSecond = 0.514444f * originalUnits;
                break;
            }
            default: {
                return null;
            }
        }
        return Float.valueOf(metersSecond);
    }

    public void createNames(String spec, String patternKey) {
        CreativeNamer namer = new CreativeNamer(patternKey);
        this.addCreativeNamer(new BestMatchSpecifier(spec), namer);
    }

    public void createNotes(String spec, String patternKey, NoteMatcher matcher) {
        NoteProperties properties = new NoteProperties(patternKey, matcher);
        this.addNote(new BestMatchSpecifier(spec), properties);
    }

    public void setDefaultWalkSafetyForPermission(BiFunction<StreetTraversalPermission, Float, Double> defaultWalkSafetyForPermission) {
        if (!this.defaultWalkSafetyForPermission.equals(this.DEFAULT_SAFETY_RESOLVER)) {
            throw new IllegalStateException("A custom default walk safety resolver was already set");
        }
        this.defaultWalkSafetyForPermission = defaultWalkSafetyForPermission;
    }

    public void setDefaultBicycleSafetyForPermission(BiFunction<StreetTraversalPermission, Float, Double> defaultBicycleSafetyForPermission) {
        if (!this.defaultBicycleSafetyForPermission.equals(this.DEFAULT_SAFETY_RESOLVER)) {
            throw new IllegalStateException("A custom default cycling safety resolver was already set");
        }
        this.defaultBicycleSafetyForPermission = defaultBicycleSafetyForPermission;
    }

    public void setMixinProperties(OsmSpecifier spec, WayPropertiesBuilder properties) {
        this.addProperties(spec, properties.build(), true);
    }

    public void setMixinProperties(String spec, WayPropertiesBuilder properties) {
        this.setMixinProperties(spec, properties.build());
    }

    public void setMixinProperties(String spec, WayProperties properties) {
        this.addProperties(new BestMatchSpecifier(spec), properties, true);
    }

    public void setProperties(String s, WayProperties props) {
        this.setProperties((OsmSpecifier)new BestMatchSpecifier(s), props);
    }

    public void setProperties(String spec, WayPropertiesBuilder properties) {
        this.setProperties((OsmSpecifier)new BestMatchSpecifier(spec), properties);
    }

    public void setProperties(OsmSpecifier spec, WayProperties properties) {
        this.addProperties(spec, properties, false);
    }

    public void setProperties(OsmSpecifier spec, WayPropertiesBuilder properties) {
        this.addProperties(spec, properties.build(), false);
    }

    public void setCarSpeed(String spec, float speed) {
        SpeedPicker picker = new SpeedPicker();
        picker.specifier = new BestMatchSpecifier(spec);
        picker.speed = speed;
        this.addSpeedPicker(picker);
    }

    public List<WayPropertyPicker> getWayProperties() {
        return Collections.unmodifiableList(this.wayProperties);
    }

    private String dumpTags(OSMWithTags way) {
        String all_tags = null;
        Map<String, String> tags = way.getTags();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String tag = key + "=" + value;
            if (all_tags == null) {
                all_tags = tag;
                continue;
            }
            all_tags = all_tags + "; " + tag;
        }
        return all_tags;
    }

    private WayProperties applyMixins(WayProperties result, List<WayProperties> mixins, boolean right) {
        SafetyFeatures bicycleSafetyFeatures = result.getBicycleSafetyFeatures();
        double forwardBicycle = bicycleSafetyFeatures.forward();
        double backBicycle = bicycleSafetyFeatures.back();
        SafetyFeatures walkSafetyFeatures = result.getWalkSafetyFeatures();
        double forwardWalk = walkSafetyFeatures.forward();
        double backWalk = walkSafetyFeatures.back();
        for (WayProperties properties : mixins) {
            if (right) {
                if (properties.getBicycleSafetyFeatures() != null) {
                    backBicycle *= properties.getBicycleSafetyFeatures().back().doubleValue();
                }
                if (properties.getWalkSafetyFeatures() == null) continue;
                backWalk *= properties.getWalkSafetyFeatures().back().doubleValue();
                continue;
            }
            if (properties.getBicycleSafetyFeatures() != null) {
                forwardBicycle *= properties.getBicycleSafetyFeatures().forward().doubleValue();
            }
            if (properties.getWalkSafetyFeatures() == null) continue;
            forwardWalk *= properties.getWalkSafetyFeatures().forward().doubleValue();
        }
        return result.mutate().bicycleSafety(forwardBicycle, backBicycle).walkSafety(forwardWalk, backWalk).build();
    }
}

