/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.geometry;

import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;

class IndexedLineSegment {
    private static final double RADIUS = 6371010.0;
    private final double lineLength;
    int index;
    Coordinate start;
    Coordinate end;

    public IndexedLineSegment(int index, Coordinate start, Coordinate end) {
        this.index = index;
        this.start = start;
        this.end = end;
        this.lineLength = SphericalDistanceLibrary.fastDistance(start, end);
    }

    public double fraction(Coordinate coord) {
        double cte = this.crossTrackError(coord);
        double distanceToStart = SphericalDistanceLibrary.fastDistance(coord, this.start);
        double distanceToEnd = SphericalDistanceLibrary.fastDistance(coord, this.end);
        if (cte < distanceToStart && cte < distanceToEnd) {
            double atd = this.alongTrackDistance(coord, cte);
            return atd / this.lineLength;
        }
        if (distanceToStart < distanceToEnd) {
            return 0.0;
        }
        return 1.0;
    }

    static double bearing(Coordinate c1, Coordinate c2) {
        double deltaLon = (c2.x - c1.x) * Math.PI / 180.0;
        double lat1Radians = c1.y * Math.PI / 180.0;
        double lat2Radians = c2.y * Math.PI / 180.0;
        double y = Math.sin(deltaLon) * Math.cos(lat2Radians);
        double x = Math.cos(lat1Radians) * Math.sin(lat2Radians) - Math.sin(lat1Radians) * Math.cos(lat2Radians) * Math.cos(deltaLon);
        return Math.atan2(y, x);
    }

    double crossTrackError(Coordinate coord) {
        double distanceFromStart = SphericalDistanceLibrary.fastDistance(this.start, coord);
        double bearingToCoord = IndexedLineSegment.bearing(this.start, coord);
        double bearingToEnd = IndexedLineSegment.bearing(this.start, this.end);
        return Math.asin(Math.sin(distanceFromStart / 6371010.0) * Math.sin(bearingToCoord - bearingToEnd)) * 6371010.0;
    }

    double distance(Coordinate coord) {
        double distanceToEnd;
        double cte = this.crossTrackError(coord);
        double atd = this.alongTrackDistance(coord, cte);
        double inverseAtd = this.inverseAlongTrackDistance(coord, -cte);
        double distanceToStart = SphericalDistanceLibrary.fastDistance(coord, this.start);
        if (distanceToStart < (distanceToEnd = SphericalDistanceLibrary.fastDistance(coord, this.end))) {
            if (inverseAtd > this.lineLength) {
                return distanceToStart;
            }
            return Math.abs(cte);
        }
        if (atd > this.lineLength) {
            return distanceToEnd;
        }
        return Math.abs(cte);
    }

    private double inverseAlongTrackDistance(Coordinate coord, double inverseCrossTrackError) {
        double distanceFromEnd = SphericalDistanceLibrary.fastDistance(this.end, coord);
        return Math.acos(Math.cos(distanceFromEnd / 6371010.0) / Math.cos(inverseCrossTrackError / 6371010.0)) * 6371010.0;
    }

    private double alongTrackDistance(Coordinate coord, double crossTrackError) {
        double distanceFromStart = SphericalDistanceLibrary.fastDistance(this.start, coord);
        return Math.acos(Math.cos(distanceFromStart / 6371010.0) / Math.cos(crossTrackError / 6371010.0)) * 6371010.0;
    }
}

