/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.graph_builder.linking.LinkingDirection;
import org.opentripplanner.graph_builder.linking.VertexLinker;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.AreaEdge;
import org.opentripplanner.routing.edgetype.AreaEdgeList;
import org.opentripplanner.routing.edgetype.BoardingLocationToStopLink;
import org.opentripplanner.routing.edgetype.NamedArea;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTransitStopLink;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.vertextype.OsmBoardingLocationVertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.LocalizedString;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmBoardingLocationsModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(OsmBoardingLocationsModule.class);
    private final double searchRadiusDegrees = SphericalDistanceLibrary.metersToDegrees(250.0);
    private final Graph graph;
    private final TransitModel transitModel;
    private VertexLinker linker;

    @Inject
    public OsmBoardingLocationsModule(Graph graph, TransitModel transitModel) {
        this.graph = graph;
        this.transitModel = transitModel;
    }

    @Override
    public void buildGraph() {
        LOG.info("Improving boarding locations by checking OSM entities...");
        StreetVertexIndex streetIndex = this.graph.getStreetIndexSafe(this.transitModel.getStopModel());
        this.linker = streetIndex.getVertexLinker();
        int successes = 0;
        for (TransitStopVertex ts : this.graph.getVerticesOfType(TransitStopVertex.class)) {
            boolean alreadyLinked = false;
            for (Edge e : ts.getOutgoing()) {
                if (!(e instanceof StreetTransitStopLink)) continue;
                alreadyLinked = true;
                break;
            }
            if (alreadyLinked || ts.hasPathways()) continue;
            if (!this.connectVertexToStop(ts, streetIndex, this.graph)) {
                LOG.debug("Could not connect {} at {}", (Object)ts.getStop().getCode(), (Object)ts.getCoordinate());
                continue;
            }
            ++successes;
        }
        LOG.info("Found {} OSM references which match a stop's id or code", (Object)successes);
    }

    @Override
    public void checkInputs() {
    }

    private boolean connectVertexToStop(TransitStopVertex ts, StreetVertexIndex index, Graph graph) {
        String stopCode = ts.getStop().getCode();
        String stopId = ts.getStop().getId().getId();
        Envelope envelope = new Envelope(ts.getCoordinate());
        double xscale = Math.cos(ts.getCoordinate().y * Math.PI / 180.0);
        envelope.expandBy(this.searchRadiusDegrees / xscale, this.searchRadiusDegrees);
        Set nearbyBoardingLocations = index.getVerticesForEnvelope(envelope).stream().filter(OsmBoardingLocationVertex.class::isInstance).map(OsmBoardingLocationVertex.class::cast).collect(Collectors.toSet());
        for (OsmBoardingLocationVertex boardingLocation : nearbyBoardingLocations) {
            if ((stopCode == null || !boardingLocation.references.contains(stopCode)) && !boardingLocation.references.contains(stopId)) continue;
            if (!boardingLocation.isConnectedToStreetNetwork()) {
                this.linker.linkVertexPermanently(boardingLocation, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BOTH_WAYS, (osmBoardingLocationVertex, splitVertex) -> List.of(this.linkBoardingLocationToStreetNetwork(boardingLocation, (StreetVertex)splitVertex), this.linkBoardingLocationToStreetNetwork((StreetVertex)splitVertex, boardingLocation)));
            }
            this.linkBoardingLocationToStop(ts, stopCode, boardingLocation);
            return true;
        }
        Set nearbyEdgeLists = index.getEdgesForEnvelope(envelope).stream().filter(AreaEdge.class::isInstance).map(AreaEdge.class::cast).map(AreaEdge::getArea).collect(Collectors.toSet());
        for (AreaEdgeList edgeList : nearbyEdgeLists) {
            if ((stopCode == null || !edgeList.references.contains(stopCode)) && !edgeList.references.contains(stopId)) continue;
            I18NString name = edgeList.getAreas().stream().findFirst().map(NamedArea::getName).orElse(new LocalizedString("name.platform"));
            String label = "platform-centroid/%s".formatted(ts.getStop().getId().toString());
            Point centroid = edgeList.getGeometry().getCentroid();
            OsmBoardingLocationVertex boardingLocation = new OsmBoardingLocationVertex(graph, label, centroid.getX(), centroid.getY(), name, edgeList.references);
            edgeList.addVertex(boardingLocation);
            this.linkBoardingLocationToStop(ts, stopCode, boardingLocation);
            return true;
        }
        return false;
    }

    private StreetEdge linkBoardingLocationToStreetNetwork(StreetVertex from, StreetVertex to) {
        LineString line = GeometryUtils.makeLineString(List.of(from.getCoordinate(), to.getCoordinate()));
        return new StreetEdge(from, to, line, new LocalizedString("name.platform"), SphericalDistanceLibrary.length(line), StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, false);
    }

    private void linkBoardingLocationToStop(TransitStopVertex ts, String stopCode, OsmBoardingLocationVertex boardingLocation) {
        new BoardingLocationToStopLink(ts, boardingLocation);
        new BoardingLocationToStopLink(boardingLocation, ts);
        LOG.debug("Connected {} ({}) to {} at {}", new Object[]{ts, stopCode, boardingLocation.getLabel(), boardingLocation.getCoordinate()});
    }
}

