/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import com.csvreader.CsvReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.onebusaway.csv_entities.CsvInputSource;

public class GtfsFeedId {
    private static int FEED_ID_COUNTER = 1;
    private final String id;

    private GtfsFeedId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static class Builder {
        private String id;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder fromGtfsFeed(CsvInputSource source) {
            block8: {
                try {
                    if (!source.hasResource("feed_info.txt")) break block8;
                    try (InputStream feedInfoInputStream = source.getResource("feed_info.txt");){
                        CsvReader result = new CsvReader(feedInfoInputStream, StandardCharsets.UTF_8);
                        result.readHeaders();
                        result.readRecord();
                        this.id = result.get("feed_id");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        public GtfsFeedId build() {
            this.id = this.cleanId(this.id);
            if (this.id == null || this.id.trim().length() == 0) {
                this.id = String.valueOf(FEED_ID_COUNTER);
            }
            ++FEED_ID_COUNTER;
            return new GtfsFeedId(this.id);
        }

        protected String cleanId(String id) {
            if (id == null || id.trim().length() == 0) {
                return id;
            }
            return id.replaceAll("_", "").replaceAll(":", "");
        }
    }
}

