/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.StopNotLinkedForTransfers;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.NearbyStopFinder;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectTransferGenerator
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(DirectTransferGenerator.class);
    private final Duration radiusByDuration;
    private final List<RouteRequest> transferRequests;
    private final Graph graph;
    private final TransitModel transitModel;
    private final DataImportIssueStore issueStore;

    public DirectTransferGenerator(Graph graph, TransitModel transitModel, DataImportIssueStore issueStore, Duration radiusByDuration, List<RouteRequest> transferRequests) {
        this.graph = graph;
        this.transitModel = transitModel;
        this.issueStore = issueStore;
        this.radiusByDuration = radiusByDuration;
        this.transferRequests = transferRequests;
    }

    @Override
    public void buildGraph() {
        if (this.transitModel.getTransitModelIndex() == null) {
            this.transitModel.index();
        }
        NearbyStopFinder nearbyStopFinder = new NearbyStopFinder(new DefaultTransitService(this.transitModel), this.radiusByDuration, null, this.graph.hasStreets);
        if (nearbyStopFinder.useStreets) {
            LOG.info("Creating direct transfer edges between stops using the street network from OSM...");
        } else {
            LOG.info("Creating direct transfer edges between stops using straight line distance (not streets)...");
        }
        List<TransitStopVertex> stops = this.graph.getVerticesOfType(TransitStopVertex.class);
        ProgressTracker progress = ProgressTracker.track("Create transfer edges for stops", 1000, stops.size());
        AtomicInteger nTransfersTotal = new AtomicInteger();
        AtomicInteger nLinkedStops = new AtomicInteger();
        Multimap transfersByStop = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        ((Stream)stops.stream().parallel()).forEach(ts0 -> {
            HashMap<TransferKey, PathTransfer> distinctTransfers = new HashMap<TransferKey, PathTransfer>();
            RegularStop stop = ts0.getStop();
            if (stop.transfersNotAllowed()) {
                return;
            }
            LOG.debug("Linking stop '{}' {}", (Object)stop, ts0);
            for (RouteRequest transferProfile : this.transferRequests) {
                RouteRequest streetRequest = transferProfile.copyAndPrepareForTransferRouting();
                for (NearbyStop sd : DirectTransferGenerator.findNearbyStops(nearbyStopFinder, ts0, streetRequest, transferProfile.journey().transfer(), false)) {
                    if (sd.stop == stop || sd.stop.transfersNotAllowed()) continue;
                    distinctTransfers.put(new TransferKey(stop, sd.stop, sd.edges), new PathTransfer(stop, sd.stop, sd.distance, sd.edges));
                }
                if (!OTPFeature.FlexRouting.isOn()) continue;
                for (NearbyStop sd : DirectTransferGenerator.findNearbyStops(nearbyStopFinder, ts0, streetRequest, transferProfile.journey().transfer(), true)) {
                    if (sd.stop == stop || sd.stop instanceof RegularStop) continue;
                    distinctTransfers.put(new TransferKey(sd.stop, stop, sd.edges), new PathTransfer(sd.stop, stop, sd.distance, sd.edges));
                }
            }
            LOG.debug("Linked stop {} with {} transfers to stops with different patterns.", (Object)stop, (Object)distinctTransfers.size());
            if (distinctTransfers.isEmpty()) {
                this.issueStore.add(new StopNotLinkedForTransfers((TransitStopVertex)ts0));
            } else {
                distinctTransfers.values().forEach(transfer -> transfersByStop.put((Object)transfer.from, transfer));
                nLinkedStops.incrementAndGet();
                nTransfersTotal.addAndGet(distinctTransfers.size());
            }
            progress.step(m -> LOG.info(m));
        });
        this.transitModel.addAllTransfersByStops((Multimap<StopLocation, PathTransfer>)transfersByStop);
        LOG.info(progress.completeMessage());
        LOG.info("Done connecting stops to one another. Created a total of {} transfers from {} stops.", (Object)nTransfersTotal, (Object)nLinkedStops);
    }

    @Override
    public void checkInputs() {
    }

    private static Iterable<NearbyStop> findNearbyStops(NearbyStopFinder nearbyStopFinder, Vertex vertex, RouteRequest request, StreetRequest streetRequest, boolean reverseDirection) {
        return OTPFeature.ConsiderPatternsForDirectTransfers.isOn() ? nearbyStopFinder.findNearbyStopsConsideringPatterns(vertex, request, streetRequest, reverseDirection) : nearbyStopFinder.findNearbyStops(vertex, request, streetRequest, reverseDirection);
    }

    private static class TransferKey {
        private final StopLocation source;
        private final StopLocation target;
        private final List<Edge> edges;

        private TransferKey(StopLocation source, StopLocation target, List<Edge> edges) {
            this.source = source;
            this.target = target;
            this.edges = edges;
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target, this.edges);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransferKey that = (TransferKey)o;
            return this.source.equals(that.source) && this.target.equals(that.target) && Objects.equals(this.edges, that.edges);
        }
    }
}

