/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.routing.edgetype.ElevatorAlightEdge;
import org.opentripplanner.routing.edgetype.ElevatorBoardEdge;
import org.opentripplanner.routing.edgetype.ElevatorHopEdge;
import org.opentripplanner.routing.edgetype.PathwayEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.ElevatorOffboardVertex;
import org.opentripplanner.routing.vertextype.ElevatorOnboardVertex;
import org.opentripplanner.routing.vertextype.TransitBoardingAreaVertex;
import org.opentripplanner.routing.vertextype.TransitEntranceVertex;
import org.opentripplanner.routing.vertextype.TransitPathwayNodeVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertexBuilder;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.transit.model.site.Pathway;
import org.opentripplanner.transit.model.site.PathwayMode;
import org.opentripplanner.transit.model.site.PathwayNode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationElement;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTransitModelEntitiesToGraph {
    private static final Logger LOG = LoggerFactory.getLogger(AddTransitModelEntitiesToGraph.class);
    private final OtpTransitService otpTransitService;
    private final Map<StationElement<?, ?>, Vertex> stationElementNodes = new HashMap();
    private final int subwayAccessTime;

    private AddTransitModelEntitiesToGraph(OtpTransitService otpTransitService, int subwayAccessTime) {
        this.otpTransitService = otpTransitService;
        this.subwayAccessTime = Math.max(subwayAccessTime, 0);
    }

    public static void addToGraph(OtpTransitService otpTransitService, int subwayAccessTime, Graph graph, TransitModel transitModel) {
        new AddTransitModelEntitiesToGraph(otpTransitService, subwayAccessTime).applyToGraph(graph, transitModel);
    }

    private void applyToGraph(Graph graph, TransitModel transitModel) {
        transitModel.mergeStopModels(this.otpTransitService.stopModel());
        this.addStopsToGraphAndGenerateStopVertexes(graph, transitModel);
        this.addEntrancesToGraph(graph);
        this.addPathwayNodesToGraph(graph);
        this.addBoardingAreasToGraph(graph);
        this.createPathwayEdgesAndAddThemToGraph(graph);
        this.addFeedInfoToGraph(transitModel);
        this.addAgenciesToGraph(transitModel);
        this.addServicesToTransitModel(transitModel);
        this.addTripPatternsToTransitModel(transitModel);
        this.addTransfersToGraph(transitModel);
        if (OTPFeature.FlexRouting.isOn()) {
            this.addFlexTripsToGraph(transitModel);
        }
    }

    private void addStopsToGraphAndGenerateStopVertexes(Graph graph, TransitModel transitModel) {
        HashMap<StopLocation, Set> stopModeMap = new HashMap<StopLocation, Set>();
        for (TripPattern pattern : this.otpTransitService.getTripPatterns()) {
            TransitMode mode = pattern.getMode();
            transitModel.addTransitMode(mode);
            for (StopLocation stop : pattern.getStops()) {
                Set set = stopModeMap.computeIfAbsent(stop, s -> new HashSet());
                set.add(mode);
            }
        }
        for (RegularStop stop : this.otpTransitService.stopModel().listRegularStops()) {
            Set modes = (Set)stopModeMap.get(stop);
            TransitStopVertex stopVertex = new TransitStopVertexBuilder().withStop(stop).withGraph(graph).withModes(modes).build();
            if (modes != null && modes.contains((Object)TransitMode.SUBWAY)) {
                stopVertex.setStreetToStopTime(this.subwayAccessTime);
            }
            this.stationElementNodes.put(stop, stopVertex);
        }
    }

    private void addEntrancesToGraph(Graph graph) {
        for (Entrance entrance : this.otpTransitService.getAllEntrances()) {
            TransitEntranceVertex entranceVertex = new TransitEntranceVertex(graph, entrance);
            this.stationElementNodes.put(entrance, entranceVertex);
        }
    }

    private void addPathwayNodesToGraph(Graph graph) {
        for (PathwayNode node : this.otpTransitService.getAllPathwayNodes()) {
            TransitPathwayNodeVertex nodeVertex = new TransitPathwayNodeVertex(graph, node);
            this.stationElementNodes.put(node, nodeVertex);
        }
    }

    private void addBoardingAreasToGraph(Graph graph) {
        for (BoardingArea boardingArea : this.otpTransitService.getAllBoardingAreas()) {
            TransitBoardingAreaVertex boardingAreaVertex = new TransitBoardingAreaVertex(graph, boardingArea);
            this.stationElementNodes.put(boardingArea, boardingAreaVertex);
            if (boardingArea.getParentStop() == null) continue;
            Vertex platformVertex = this.stationElementNodes.get(boardingArea.getParentStop());
            boolean wheelchair = boardingArea.getWheelchairAccessibility() == Accessibility.POSSIBLE;
            PathwayEdge.lowCost(boardingAreaVertex, platformVertex, boardingArea.getId(), boardingArea.getName(), wheelchair, PathwayMode.WALKWAY);
            PathwayEdge.lowCost(platformVertex, boardingAreaVertex, boardingArea.getId(), boardingArea.getName(), wheelchair, PathwayMode.WALKWAY);
        }
    }

    private void createPathwayEdgesAndAddThemToGraph(Graph graph) {
        for (Pathway pathway : this.otpTransitService.getAllPathways()) {
            Vertex fromVertex = this.stationElementNodes.get(pathway.getFromStop());
            Vertex toVertex = this.stationElementNodes.get(pathway.getToStop());
            if (fromVertex != null && toVertex != null) {
                if (pathway.getPathwayMode() == PathwayMode.ELEVATOR) {
                    this.createElevatorEdgesAndAddThemToGraph(graph, pathway, fromVertex, toVertex);
                    continue;
                }
                double distance = Optional.of(pathway.getLength()).filter(l -> l > 0.0).orElseGet(() -> SphericalDistanceLibrary.distance(fromVertex.getCoordinate(), toVertex.getCoordinate()));
                new PathwayEdge(fromVertex, toVertex, pathway.getId(), NonLocalizedString.ofNullable(pathway.getName()), pathway.getTraversalTime(), distance, pathway.getStairCount(), pathway.getSlope(), pathway.isPathwayModeWheelchairAccessible(), pathway.getPathwayMode());
                if (!pathway.isBidirectional()) continue;
                new PathwayEdge(toVertex, fromVertex, pathway.getId(), NonLocalizedString.ofNullable(pathway.getReversedName()), pathway.getTraversalTime(), distance, -1 * pathway.getStairCount(), -1.0 * pathway.getSlope(), pathway.isPathwayModeWheelchairAccessible(), pathway.getPathwayMode());
                continue;
            }
            if (fromVertex == null) {
                LOG.warn("The 'fromVertex' is missing for pathway from stop {}", pathway.getFromStop());
            }
            if (toVertex != null) continue;
            LOG.warn("The 'toVertex' is missing for pathway to stop {}", pathway.getToStop());
        }
    }

    private void createElevatorEdgesAndAddThemToGraph(Graph graph, Pathway pathway, Vertex fromVertex, Vertex toVertex) {
        StationElement fromStation = fromVertex.getStationElement();
        I18NString fromVertexLevelName = fromStation == null || fromStation.getLevelName() == null ? fromVertex.getName() : new NonLocalizedString(fromStation.getLevelName());
        Double fromVertexLevelIndex = fromStation == null ? null : fromStation.getLevelIndex();
        StationElement toStation = toVertex.getStationElement();
        I18NString toVertexLevelName = toStation == null || toStation.getLevelName() == null ? toVertex.getName() : new NonLocalizedString(toStation.getLevelName());
        Double toVertexLevelIndex = toStation == null ? null : toStation.getLevelIndex();
        double levels = 1.0;
        if (fromVertexLevelIndex != null && toVertexLevelIndex != null && !fromVertexLevelIndex.equals(toVertexLevelIndex)) {
            levels = Math.abs(fromVertexLevelIndex - toVertexLevelIndex);
        }
        ElevatorOffboardVertex fromOffboardVertex = new ElevatorOffboardVertex(graph, fromVertex.getLabel() + "_" + pathway.getId() + "_offboard", fromVertex.getX(), fromVertex.getY(), fromVertexLevelName);
        ElevatorOffboardVertex toOffboardVertex = new ElevatorOffboardVertex(graph, toVertex.getLabel() + "_" + pathway.getId() + "_offboard", toVertex.getX(), toVertex.getY(), toVertexLevelName);
        PathwayEdge.lowCost(fromVertex, fromOffboardVertex, fromVertex.getName(), PathwayMode.ELEVATOR);
        PathwayEdge.lowCost(toOffboardVertex, toVertex, toVertex.getName(), PathwayMode.ELEVATOR);
        ElevatorOnboardVertex fromOnboardVertex = new ElevatorOnboardVertex(graph, fromVertex.getLabel() + "_" + pathway.getId() + "_onboard", fromVertex.getX(), fromVertex.getY(), fromVertexLevelName);
        ElevatorOnboardVertex toOnboardVertex = new ElevatorOnboardVertex(graph, toVertex.getLabel() + "_" + pathway.getId() + "_onboard", toVertex.getX(), toVertex.getY(), toVertexLevelName);
        new ElevatorBoardEdge(fromOffboardVertex, fromOnboardVertex);
        new ElevatorAlightEdge(toOnboardVertex, toOffboardVertex, toVertexLevelName);
        StreetTraversalPermission permission = StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE;
        new ElevatorHopEdge(fromOnboardVertex, toOnboardVertex, permission, Accessibility.POSSIBLE, levels, pathway.getTraversalTime());
        if (pathway.isBidirectional()) {
            PathwayEdge.lowCost(fromOffboardVertex, fromVertex, fromVertex.getName(), PathwayMode.ELEVATOR);
            PathwayEdge.lowCost(toVertex, toOffboardVertex, toVertex.getName(), PathwayMode.ELEVATOR);
            new ElevatorBoardEdge(toOffboardVertex, toOnboardVertex);
            new ElevatorAlightEdge(fromOnboardVertex, fromOffboardVertex, fromVertexLevelName);
            new ElevatorHopEdge(toOnboardVertex, fromOnboardVertex, permission, Accessibility.POSSIBLE, levels, pathway.getTraversalTime());
        }
    }

    private void addFeedInfoToGraph(TransitModel transitModel) {
        for (FeedInfo info : this.otpTransitService.getAllFeedInfos()) {
            transitModel.addFeedInfo(info);
        }
    }

    private void addAgenciesToGraph(TransitModel transitModel) {
        for (Agency agency : this.otpTransitService.getAllAgencies()) {
            transitModel.addAgency(agency);
        }
    }

    private void addTransfersToGraph(TransitModel transitModel) {
        transitModel.getTransferService().addAll(this.otpTransitService.getAllTransfers());
    }

    private void addServicesToTransitModel(TransitModel transitModel) {
        for (FeedScopedId serviceId : this.otpTransitService.getAllServiceIds()) {
            transitModel.getServiceCodes().put(serviceId, transitModel.getServiceCodes().size());
        }
    }

    private void addTripPatternsToTransitModel(TransitModel transitModel) {
        Collection<TripPattern> tripPatterns = this.otpTransitService.getTripPatterns();
        for (TripPattern tripPattern : tripPatterns) {
            tripPattern.getScheduledTimetable().setServiceCodes(transitModel.getServiceCodes());
            transitModel.addTripPattern(tripPattern.getId(), tripPattern);
        }
    }

    private void addFlexTripsToGraph(TransitModel transitModel) {
        for (FlexTrip<?, ?> flexTrip : this.otpTransitService.getAllFlexTrips()) {
            transitModel.addFlexTrip(flexTrip.getId(), flexTrip);
        }
    }
}

