/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.linking;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.graph_builder.linking.Scope;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;

public class DisposableEdgeCollection {
    private final Graph graph;
    private final Scope scope;
    private final Set<Edge> edges = new HashSet<Edge>();

    public DisposableEdgeCollection(Graph graph) {
        this(graph, null);
    }

    public DisposableEdgeCollection(Graph graph, Scope scope) {
        this.graph = graph;
        this.scope = scope;
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public void disposeEdges() {
        if (this.scope == Scope.REALTIME) {
            for (Edge e : this.edges) {
                this.graph.getLinker().removeEdgeFromIndex(e, this.scope);
            }
        }
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (Edge e : this.edges) {
            vertices.add(e.getFromVertex());
            vertices.add(e.getToVertex());
            this.graph.removeEdge(e);
        }
        for (Vertex v : vertices) {
            this.graph.removeIfUnconnected(v);
        }
        this.edges.clear();
    }
}

