/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.configure.DaggerGraphBuilderFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.OtpAppException;
import org.opentripplanner.util.lang.OtpNumberFormat;
import org.opentripplanner.util.time.DurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBuilder
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBuilder.class);
    private final List<GraphBuilderModule> graphBuilderModules = new ArrayList<GraphBuilderModule>();
    private final Graph graph;
    private final TransitModel transitModel;
    private final DataImportIssueStore issueStore;
    private boolean hasTransitData = false;

    @Inject
    public GraphBuilder(@Nonnull Graph baseGraph, @Nonnull TransitModel transitModel, @Nonnull DataImportIssueStore issueStore) {
        this.graph = baseGraph;
        this.transitModel = transitModel;
        this.issueStore = issueStore;
    }

    public static GraphBuilder create(BuildConfig config, GraphBuilderDataSources dataSources, Graph graph, TransitModel transitModel, boolean loadStreetGraph, boolean saveStreetGraph) {
        boolean hasOsm = dataSources.has(FileType.OSM);
        boolean hasGtfs = dataSources.has(FileType.GTFS);
        boolean hasNetex = dataSources.has(FileType.NETEX);
        boolean hasTransitData = hasGtfs || hasNetex;
        transitModel.initTimeZone(config.transitModelTimeZone);
        GraphBuilderFactory factory = DaggerGraphBuilderFactory.builder().config(config).graph(graph).transitModel(transitModel).dataSources(dataSources).timeZoneId(transitModel.getTimeZone()).build();
        GraphBuilder graphBuilder = factory.graphBuilder();
        graphBuilder.hasTransitData = hasTransitData;
        if (hasOsm) {
            graphBuilder.addModule(factory.openStreetMapModule());
        }
        if (hasGtfs) {
            graphBuilder.addModule(factory.gtfsModule());
        }
        if (hasNetex) {
            graphBuilder.addModule(factory.netexModule());
        }
        if (hasTransitData) {
            graphBuilder.addModule(factory.tripPatternNamer());
        }
        if (hasTransitData && transitModel.getAgencyTimeZones().size() > 1) {
            graphBuilder.addModule(factory.timeZoneAdjusterModule());
        }
        if (hasTransitData && (hasOsm || graphBuilder.graph.hasStreets)) {
            if (config.matchBusRoutesToStreets) {
                graphBuilder.addModule(factory.busRouteStreetMatcher());
            }
            graphBuilder.addModule(factory.osmBoardingLocationsModule());
        }
        graphBuilder.addModule(factory.streetLinkerModule());
        if (hasOsm && !saveStreetGraph || loadStreetGraph) {
            graphBuilder.addModule(factory.pruneNoThruIslands());
        }
        for (GraphBuilderModule graphBuilderModule : factory.elevationModules()) {
            graphBuilder.addModule(graphBuilderModule);
        }
        if (hasTransitData) {
            if (OTPFeature.FlexRouting.isOn()) {
                graphBuilder.addModule(factory.flexLocationsToStreetEdgesMapper());
            }
            graphBuilder.addModule(factory.directTransferGenerator());
            if (OTPFeature.TransferAnalyzer.isOn()) {
                graphBuilder.addModule(factory.directTransferAnalyzer());
            }
        }
        if (loadStreetGraph || hasOsm) {
            graphBuilder.addModule(factory.graphCoherencyCheckerModule());
        }
        if (config.dataImportReport) {
            graphBuilder.addModule(factory.dataImportIssuesToHTML());
        }
        if (OTPFeature.DataOverlay.isOn()) {
            graphBuilder.addModuleOptional(factory.dataOverlayFactory());
        }
        return graphBuilder;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        for (GraphBuilderModule builder : this.graphBuilderModules) {
            builder.checkInputs();
        }
        for (GraphBuilderModule load : this.graphBuilderModules) {
            load.buildGraph();
        }
        this.issueStore.summarize();
        this.validate();
        GraphBuilder.logGraphBuilderCompleteStatus(startTime, this.graph, this.transitModel);
    }

    private void addModule(GraphBuilderModule module) {
        this.graphBuilderModules.add(module);
    }

    private void addModuleOptional(GraphBuilderModule module) {
        if (module != null) {
            this.graphBuilderModules.add(module);
        }
    }

    private boolean hasTransitData() {
        return this.hasTransitData;
    }

    private void validate() {
        if (this.hasTransitData() && !this.transitModel.hasTransit()) {
            throw new OtpAppException("The provided transit data have no trips within the configured transit service period. See build config 'transitServiceStart' and 'transitServiceEnd'");
        }
    }

    private static void logGraphBuilderCompleteStatus(long startTime, Graph graph, TransitModel transitModel) {
        long endTime = System.currentTimeMillis();
        String time = DurationUtils.durationToStr(Duration.ofMillis(endTime - startTime));
        OtpNumberFormat f = new OtpNumberFormat();
        String nStops = f.formatNumber(transitModel.getStopModel().stopIndexSize());
        String nPatterns = f.formatNumber(transitModel.getAllTripPatterns().size());
        String nTransfers = f.formatNumber(transitModel.getTransferService().listAll().size());
        String nVertices = f.formatNumber(graph.countVertices());
        String nEdges = f.formatNumber(graph.countEdges());
        LOG.info("Graph building took {}.", (Object)time);
        LOG.info("Graph built.   |V|={} |E|={}", (Object)nVertices, (Object)nEdges);
        LOG.info("Transit built. |Stops|={} |Patterns|={} |ConstrainedTransfers|={}", new Object[]{nStops, nPatterns, nTransfers});
    }
}

