/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.text;

import java.util.List;
import java.util.function.Function;
import org.opentripplanner.framework.text.MarkdownFormatter;
import org.opentripplanner.framework.text.Table;
import org.opentripplanner.util.lang.ObjectUtils;
import org.opentripplanner.util.lang.StringUtils;

class TableRowFormatter {
    private static final String SEP = "|";
    private static final char AIR = ' ';
    private static final char LINE_CH = '-';
    private static final char ALIGN_CH = ':';
    private final List<Table.Align> alignment;
    private final List<Integer> widths;
    private boolean includeBoarder = false;
    private Function<String, String> escapeTextOp = s -> s;

    private TableRowFormatter(List<Table.Align> alignment, List<Integer> widths, boolean includeBoarder, Function<String, String> escapeTextOp) {
        this.widths = widths;
        this.alignment = alignment;
        this.includeBoarder = includeBoarder;
        this.escapeTextOp = escapeTextOp;
    }

    static TableRowFormatter markdownFormatter(List<Table.Align> alignment, List<Integer> widths) {
        return new TableRowFormatter(alignment, widths, true, MarkdownFormatter::escapeInTable);
    }

    static TableRowFormatter logFormatter(List<Table.Align> alignment, List<Integer> widths) {
        return new TableRowFormatter(alignment, widths, false, it -> it);
    }

    String format(List<?> values) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            if (i != 0) {
                buf.append(' ').append(SEP).append(' ');
            } else if (this.includeBoarder) {
                buf.append(SEP).append(' ');
            }
            buf.append(this.normalizeText(values, i));
        }
        if (this.includeBoarder) {
            buf.append(' ').append(SEP);
        }
        return buf.toString();
    }

    String markdownHeaderLine() {
        StringBuilder buf = new StringBuilder(SEP);
        for (int i = 0; i < this.widths.size(); ++i) {
            Table.Align align = this.alignment.get(i);
            this.addAlignChar(buf, align == Table.Align.Center);
            StringUtils.append(buf, '-', this.widths.get(i));
            this.addAlignChar(buf, align == Table.Align.Center || align == Table.Align.Right);
            buf.append(SEP);
        }
        return buf.toString();
    }

    private void addAlignChar(StringBuilder buf, boolean add) {
        buf.append(add ? (char)':' : '-');
    }

    private String normalizeText(List<?> row, int column) {
        Table.Align align = this.alignment.get(column);
        Integer width = this.widths.get(column);
        String text = ObjectUtils.toString(row.get(column));
        text = this.escapeTextOp.apply(text);
        text = align.pad(text, width);
        return text;
    }
}

