/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.text;

import javax.annotation.Nullable;

public class MarkdownFormatter {
    public static int HEADER_1 = 1;
    public static int HEADER_2 = 2;
    public static int HEADER_3 = 3;
    public static int HEADER_4 = 4;
    public static final String NBSP = "\u00a0";
    public static final String NEW_LINE = "\n";

    public static String em(String text) {
        return "*" + text + "*";
    }

    public static String bold(Object text) {
        return text == null ? "" : "**" + text + "**";
    }

    public static String code(@Nullable Object text) {
        return text == null ? "" : "`" + text + "`";
    }

    public static String linkToAnchor(String text, String anchor) {
        return "[%s](#%s)".formatted(text, MarkdownFormatter.normalizeAnchor(anchor));
    }

    public static String linkToDoc(String text, String url) {
        return "[%s](%s)".formatted(text, url);
    }

    public static String header(int level, String header, @Nullable String anchor) {
        if (anchor != null && !anchor.isBlank()) {
            return "<h%d id=\"%s\">%s</h%d>".formatted(level, MarkdownFormatter.normalizeAnchor(anchor), header, level);
        }
        return "#".repeat(level) + " " + header;
    }

    public static String checkMark(boolean enable) {
        return enable ? "\u2713\ufe0f" : "";
    }

    public static String escapeInTable(String text) {
        if (text == null || !text.contains("|")) {
            return text;
        }
        return text.replace("|", "\u00a6");
    }

    public static String indentInTable(int level) {
        return level <= 0 ? "" : NBSP.repeat(3 * level);
    }

    public static String lineBreak() {
        return " \\";
    }

    private static String normalizeAnchor(String anchor) {
        return anchor.replaceAll("[-!\"#$%&/.=?+\\[\\]]", "_");
    }
}

