/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.hslpark;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.ext.vehicleparking.hslpark.HslFacilitiesDownloader;
import org.opentripplanner.ext.vehicleparking.hslpark.HslHubToVehicleParkingGroupMapper;
import org.opentripplanner.ext.vehicleparking.hslpark.HslHubsDownloader;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkPatch;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkToVehicleParkingMapper;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkUpdaterParameters;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkUtilizationToPatchMapper;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingGroup;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.util.xml.JsonDataListDownloader;

public class HslParkUpdater
implements DataSource<VehicleParking> {
    private static final String JSON_PARSE_PATH = "results";
    private final HslFacilitiesDownloader facilitiesDownloader;
    private final int facilitiesFrequencySec;
    private final HslHubsDownloader hubsDownloader;
    private final JsonDataListDownloader utilizationsDownloader;
    private final HslParkToVehicleParkingMapper vehicleParkingMapper;
    private final HslHubToVehicleParkingGroupMapper vehicleParkingGroupMapper;
    private final HslParkUtilizationToPatchMapper parkPatchMapper;
    private long lastFacilitiesFetchTime;
    private List<VehicleParking> parks;
    private Map<FeedScopedId, VehicleParkingGroup> hubForPark;

    public HslParkUpdater(HslParkUpdaterParameters parameters, OpeningHoursCalendarService openingHoursCalendarService) {
        String feedId = parameters.getFeedId();
        this.vehicleParkingMapper = new HslParkToVehicleParkingMapper(feedId, openingHoursCalendarService, parameters.getTimeZone());
        this.vehicleParkingGroupMapper = new HslHubToVehicleParkingGroupMapper(feedId);
        this.parkPatchMapper = new HslParkUtilizationToPatchMapper(feedId);
        this.facilitiesDownloader = new HslFacilitiesDownloader(parameters.getFacilitiesUrl(), JSON_PARSE_PATH, this.vehicleParkingMapper::parsePark);
        this.hubsDownloader = new HslHubsDownloader(parameters.getHubsUrl(), JSON_PARSE_PATH, this.vehicleParkingGroupMapper::parseHub);
        this.utilizationsDownloader = new JsonDataListDownloader<HslParkPatch>(parameters.getUtilizationsUrl(), "", this.parkPatchMapper::parseUtilization, null);
        this.facilitiesFrequencySec = parameters.getFacilitiesFrequencySec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        Map<FeedScopedId, VehicleParkingGroup> hubForPark;
        List<VehicleParking> parks = null;
        if (this.fetchFacilitiesAndHubsNow()) {
            hubForPark = this.hubsDownloader.downloadHubs();
            if (hubForPark != null && (parks = this.facilitiesDownloader.downloadFacilities(hubForPark)) != null) {
                this.lastFacilitiesFetchTime = System.currentTimeMillis();
            }
        } else {
            parks = this.parks;
            hubForPark = this.hubForPark;
        }
        if (parks != null) {
            List utilizations = this.utilizationsDownloader.download();
            if (utilizations != null) {
                Map<FeedScopedId, List<HslParkPatch>> patches = utilizations.stream().collect(Collectors.groupingBy(utilization -> utilization.getId()));
                parks.forEach(park -> {
                    List patchesForPark = (List)patches.get(park.getId());
                    if (patchesForPark != null) {
                        park.updateAvailability(HslParkUpdater.createVehicleAvailability(patchesForPark));
                    }
                });
            } else if (this.parks != null) {
                return false;
            }
            HslParkUpdater hslParkUpdater = this;
            synchronized (hslParkUpdater) {
                this.parks = parks;
                this.hubForPark = hubForPark;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<VehicleParking> getUpdates() {
        return this.parks;
    }

    private static VehicleParkingSpaces createVehicleAvailability(List<HslParkPatch> patches) {
        VehicleParkingSpaces.VehicleParkingSpacesBuilder availabilityBuilder = VehicleParkingSpaces.builder();
        boolean hasHandledSpaces = false;
        for (HslParkPatch patch : patches) {
            String type = patch.getCapacityType();
            if (type == null) continue;
            Integer spaces = patch.getSpacesAvailable();
            switch (type) {
                case "CAR": {
                    availabilityBuilder.carSpaces(spaces);
                    hasHandledSpaces = true;
                    break;
                }
                case "BICYCLE": {
                    availabilityBuilder.bicycleSpaces(spaces);
                    hasHandledSpaces = true;
                    break;
                }
                case "DISABLED": {
                    availabilityBuilder.wheelchairAccessibleCarSpaces(spaces);
                    hasHandledSpaces = true;
                }
            }
        }
        return hasHandledSpaces ? availabilityBuilder.build() : null;
    }

    private boolean fetchFacilitiesAndHubsNow() {
        if (this.parks == null) {
            return true;
        }
        if (this.facilitiesFrequencySec <= 0) {
            return false;
        }
        return System.currentTimeMillis() > this.lastFacilitiesFetchTime + (long)(this.facilitiesFrequencySec * 1000);
    }
}

