/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.hslpark;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingGroup;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HslHubsDownloader {
    private static final Logger log = LoggerFactory.getLogger(HslHubsDownloader.class);
    private final String jsonParsePath;
    private final Function<JsonNode, Map<FeedScopedId, VehicleParkingGroup>> hubsParser;
    private String url;
    private static final ObjectMapper mapper = new ObjectMapper();

    public HslHubsDownloader(String url, String jsonParsePath, Function<JsonNode, Map<FeedScopedId, VehicleParkingGroup>> hubsParser) {
        this.url = url;
        this.jsonParsePath = jsonParsePath;
        this.hubsParser = hubsParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<FeedScopedId, VehicleParkingGroup> downloadHubs() {
        if (this.url == null) {
            log.warn("Cannot download updates, because url is null!");
            return null;
        }
        try (InputStream data = HttpUtils.openInputStream(this.url, null);){
            if (data == null) {
                log.warn("Failed to get data from url {}", (Object)this.url);
                Map<FeedScopedId, VehicleParkingGroup> map2 = null;
                return map2;
            }
            Map<FeedScopedId, VehicleParkingGroup> map = this.parseJSON(data);
            return map;
        }
        catch (IllegalArgumentException e) {
            log.warn("Error parsing hubs from {}", (Object)this.url, (Object)e);
            return null;
        }
        catch (JsonProcessingException e) {
            log.warn("Error parsing hubs from {} (bad JSON of some sort)", (Object)this.url, (Object)e);
            return null;
        }
        catch (IOException e) {
            log.warn("Error reading hubs from {}", (Object)this.url, (Object)e);
        }
        return null;
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner scanner = new Scanner(is).useDelimiter("\\A");){
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private Map<FeedScopedId, VehicleParkingGroup> parseJSON(InputStream dataStream) throws IllegalArgumentException, IOException {
        HashMap<FeedScopedId, VehicleParkingGroup> out = new HashMap<FeedScopedId, VehicleParkingGroup>();
        String hubsString = HslHubsDownloader.convertStreamToString(dataStream);
        JsonNode rootNode = mapper.readTree(hubsString);
        if (!this.jsonParsePath.equals("")) {
            String[] parseElement;
            String delimiter = "/";
            for (String s : parseElement = this.jsonParsePath.split(delimiter)) {
                rootNode = rootNode.path(s);
            }
            if (rootNode.isMissingNode()) {
                throw new IllegalArgumentException("Could not find jSON elements " + this.jsonParsePath);
            }
        }
        for (JsonNode node : rootNode) {
            Map<FeedScopedId, VehicleParkingGroup> parsedElement;
            if (node == null || (parsedElement = this.hubsParser.apply(node)) == null) continue;
            out.putAll(parsedElement);
        }
        return out;
    }
}

