/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.hslpark;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.BiFunction;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingGroup;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HslFacilitiesDownloader {
    private static final Logger log = LoggerFactory.getLogger(HslFacilitiesDownloader.class);
    private final String jsonParsePath;
    private final BiFunction<JsonNode, Map<FeedScopedId, VehicleParkingGroup>, VehicleParking> facilitiesParser;
    private String url;
    private static final ObjectMapper mapper = new ObjectMapper();

    public HslFacilitiesDownloader(String url, String jsonParsePath, BiFunction<JsonNode, Map<FeedScopedId, VehicleParkingGroup>, VehicleParking> facilitiesParser) {
        this.url = url;
        this.jsonParsePath = jsonParsePath;
        this.facilitiesParser = facilitiesParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<VehicleParking> downloadFacilities(Map<FeedScopedId, VehicleParkingGroup> hubForPark) {
        if (this.url == null) {
            log.warn("Cannot download updates, because url is null!");
            return null;
        }
        try (InputStream data = HttpUtils.openInputStream(this.url, null);){
            if (data == null) {
                log.warn("Failed to get data from url {}", (Object)this.url);
                List<VehicleParking> list2 = null;
                return list2;
            }
            List<VehicleParking> list = this.parseJSON(data, hubForPark);
            return list;
        }
        catch (IllegalArgumentException e) {
            log.warn("Error parsing facilities from {}", (Object)this.url, (Object)e);
            return null;
        }
        catch (JsonProcessingException e) {
            log.warn("Error parsing facilities from {} (bad JSON of some sort)", (Object)this.url, (Object)e);
            return null;
        }
        catch (IOException e) {
            log.warn("Error reading facilities from {}", (Object)this.url, (Object)e);
        }
        return null;
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner scanner = new Scanner(is).useDelimiter("\\A");){
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private List<VehicleParking> parseJSON(InputStream dataStream, Map<FeedScopedId, VehicleParkingGroup> hubForPark) throws IllegalArgumentException, IOException {
        ArrayList<VehicleParking> out = new ArrayList<VehicleParking>();
        String facilitiesString = HslFacilitiesDownloader.convertStreamToString(dataStream);
        JsonNode rootNode = mapper.readTree(facilitiesString);
        if (!this.jsonParsePath.equals("")) {
            String[] parseElement;
            String delimiter = "/";
            for (String s : parseElement = this.jsonParsePath.split(delimiter)) {
                rootNode = rootNode.path(s);
            }
            if (rootNode.isMissingNode()) {
                throw new IllegalArgumentException("Could not find jSON elements " + this.jsonParsePath);
            }
        }
        for (JsonNode node : rootNode) {
            VehicleParking parsedElement;
            if (node == null || (parsedElement = this.facilitiesParser.apply(node, hubForPark)) == null) continue;
            out.add(parsedElement);
        }
        return out;
    }
}

