/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.stops;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.vectortiles.I18NStringMapper;
import org.opentripplanner.ext.vectortiles.PropertyMapper;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.TransitService;

public class DigitransitStopPropertyMapper
extends PropertyMapper<RegularStop> {
    private final TransitService transitService;
    private final I18NStringMapper i18NStringMapper;

    private DigitransitStopPropertyMapper(TransitService transitService, Locale locale) {
        this.transitService = transitService;
        this.i18NStringMapper = new I18NStringMapper(locale);
    }

    protected static DigitransitStopPropertyMapper create(TransitService transitService, Locale locale) {
        return new DigitransitStopPropertyMapper(transitService, locale);
    }

    @Override
    protected Collection<T2<String, Object>> map(RegularStop stop) {
        Collection<TripPattern> patternsForStop = this.transitService.getPatternsForStop(stop);
        String type = patternsForStop.stream().map(TripPattern::getMode).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(Enum::name).orElse(null);
        String routes = JSONArray.toJSONString(this.transitService.getRoutesForStop(stop).stream().map((? super T route) -> {
            JSONObject routeObject = new JSONObject();
            routeObject.put((Object)"gtfsType", (Object)route.getGtfsType());
            return routeObject;
        }).toList());
        return List.of(new T2<String, String>("gtfsId", stop.getId().toString()), new T2<String, String>("name", this.i18NStringMapper.mapNonnullToApi(stop.getName())), new T2<String, String>("code", stop.getCode()), new T2<String, String>("platform", stop.getPlatformCode()), new T2<String, String>("desc", this.i18NStringMapper.mapToApi(stop.getDescription())), new T2<String, String>("parentStation", (String)(stop.getParentStation() != null ? stop.getParentStation().getId() : "null")), new T2<String, String>("type", type), new T2<String, String>("routes", routes));
    }
}

