/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.adapt.jts.JtsAdapter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.TileGeomResult;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerBuild;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerParams;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opentripplanner.ext.vectortiles.PropertyMapper;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.util.geometry.GeometryUtils;

public abstract class LayerBuilder<T> {
    private static final GeometryFactory GEOMETRY_FACTORY = GeometryUtils.getGeometryFactory();
    private final MvtLayerProps layerProps = new MvtLayerProps();
    private final VectorTile.Tile.Layer.Builder layerBuilder;
    private final PropertyMapper<T> mapper;

    public LayerBuilder(String layerName, PropertyMapper<T> mapper) {
        this.mapper = mapper;
        this.layerBuilder = MvtLayerBuild.newLayerBuilder((String)layerName, (MvtLayerParams)MvtLayerParams.DEFAULT);
    }

    protected abstract List<Geometry> getGeometries(Envelope var1);

    VectorTile.Tile.Layer build(Envelope envelope, VectorTilesResource.LayerParameters params) {
        Envelope query = new Envelope(envelope);
        query.expandBy(envelope.getWidth() * params.expansionFactor(), envelope.getHeight() * params.expansionFactor());
        TileGeomResult tileGeom = JtsAdapter.createTileGeom(this.getGeometries(query), (Envelope)envelope, (Envelope)query, (GeometryFactory)GEOMETRY_FACTORY, (MvtLayerParams)MvtLayerParams.DEFAULT, g -> true);
        List features = JtsAdapter.toFeatures((Collection)tileGeom.mvtGeoms, (MvtLayerProps)this.layerProps, this.mapper);
        this.layerBuilder.addAllFeatures((Iterable)features);
        MvtLayerBuild.writeProps((VectorTile.Tile.Layer.Builder)this.layerBuilder, (MvtLayerProps)this.layerProps);
        return this.layerBuilder.build();
    }
}

