/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime.spt;

import java.util.Collection;
import java.util.HashSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.ext.traveltime.spt.SPTVisitor;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPTWalker {
    private static final Logger LOG = LoggerFactory.getLogger(SPTWalker.class);
    private final ShortestPathTree spt;

    public SPTWalker(ShortestPathTree spt) {
        this.spt = spt;
    }

    public void walk(SPTVisitor visitor, double d0) {
        int nTotal = 0;
        int nSkippedDupEdge = 0;
        int nSkippedNoGeometry = 0;
        Collection<State> allStates = this.spt.getAllStates();
        HashSet<Vertex> allVertices = new HashSet<Vertex>(this.spt.getVertexCount());
        for (State s : allStates) {
            allVertices.add(s.getVertex());
        }
        HashSet<Edge> processedEdges = new HashSet<Edge>(allVertices.size());
        for (Vertex v : allVertices) {
            State s0 = this.spt.getState(v);
            if (s0 == null || !s0.isFinal()) continue;
            block2: for (Edge e : s0.getVertex().getIncoming()) {
                State s1;
                if (e == null || !visitor.accept(e) || (s1 = this.spt.getState(e.getFromVertex())) == null || !s1.isFinal()) continue;
                if (e.getFromVertex() != null && e.getToVertex() != null) {
                    if (processedEdges.contains(e)) {
                        ++nSkippedDupEdge;
                        continue;
                    }
                    processedEdges.add(e);
                }
                Vertex vx0 = s0.getVertex();
                Vertex vx1 = s1.getVertex();
                LineString lineString = e.getGeometry();
                if (lineString == null) {
                    ++nSkippedNoGeometry;
                    continue;
                }
                double speedAlongEdge = s0.getPreferences().walk().speed();
                if (e instanceof StreetEdge) {
                    double avgSpeed;
                    StreetEdge se = (StreetEdge)e;
                    TraverseMode mode = s0.getNonTransitMode();
                    speedAlongEdge = se.calculateSpeed(s0.getPreferences(), mode, s0.isBackWalkingBike());
                    if (mode != TraverseMode.CAR) {
                        speedAlongEdge *= se.getEffectiveBikeDistance() / se.getDistanceMeters();
                    }
                    if ((avgSpeed = se.getDistanceMeters() / (double)Math.abs(s0.getTimeSeconds() - s1.getTimeSeconds())) < 1.0E-10) {
                        avgSpeed = 1.0E-10;
                    }
                    if (speedAlongEdge > avgSpeed) {
                        speedAlongEdge = avgSpeed;
                    }
                }
                double lineStringLen = SphericalDistanceLibrary.fastLength(lineString);
                visitor.visit(e, vx0.getCoordinate(), s0, s1, 0.0, lineStringLen, speedAlongEdge);
                visitor.visit(e, vx1.getCoordinate(), s0, s1, lineStringLen, 0.0, speedAlongEdge);
                nTotal += 2;
                Coordinate[] pList = lineString.getCoordinates();
                boolean reverse = vx1.getCoordinate().equals((Object)pList[0]);
                if (!(lineStringLen > d0)) continue;
                int nSteps = (int)Math.floor(lineStringLen / d0) + 1;
                double stepLen = lineStringLen / (double)nSteps;
                double startLen = 0.0;
                double curLen = stepLen;
                int ns = 1;
                for (int i = 0; i < pList.length - 1; ++i) {
                    Coordinate p0 = pList[i];
                    Coordinate p1 = pList[i + 1];
                    double segLen = SphericalDistanceLibrary.fastDistance(p0, p1);
                    while (curLen - startLen < segLen) {
                        double k = (curLen - startLen) / segLen;
                        Coordinate p = new Coordinate(p0.x * (1.0 - k) + p1.x * k, p0.y * (1.0 - k) + p1.y * k);
                        visitor.visit(e, p, reverse ? s1 : s0, reverse ? s0 : s1, curLen, lineStringLen - curLen, speedAlongEdge);
                        ++nTotal;
                        curLen += stepLen;
                        ++ns;
                    }
                    startLen += segLen;
                    if (ns >= nSteps) continue block2;
                }
            }
        }
        LOG.info("SPTWalker: Generated {} points ({} dup edges, {} no geometry) from {} vertices / {} states.", new Object[]{nTotal, nSkippedDupEdge, nSkippedNoGeometry, allVertices.size(), allStates.size()});
    }
}

