/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime.geometry;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.ext.traveltime.geometry.AccumulativeMetric;
import org.opentripplanner.ext.traveltime.geometry.ZSampleGrid;
import org.opentripplanner.ext.traveltime.geometry.ZSamplePoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulativeGridSampler<TZ> {
    private static final Logger LOG = LoggerFactory.getLogger(AccumulativeGridSampler.class);
    private final AccumulativeMetric<TZ> metric;
    private final ZSampleGrid<TZ> sampleGrid;
    private boolean closed = false;

    public AccumulativeGridSampler(ZSampleGrid<TZ> sampleGrid, AccumulativeMetric<TZ> metric) {
        this.metric = metric;
        this.sampleGrid = sampleGrid;
    }

    public final void addSamplingPoint(Coordinate C0, TZ z, double offRoadSpeed) {
        if (this.closed) {
            throw new IllegalStateException("Can't add a sample after closing.");
        }
        int[] xy = this.sampleGrid.getLowerLeftIndex(C0);
        int x = xy[0];
        int y = xy[1];
        List<ZSamplePoint<TZ>> ABCD = List.of(this.sampleGrid.getOrCreate(x, y), this.sampleGrid.getOrCreate(x + 1, y), this.sampleGrid.getOrCreate(x, y + 1), this.sampleGrid.getOrCreate(x + 1, y + 1));
        for (ZSamplePoint<TZ> P : ABCD) {
            Coordinate C = this.sampleGrid.getCoordinates(P);
            P.setZ(this.metric.cumulateSample(C0, C, z, P.getZ(), offRoadSpeed));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void close() {
        void var3_6;
        if (this.closed) {
            return;
        }
        this.closed = true;
        ArrayList<ZSamplePoint> processList = new ArrayList<ZSamplePoint>(this.sampleGrid.size());
        for (ZSamplePoint zSamplePoint : this.sampleGrid) {
            processList.add(zSamplePoint);
        }
        int round = 0;
        boolean bl = false;
        while (!processList.isEmpty()) {
            ArrayList<ZSamplePoint<TZ>> newProcessList = new ArrayList<ZSamplePoint<TZ>>(processList.size());
            for (ZSamplePoint A : processList) {
                ZSamplePoint<TZ> B;
                if (A.right() == null) {
                    B = this.closeSample(A.getX() + 1, A.getY());
                    if (B != null) {
                        newProcessList.add(B);
                    }
                    ++var3_6;
                }
                if (A.left() == null) {
                    B = this.closeSample(A.getX() - 1, A.getY());
                    if (B != null) {
                        newProcessList.add(B);
                    }
                    ++var3_6;
                }
                if (A.up() == null) {
                    B = this.closeSample(A.getX(), A.getY() + 1);
                    if (B != null) {
                        newProcessList.add(B);
                    }
                    ++var3_6;
                }
                if (A.down() != null) continue;
                B = this.closeSample(A.getX(), A.getY() - 1);
                if (B != null) {
                    newProcessList.add(B);
                }
                ++var3_6;
            }
            processList = newProcessList;
            LOG.debug("Round {} : next process list {}", (Object)round, (Object)processList.size());
            ++round;
        }
        LOG.info("Added {} closing samples to get a total of {}.", (Object)((int)var3_6), (Object)this.sampleGrid.size());
    }

    private ZSamplePoint<TZ> closeSample(int x, int y) {
        ZSamplePoint<TZ> A = this.sampleGrid.getOrCreate(x, y);
        boolean ok = this.metric.closeSample(A);
        if (ok) {
            return null;
        }
        return A;
    }
}

