/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.media.jai.RasterFactory;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.geojson.MultiPolygon;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opentripplanner.api.common.LocationStringParser;
import org.opentripplanner.api.parameter.QualifiedModeSet;
import org.opentripplanner.ext.traveltime.IsochroneData;
import org.opentripplanner.ext.traveltime.IsochroneRenderer;
import org.opentripplanner.ext.traveltime.SampleGridRenderer;
import org.opentripplanner.ext.traveltime.TravelTimeRequest;
import org.opentripplanner.ext.traveltime.WTWD;
import org.opentripplanner.ext.traveltime.geometry.ZSampleGrid;
import org.opentripplanner.ext.traveltime.geometry.ZSamplePoint;
import org.opentripplanner.routing.algorithm.astar.AStarBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.AccessEgressMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RouteRequestTransitDataProviderFilter;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.core.AStarRequest;
import org.opentripplanner.routing.core.AStarRequestMapper;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateData;
import org.opentripplanner.routing.core.TemporaryVerticesContainer;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.raptor.RaptorService;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.transit.raptor.api.response.RaptorResponse;
import org.opentripplanner.transit.raptor.api.response.StopArrivals;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.time.DurationUtils;
import org.opentripplanner.util.time.ServiceDateUtils;

@Path(value="/traveltime")
public class TravelTimeResource {
    private static final SimpleFeatureType contourSchema = TravelTimeResource.makeContourSchema();
    private final RouteRequest routingRequest;
    private final RaptorRoutingRequestTransitData requestTransitDataProvider;
    private final Instant startTime;
    private final Instant endTime;
    private final ZonedDateTime startOfTime;
    private final TravelTimeRequest traveltimeRequest;
    private final RaptorService<TripSchedule> raptorService;
    private final Graph graph;
    private final TransitService transitService;

    public TravelTimeResource(@Context OtpServerRequestContext serverContext, @QueryParam(value="location") String location, @QueryParam(value="time") String time, @QueryParam(value="cutoff") @DefaultValue(value="60m") List<String> cutoffs, @QueryParam(value="modes") String modes) {
        this.graph = serverContext.graph();
        this.transitService = serverContext.transitService();
        this.routingRequest = serverContext.defaultRouteRequest();
        this.routingRequest.setFrom(LocationStringParser.fromOldStyleString(location));
        if (modes != null) {
            this.routingRequest.journey().setModes(new QualifiedModeSet(modes).getRequestModes());
        }
        this.traveltimeRequest = new TravelTimeRequest(cutoffs.stream().map(DurationUtils::duration).toList(), this.routingRequest.preferences().street().maxAccessEgressDuration().valueOf(this.routingRequest.journey().access().mode()));
        this.startTime = time != null ? Instant.parse(time) : Instant.now();
        this.routingRequest.setDateTime(this.startTime);
        this.endTime = this.startTime.plus(this.traveltimeRequest.maxCutoff);
        ZoneId zoneId = this.transitService.getTimeZone();
        LocalDate startDate = LocalDate.ofInstant(this.startTime, zoneId);
        LocalDate endDate = LocalDate.ofInstant(this.endTime, zoneId);
        this.startOfTime = ServiceDateUtils.asStartOfService(startDate, zoneId);
        RouteRequest transferRouteRequest = this.routingRequest.copyAndPrepareForTransferRouting();
        this.requestTransitDataProvider = new RaptorRoutingRequestTransitData(this.transitService.getRealtimeTransitLayer(), this.startOfTime, 0, (int)Period.between(startDate, endDate).get(ChronoUnit.DAYS), new RouteRequestTransitDataProviderFilter(this.routingRequest, this.transitService), transferRouteRequest);
        this.raptorService = new RaptorService<TripSchedule>(serverContext.raptorConfig());
    }

    @GET
    @Path(value="/isochrone")
    @Produces(value={"application/json"})
    public Response getIsochrones() {
        ZSampleGrid<WTWD> sampleGrid = this.getSampleGrid();
        List<IsochroneData> isochrones = IsochroneRenderer.renderIsochrones(sampleGrid, this.traveltimeRequest);
        SimpleFeatureCollection features = TravelTimeResource.makeContourFeatures(isochrones);
        StreamingOutput out = outputStream -> {
            try (GeoJSONWriter geoJSONWriter = new GeoJSONWriter(outputStream);){
                geoJSONWriter.writeFeatureCollection(features);
            }
        };
        return Response.ok().entity((Object)out).build();
    }

    @GET
    @Path(value="/surface")
    @Produces(value={"image/tiff"})
    public Response getSurface() {
        ZSampleGrid<WTWD> sampleGrid = this.getSampleGrid();
        int minX = sampleGrid.getXMin();
        int minY = sampleGrid.getYMin();
        int maxY = sampleGrid.getYMax();
        int width = sampleGrid.getXMax() - minX + 1;
        int height = maxY - minY + 1;
        Coordinate center = sampleGrid.getCenter();
        double resX = sampleGrid.getCellSize().x;
        double resY = sampleGrid.getCellSize().y;
        WritableRaster raster = RasterFactory.createBandedRaster((int)3, (int)width, (int)height, (int)1, null);
        DataBuffer dataBuffer = raster.getDataBuffer();
        for (int i = 0; i < dataBuffer.getSize(); ++i) {
            dataBuffer.setElem(i, Integer.MIN_VALUE);
        }
        for (ZSamplePoint zSamplePoint : sampleGrid) {
            WTWD z = (WTWD)zSamplePoint.getZ();
            raster.setSample(zSamplePoint.getX() - minX, maxY - zSamplePoint.getY(), 0, z.wTime / z.w);
        }
        Envelope2D geom = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, width, height), (MathTransform)new AffineTransform2D(resX, 0.0, 0.0, resY, center.x + resX * (double)minX, center.y + resY * (double)minY), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84).getEnvelope2D();
        GridCoverage2D gridCoverage2D = new GridCoverageFactory().create((CharSequence)"traveltime", raster, (Envelope)geom);
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(2);
        wp.setCompressionType("LZW");
        ParameterValueGroup params = new GeoTiffFormat().getWriteParameters();
        params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        StreamingOutput streamingOutput = outputStream -> {
            GeoTiffWriter writer = new GeoTiffWriter((Object)outputStream);
            writer.write((GridCoverage)gridCoverage, params.values().toArray(new GeneralParameterValue[1]));
            writer.dispose();
            outputStream.close();
        };
        return Response.ok().entity((Object)streamingOutput).build();
    }

    private ZSampleGrid<WTWD> getSampleGrid() {
        RouteRequest accessRequest = this.routingRequest.clone();
        accessRequest.withPreferences(preferences -> preferences.withStreet(it -> it.withMaxAccessEgressDuration(this.traveltimeRequest.maxAccessDuration, Map.of())));
        try (TemporaryVerticesContainer temporaryVertices = new TemporaryVerticesContainer(this.graph, accessRequest, accessRequest.journey().access().mode(), StreetMode.NOT_SET);){
            Collection<DefaultAccessEgress> accessList = this.getAccess(accessRequest, temporaryVertices);
            StopArrivals arrivals = this.route(accessList).getArrivals();
            ShortestPathTree spt = AStarBuilder.allDirectionsMaxDuration(this.traveltimeRequest.maxCutoff).setRequest(this.routingRequest).setStreetRequest(accessRequest.journey().access()).setVerticesContainer(temporaryVertices).setDominanceFunction(new DominanceFunction.EarliestArrival()).setInitialStates(this.getInitialStates(arrivals, temporaryVertices)).getShortestPathTree();
            ZSampleGrid<WTWD> zSampleGrid = SampleGridRenderer.getSampleGrid(spt, this.traveltimeRequest);
            return zSampleGrid;
        }
    }

    private Collection<DefaultAccessEgress> getAccess(RouteRequest accessRequest, TemporaryVerticesContainer temporaryVertices) {
        Collection<NearbyStop> accessStops = AccessEgressRouter.streetSearch(accessRequest, temporaryVertices, this.transitService, this.routingRequest.journey().access(), null, false);
        return new AccessEgressMapper().mapNearbyStops(accessStops, false);
    }

    private List<State> getInitialStates(StopArrivals arrivals, TemporaryVerticesContainer temporaryVertices) {
        ArrayList<State> initialStates = new ArrayList<State>();
        AStarRequest aStarRequest = AStarRequestMapper.map(this.routingRequest).withMode(this.routingRequest.journey().egress().mode()).build();
        StateData stateData = StateData.getInitialStateData(aStarRequest);
        for (Vertex vertex : temporaryVertices.getFromVertices()) {
            initialStates.add(new State(vertex, this.startTime, stateData, aStarRequest));
        }
        for (RegularStop stop : this.transitService.listRegularStops()) {
            int index = stop.getIndex();
            if (!arrivals.reachedByTransit(index)) continue;
            int arrivalTime = arrivals.bestTransitArrivalTime(index);
            TransitStopVertex v = this.graph.getStopVertexForStopId(stop.getId());
            if (v == null) continue;
            Instant time = this.startOfTime.plusSeconds(arrivalTime).toInstant();
            State s = new State(v, time, stateData.clone(), aStarRequest);
            s.weight = this.startTime.until(time, ChronoUnit.SECONDS);
            initialStates.add(s);
        }
        return initialStates;
    }

    private RaptorResponse<TripSchedule> route(Collection<? extends RaptorAccessEgress> accessList) {
        RaptorRequest request = new RaptorRequestBuilder().profile(RaptorProfile.BEST_TIME).searchParams().earliestDepartureTime(ServiceDateUtils.secondsSinceStartOfTime(this.startOfTime, this.startTime)).latestArrivalTime(ServiceDateUtils.secondsSinceStartOfTime(this.startOfTime, this.endTime)).addAccessPaths(accessList).searchOneIterationOnly().timetableEnabled(false).allowEmptyEgressPaths(true).constrainedTransfersEnabled(false).build();
        return this.raptorService.route(request, this.requestTransitDataProvider);
    }

    static SimpleFeatureType makeContourSchema() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("contours");
        typeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        typeBuilder.setDefaultGeometry("the_geom");
        typeBuilder.add("the_geom", MultiPolygon.class);
        typeBuilder.add("time", Long.class);
        return typeBuilder.buildFeatureType();
    }

    private static SimpleFeatureCollection makeContourFeatures(List<IsochroneData> isochrones) {
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection(null, contourSchema);
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(contourSchema);
        for (IsochroneData isochrone : isochrones) {
            fbuilder.add((Object)isochrone.geometry());
            fbuilder.add((Object)isochrone.cutoffSec());
            featureCollection.add(fbuilder.buildFeature(null));
        }
        return featureCollection;
    }
}

