/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public class TravelTimeRequest {
    public final List<Duration> cutoffs;
    public final boolean includeDebugGeometry = false;
    public final int precisionMeters = 200;
    public final int offRoadDistanceMeters = 150;
    public final Duration maxCutoff;
    public final Duration maxAccessDuration;

    public TravelTimeRequest(List<Duration> cutoffList, Duration defaultAccessDuration) {
        this.cutoffs = cutoffList;
        this.maxCutoff = (Duration)this.cutoffs.stream().max(Duration::compareTo).orElseThrow();
        this.maxAccessDuration = this.maxCutoff.compareTo(defaultAccessDuration) < 0 ? this.maxCutoff : defaultAccessDuration;
    }

    public int hashCode() {
        return this.cutoffs.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof TravelTimeRequest) {
            TravelTimeRequest otherReq = (TravelTimeRequest)other;
            return this.cutoffs.equals(otherReq.cutoffs);
        }
        return false;
    }

    public String toString() {
        return String.format("<isochrone request, cutoff=%s sec, precision=%d meters>", Arrays.toString(this.cutoffs.toArray()), 200);
    }
}

