/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.stop;

import java.time.ZoneId;
import java.util.Collection;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;

public class MonoOrMultiModalStation {
    private final FeedScopedId id;
    private final I18NString name;
    private final double lat;
    private final double lon;
    private final String code;
    private final I18NString description;
    private final I18NString url;
    private final ZoneId timezone;
    private final Collection<StopLocation> childStops;
    private final MonoOrMultiModalStation parentStation;

    public MonoOrMultiModalStation(Station station, MultiModalStation parentStation) {
        this.id = station.getId();
        this.name = station.getName();
        this.lat = station.getLat();
        this.lon = station.getLon();
        this.code = station.getCode();
        this.description = station.getDescription();
        this.url = station.getUrl();
        this.timezone = station.getTimezone();
        this.childStops = station.getChildStops();
        this.parentStation = parentStation != null ? new MonoOrMultiModalStation(parentStation) : null;
    }

    public MonoOrMultiModalStation(MultiModalStation multiModalStation) {
        this.id = multiModalStation.getId();
        this.name = multiModalStation.getName();
        this.lat = multiModalStation.getLat();
        this.lon = multiModalStation.getLon();
        this.code = multiModalStation.getCode();
        this.description = NonLocalizedString.ofNullable(multiModalStation.getDescription());
        this.url = multiModalStation.getUrl();
        this.timezone = null;
        this.childStops = multiModalStation.getChildStops();
        this.parentStation = null;
    }

    public final FeedScopedId getId() {
        return this.id;
    }

    public I18NString getName() {
        return this.name;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public String getCode() {
        return this.code;
    }

    public I18NString getDescription() {
        return this.description;
    }

    public I18NString getUrl() {
        return this.url;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public Collection<StopLocation> getChildStops() {
        return this.childStops;
    }

    public MonoOrMultiModalStation getParentStation() {
        return this.parentStation;
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MonoOrMultiModalStation other = (MonoOrMultiModalStation)obj;
        return this.getId().equals(other.getId());
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + this.getId() + "}";
    }
}

