/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.framework;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.transit.model.organization.Agency;

public class AuthorityType {
    public static GraphQLObjectType create(GraphQLOutputType lineType, GraphQLOutputType ptSituationElementType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name("Authority").description("Authority involved in public transportation. An organisation under which the responsibility of organising the transport service in a certain area is placed.").field(GqlUtil.newTransitIdField()).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("url").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("timezone").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lang").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("phone").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fareUrl").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lines").withDirective(gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)lineType))).dataFetcher(environment -> GqlUtil.getTransitService(environment).getAllRoutes().stream().filter(route -> Objects.equals(route.getAgency(), environment.getSource())).collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").withDirective(gqlUtil.timingData).description("Get all situations active for the authority.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)ptSituationElementType)))).dataFetcher(environment -> GqlUtil.getTransitService(environment).getTransitAlertService().getAgencyAlerts(((Agency)environment.getSource()).getId())).build()).build();
    }
}

