/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.routing.api.request.framework.DurationForEnum;
import org.opentripplanner.transit.model.basic.TransitMode;

public class TransportModeSlack {
    private static final String BOARD_SLACK_DESCRIPTION = "The boardSlack is the minimum extra time to board a public transport vehicle. This is the same as the 'minimumTransferTime', except that this also apply to to the first transit leg in the trip.";
    private static final String ALIGHT_SLACK_DESCRIPTION = "The alightSlack is the minimum extra time after exiting a public transport vehicle.";
    private static final GraphQLNonNull INT_TYPE = GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLInt);
    private static final GraphQLNonNull MODE_LIST_TYPE = GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)EnumTypes.TRANSPORT_MODE)));
    private static final GraphQLInputObjectType SLACK_INPUT_TYPE = GraphQLInputObjectType.newInputObject().name("TransportModeSlack").description("Used to specify board and alight slack for a given modes.").field(GraphQLInputObjectField.newInputObjectField().name("slack").description("The slack used for all given modes.").type((GraphQLInputType)INT_TYPE).build()).field(GraphQLInputObjectField.newInputObjectField().name("modes").description("List of modes for which the given slack apply.").type((GraphQLInputType)MODE_LIST_TYPE).build()).build();
    private static final GraphQLOutputType SLACK_OUTPUT_TYPE = GraphQLObjectType.newObject().name("TransportModeSlackType").description("Used to specify board and alight slack for a given modes.").field(GraphQLFieldDefinition.newFieldDefinition().name("slack").type((GraphQLOutputType)INT_TYPE).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("modes").type((GraphQLOutputType)MODE_LIST_TYPE).build()).build();
    public static final GraphQLList SLACK_LIST_INPUT_TYPE = GraphQLList.list((GraphQLType)SLACK_INPUT_TYPE);
    public static final GraphQLList SLACK_LIST_OUTPUT_TYPE = GraphQLList.list((GraphQLType)SLACK_OUTPUT_TYPE);
    public final int slack;
    public final List<TransitMode> modes;

    private TransportModeSlack(int slack, List<TransitMode> modes) {
        this.slack = slack;
        this.modes = modes;
    }

    public static String boardSlackDescription(String byGroupName) {
        return BOARD_SLACK_DESCRIPTION + " " + TransportModeSlack.defaultDescription(byGroupName);
    }

    public static String alightSlackDescription(String byGroupName) {
        return ALIGHT_SLACK_DESCRIPTION + " " + TransportModeSlack.defaultDescription(byGroupName);
    }

    public static String slackByGroupDescription(String name) {
        return String.format("List of %s for a given set of modes.", name);
    }

    public static String slackByGroupDescription(String name, DurationForEnum<TransitMode> defaultValues) {
        return TransportModeSlack.slackByGroupDescription(name) + " " + TransportModeSlack.defaultsToString(defaultValues);
    }

    public static List<TransportModeSlack> mapToApiList(DurationForEnum<TransitMode> domain) {
        ArrayListMultimap modesBySlack = ArrayListMultimap.create();
        Arrays.stream(TransitMode.values()).filter(domain::isSet).forEach(arg_0 -> TransportModeSlack.lambda$mapToApiList$0((Multimap)modesBySlack, domain, arg_0));
        ArrayList<TransportModeSlack> result = new ArrayList<TransportModeSlack>();
        modesBySlack.asMap().forEach((k, v) -> result.add(new TransportModeSlack((int)k, List.copyOf(v))));
        result.sort(Comparator.comparingInt(a -> a.slack));
        return result;
    }

    public static void mapIntoDomain(DurationForEnum.Builder<TransitMode> builder, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            for (Map map : list) {
                int slack = (Integer)map.get("slack");
                List modes = (List)map.get("modes");
                modes.forEach(m -> builder.with((TransitMode)((Object)m), Duration.ofSeconds(slack)));
            }
        } else {
            throw new IllegalArgumentException("Expected List, but got: " + value + " (" + value.getClass() + ")");
        }
    }

    public String toString() {
        if (this.modes == null) {
            return "{slack: " + this.slack + "}";
        }
        return "{" + this.modes.stream().map(TransportModeSlack::serializeTransportMode).collect(Collectors.toList()) + " : " + this.slack + "}";
    }

    private static String defaultDescription(String groupName) {
        return String.format("This is the default value used, if not overridden by the '%s'.", groupName);
    }

    private static String defaultsToString(Map<TransitMode, Integer> byMode) {
        ArrayList groups = new ArrayList();
        byMode.forEach((m, v) -> groups.add(TransportModeSlack.serializeTransportMode(m) + " : " + v));
        Collections.sort(groups);
        return "Defaults: " + groups;
    }

    private static String defaultsToString(DurationForEnum<TransitMode> byMode) {
        ArrayList groups = new ArrayList();
        Arrays.stream(TransitMode.values()).filter(byMode::isSet).forEach(m -> groups.add(TransportModeSlack.serializeTransportMode(m) + " : " + byMode.valueOf((TransitMode)((Object)m))));
        Collections.sort(groups);
        return "Defaults: " + groups;
    }

    private static Object serializeTransportMode(TransitMode m) {
        return EnumTypes.TRANSPORT_MODE.serialize((Object)m);
    }

    private static /* synthetic */ void lambda$mapToApiList$0(Multimap modesBySlack, DurationForEnum domain, TransitMode m) {
        modesBySlack.put((Object)((int)domain.valueOf(m).toSeconds()), (Object)m);
    }
}

