/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitIdMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TransitIdMapper.class);
    private static String fixedFeedId = null;

    public static String mapEntityIDToApi(AbstractTransitEntity entity) {
        if (entity == null) {
            return null;
        }
        return TransitIdMapper.mapIDToApi(entity.getId());
    }

    public static String mapIDToApi(FeedScopedId id) {
        if (fixedFeedId != null) {
            return id.getId();
        }
        return id.toString();
    }

    public static List<FeedScopedId> mapIDsToDomainNullSafe(Collection<String> ids) {
        return ids == null ? List.of() : TransitIdMapper.mapIDsToDomain(ids);
    }

    public static List<FeedScopedId> mapIDsToDomain(Collection<String> ids) {
        if (ids == null) {
            return null;
        }
        ArrayList<FeedScopedId> list = new ArrayList<FeedScopedId>();
        for (String id : ids) {
            list.add(TransitIdMapper.mapIDToDomain(id));
        }
        return list;
    }

    public static FeedScopedId mapIDToDomain(String id) {
        if (id == null) {
            return null;
        }
        if (fixedFeedId != null) {
            return new FeedScopedId(fixedFeedId, id);
        }
        return FeedScopedId.parseId(id);
    }

    public static String setupFixedFeedId(Collection<? extends AbstractTransitEntity> entities) {
        fixedFeedId = "UNKNOWN_FEED";
        Map<String, Integer> feedIds = entities.stream().map(a -> a.getId().getFeedId()).collect(Collectors.groupingBy(it -> it, Collectors.reducing(0, i -> 1, Integer::sum)));
        if (feedIds.isEmpty()) {
            LOG.warn("No data, unable to resolve fixedFeedScope to use in the Transmodel GraphQL API.");
        } else if (feedIds.size() == 1) {
            fixedFeedId = feedIds.keySet().iterator().next();
        } else {
            fixedFeedId = (String)feedIds.entrySet().stream().max(Map.Entry.comparingByValue()).get().getKey();
            LOG.warn("More than one feedId exist in the list of agencies. The feed-id used bymost agencies will be picked.");
        }
        LOG.info("Starting Transmodel GraphQL Schema with fixed FeedId: '" + fixedFeedId + "'. All FeedScopedIds in API will be assumed to belong to this agency.");
        return fixedFeedId;
    }
}

