/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.ext.transmodelapi.TransmodelRequestContext;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.model.PlanResponse;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.ext.transmodelapi.model.TransportModeSlack;
import org.opentripplanner.ext.transmodelapi.model.plan.ItineraryFiltersInputType;
import org.opentripplanner.ext.transmodelapi.support.DataFetcherDecorator;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.algorithm.mapping.TripPlanMapper;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.RequestModesBuilder;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.routing.core.RouteMatcher;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmodelGraphQLPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(TransmodelGraphQLPlanner.class);

    public DataFetcherResult<PlanResponse> plan(DataFetchingEnvironment environment) {
        PlanResponse response = new PlanResponse();
        TransmodelRequestContext ctx = (TransmodelRequestContext)environment.getContext();
        OtpServerRequestContext serverContext = ctx.getServerContext();
        RouteRequest request = null;
        try {
            request = this.createRequest(environment);
            RoutingResponse res = ctx.getRoutingService().route(request);
            response.plan = res.getTripPlan();
            response.metadata = res.getMetadata();
            response.messages = res.getRoutingErrors();
            response.debugOutput = res.getDebugTimingAggregator().finishedRendering();
            response.previousPageCursor = res.getPreviousPageCursor();
            response.nextPageCursor = res.getNextPageCursor();
        }
        catch (Exception e) {
            LOG.error("System error: " + e.getMessage(), (Throwable)e);
            response.plan = TripPlanMapper.mapTripPlan(request, List.of());
            response.messages.add(new RoutingError(RoutingErrorCode.SYSTEM_ERROR, null));
        }
        Locale locale = request == null ? serverContext.defaultLocale() : request.locale();
        return DataFetcherResult.newResult().data((Object)response).localContext(Map.of("locale", locale)).build();
    }

    private GenericLocation toGenericLocation(Map<String, Object> m) {
        String placeRef;
        Map coordinates = (Map)m.get("coordinates");
        Double lat = null;
        Double lon = null;
        if (coordinates != null) {
            lat = (Double)coordinates.get("latitude");
            lon = (Double)coordinates.get("longitude");
        }
        FeedScopedId stopId = (placeRef = (String)m.get("place")) == null ? null : TransitIdMapper.mapIDToDomain(placeRef);
        String name = (String)m.get("name");
        name = name == null ? "" : name;
        return new GenericLocation(name, stopId, lat, lon);
    }

    private RouteRequest createRequest(DataFetchingEnvironment environment) {
        TransmodelRequestContext context = (TransmodelRequestContext)environment.getContext();
        OtpServerRequestContext serverContext = context.getServerContext();
        RouteRequest request = serverContext.defaultRouteRequest();
        DataFetcherDecorator callWith = new DataFetcherDecorator(environment);
        callWith.argument("locale", v -> request.setLocale(Locale.forLanguageTag(v)));
        callWith.argument("from", v -> request.setFrom(this.toGenericLocation((Map<String, Object>)v)));
        callWith.argument("to", v -> request.setTo(this.toGenericLocation((Map<String, Object>)v)));
        callWith.argument("dateTime", millisSinceEpoch -> request.setDateTime(Instant.ofEpochMilli((Long)millisSinceEpoch)));
        callWith.argument("searchWindow", m -> request.setSearchWindow(Duration.ofMinutes(m.intValue())));
        callWith.argument("pageCursor", request::setPageCursorFromEncoded);
        callWith.argument("timetableView", request::setTimetableView);
        callWith.argument("wheelchairAccessible", request::setWheelchair);
        callWith.argument("numTripPatterns", request::setNumItineraries);
        callWith.argument("arriveBy", request::setArriveBy);
        callWith.argument("preferred.authorities", authorities -> request.journey().transit().setPreferredAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("unpreferred.authorities", authorities -> request.journey().transit().setUnpreferredAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("whiteListed.authorities", authorities -> request.journey().transit().setWhiteListedAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("banned.authorities", authorities -> request.journey().transit().setBannedAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("preferred.lines", lines -> request.journey().transit().setPreferredRoutes(TransitIdMapper.mapIDsToDomain(lines)));
        callWith.argument("unpreferred.lines", lines -> request.journey().transit().setUnpreferredRoutes(TransitIdMapper.mapIDsToDomain(lines)));
        callWith.argument("whiteListed.lines", lines -> request.journey().transit().setWhiteListedRoutes(RouteMatcher.idMatcher(TransitIdMapper.mapIDsToDomain(lines))));
        callWith.argument("banned.lines", lines -> request.journey().transit().setBannedRoutes(RouteMatcher.idMatcher(TransitIdMapper.mapIDsToDomain(lines))));
        callWith.argument("banned.serviceJourneys", serviceJourneys -> request.journey().transit().setBannedTrips(TransitIdMapper.mapIDsToDomain(serviceJourneys)));
        callWith.argument("whiteListed.rentalNetworks", networks -> request.journey().rental().setAllowedNetworks(Set.copyOf(networks)));
        callWith.argument("banned.rentalNetworks", networks -> request.journey().rental().setBannedNetworks(Set.copyOf(networks)));
        RequestModes modes = this.getModes(environment, callWith);
        if (modes != null) {
            request.journey().setModes(modes);
        }
        request.withPreferences(preferences -> this.mapPreferences(environment, callWith, (RoutingPreferences.Builder)preferences));
        return request;
    }

    private void mapPreferences(DataFetchingEnvironment environment, DataFetcherDecorator callWith, RoutingPreferences.Builder preferences) {
        preferences.withWalk(b -> {
            callWith.argument("walkBoardCost", b::withBoardCost);
            callWith.argument("walkSpeed", b::withSpeed);
        });
        callWith.argument("walkReluctance", streetReluctance -> this.setStreetReluctance(preferences, (Double)streetReluctance));
        preferences.withBike(bike -> {
            callWith.argument("bikeSpeed", bike::withSpeed);
            callWith.argument("bikeSwitchTime", bike::withSwitchTime);
            callWith.argument("bikeSwitchCost", bike::withSwitchCost);
            callWith.argument("bicycleOptimisationMethod", bike::withOptimizeType);
            if (bike.optimizeType() == BicycleOptimizeType.TRIANGLE) {
                bike.withOptimizeTriangle(triangle -> {
                    callWith.argument("triangle.timeFactor", triangle::withTime);
                    callWith.argument("triangle.slopeFactor", triangle::withSlope);
                    callWith.argument("triangle.safetyFactor", triangle::withSafety);
                });
            }
        });
        preferences.withTransfer(transfer -> {
            callWith.argument("transferPenalty", transfer::withCost);
            callWith.argument("minimumTransferTime", transfer::withSlack);
            callWith.argument("transferSlack", transfer::withSlack);
            callWith.argument("waitReluctance", transfer::withWaitReluctance);
            callWith.argument("maximumTransfers", transfer::withMaxTransfers);
        });
        preferences.withTransit(tr -> {
            callWith.argument("preferred.otherThanPreferredLinesPenalty", tr::setOtherThanPreferredRoutesPenalty);
            tr.withBoardSlack(builder -> {
                callWith.argument("boardSlackDefault", builder::withDefaultSec);
                callWith.argument("boardSlackList", v -> TransportModeSlack.mapIntoDomain(builder, v));
            });
            tr.withAlightSlack(builder -> {
                callWith.argument("alightSlackDefault", builder::withDefaultSec);
                callWith.argument("alightSlackList", v -> TransportModeSlack.mapIntoDomain(builder, v));
            });
            callWith.argument("ignoreRealtimeUpdates", tr::setIgnoreRealtimeUpdates);
            callWith.argument("includePlannedCancellations", tr::setIncludePlannedCancellations);
        });
        preferences.withItineraryFilter(itineraryFilter -> {
            callWith.argument("debugItineraryFilter", itineraryFilter::withDebug);
            ItineraryFiltersInputType.mapToRequest(environment, callWith, itineraryFilter);
        });
        preferences.withRental(rental -> callWith.argument("useBikeRentalAvailabilityInformation", rental::withUseAvailabilityInformation));
    }

    private RequestModes getModes(DataFetchingEnvironment environment, DataFetcherDecorator callWith) {
        if (GqlUtil.hasArgument(environment, "modes")) {
            ElementWrapper accessMode = new ElementWrapper();
            ElementWrapper egressMode = new ElementWrapper();
            ElementWrapper directMode = new ElementWrapper();
            ElementWrapper transportModes = new ElementWrapper();
            callWith.argument("modes.accessMode", accessMode::set);
            callWith.argument("modes.egressMode", egressMode::set);
            callWith.argument("modes.directMode", directMode::set);
            callWith.argument("modes.transportModes", transportModes::set);
            RequestModesBuilder mBuilder = RequestModes.of().withAccessMode((StreetMode)((Object)accessMode.get())).withEgressMode((StreetMode)((Object)egressMode.get())).withDirectMode((StreetMode)((Object)directMode.get()));
            mBuilder.withTransferMode(accessMode.get() == StreetMode.BIKE ? StreetMode.BIKE : StreetMode.WALK);
            if (transportModes.get() == null) {
                mBuilder.withTransitModes(MainAndSubMode.all());
            } else {
                mBuilder.clearTransitModes();
                for (LinkedHashMap modeWithSubmodes : (List)transportModes.get()) {
                    if (!modeWithSubmodes.containsKey("transportMode")) continue;
                    TransitMode mainMode = (TransitMode)((Object)modeWithSubmodes.get("transportMode"));
                    if (modeWithSubmodes.containsKey("transportSubModes")) {
                        List transportSubModes = (List)modeWithSubmodes.get("transportSubModes");
                        for (TransmodelTransportSubmode submode : transportSubModes) {
                            mBuilder.withTransitMode(mainMode, submode.getValue());
                        }
                        continue;
                    }
                    mBuilder.withTransitMode(mainMode);
                }
            }
            return mBuilder.build();
        }
        return null;
    }

    private void setStreetReluctance(RoutingPreferences.Builder preferences, Double streetReluctance) {
        if (streetReluctance > 0.0) {
            preferences.withWalk(walk -> walk.withReluctance(streetReluctance));
            preferences.withBike(bike -> bike.withReluctance(streetReluctance).withWalkingReluctance(streetReluctance * 2.7));
            preferences.withCar(car -> car.withReluctance(streetReluctance));
        }
    }

    private static class ElementWrapper<T> {
        private T element;

        private ElementWrapper() {
        }

        void set(T element) {
            this.element = element;
        }

        T get() {
            return this.element;
        }
    }
}

