/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transferanalyzer.annotations;

import org.opentripplanner.graph_builder.DataImportIssue;
import org.opentripplanner.transit.model.site.RegularStop;

public class TransferRoutingDistanceTooLong
implements DataImportIssue {
    private static final String FMT = "Routing distance between stop %s and stop %s is %.0f times longer than the euclidean distance. Street distance: %.2f, direct distance: %.2f.";
    private static final String HTMLFMT = "Routing distance between stop <a href=\"http://www.openstreetmap.org/?mlat=%s&mlon=%s\">\"%s\" (%s)</a> and stop <a href=\"http://www.openstreetmap.org/?mlat=%s&mlon=%s\">\"%s\" (%s)</a> is %.0f times longer than the euclidean distance. Street distance: %.2f, direct distance: %.2f.";
    private final RegularStop origin;
    private final RegularStop destination;
    private final double directDistance;
    private final double streetDistance;
    private final double ratio;

    public TransferRoutingDistanceTooLong(RegularStop origin, RegularStop destination, double directDistance, double streetDistance, double ratio) {
        this.origin = origin;
        this.destination = destination;
        this.directDistance = directDistance;
        this.streetDistance = streetDistance;
        this.ratio = ratio;
    }

    @Override
    public String getMessage() {
        return String.format(FMT, this.origin, this.destination, this.ratio, this.streetDistance, this.directDistance);
    }

    @Override
    public String getHTMLMessage() {
        return String.format(HTMLFMT, this.origin.getLat(), this.origin.getLon(), this.origin.getName(), this.origin.getId(), this.destination.getLat(), this.destination.getLon(), this.destination.getName(), this.destination.getId(), this.ratio, this.streetDistance, this.directDistance);
    }
}

