/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.opentripplanner.ext.siri.SiriHttpUtils;
import org.opentripplanner.ext.siri.updater.SiriHelper;
import org.opentripplanner.ext.siri.updater.VehicleMonitoringSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.Siri;

public class SiriVMHttpTripUpdateSource
implements VehicleMonitoringSource {
    private static final Logger LOG = LoggerFactory.getLogger(SiriVMHttpTripUpdateSource.class);
    private static final long RETRY_INTERVAL_MILLIS = 5000L;
    private static final Map<String, String> requestHeaders = new HashMap<String, String>();
    private final String feedId;
    private final String url;
    private final String originalRequestorRef;
    private boolean fullDataset = true;
    private ZonedDateTime lastTimestamp = ZonedDateTime.now().minusMonths(1L);
    private String requestorRef;
    private int timeout;
    private int retryCount = 0;

    public SiriVMHttpTripUpdateSource(Parameters parameters) {
        this.url = parameters.getUrl();
        this.requestorRef = parameters.getRequestorRef();
        if (this.requestorRef == null || this.requestorRef.isEmpty()) {
            this.requestorRef = "otp-" + UUID.randomUUID();
        }
        this.originalRequestorRef = this.requestorRef;
        this.feedId = parameters.getFeedId();
        int timeoutSec = parameters.getTimeoutSec();
        if (timeoutSec > 0) {
            this.timeout = 1000 * timeoutSec;
        }
        requestHeaders.put("ET-Client-Name", SiriHttpUtils.getUniqueETClientName("-VM"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Siri getUpdates() {
        long unmarshalling;
        long fetching;
        long creating;
        block7: {
            Siri siri;
            Siri siri2;
            long t1;
            block8: {
                t1 = System.currentTimeMillis();
                creating = 0L;
                fetching = 0L;
                unmarshalling = 0L;
                this.fullDataset = false;
                String vmServiceRequest = SiriHelper.createVMServiceRequestAsXml(this.requestorRef);
                creating = System.currentTimeMillis() - t1;
                t1 = System.currentTimeMillis();
                InputStream is = SiriHttpUtils.postData(this.url, vmServiceRequest, this.timeout, requestHeaders);
                if (is == null) break block7;
                fetching = System.currentTimeMillis() - t1;
                t1 = System.currentTimeMillis();
                siri2 = SiriHelper.unmarshal(is);
                unmarshalling = System.currentTimeMillis() - t1;
                if (!siri2.getServiceDelivery().getResponseTimestamp().isBefore(this.lastTimestamp)) break block8;
                LOG.info("Newer data has already been processed");
                Siri siri3 = null;
                LOG.info("Updating VM [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
                return siri3;
            }
            try {
                this.lastTimestamp = siri2.getServiceDelivery().getResponseTimestamp();
                siri = siri2;
            }
            catch (IOException | JAXBException | XMLStreamException e) {
                Siri siri4;
                try {
                    LOG.info("Failed after {} ms", (Object)(System.currentTimeMillis() - t1));
                    LOG.warn("Failed to parse SIRI-VM feed from {}", (Object)this.url, (Object)e);
                    long sleepTime = 5000L + 5000L * (long)this.retryCount;
                    ++this.retryCount;
                    LOG.info("Caught timeout - retry no. {} after {} millis", (Object)this.retryCount, (Object)sleepTime);
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.requestorRef = this.originalRequestorRef + "-retry-" + this.retryCount;
                    siri4 = this.getUpdates();
                }
                catch (Throwable throwable) {
                    LOG.info("Updating VM [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
                    throw throwable;
                }
                LOG.info("Updating VM [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
                return siri4;
            }
            LOG.info("Updating VM [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
            return siri;
        }
        LOG.info("Updating VM [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
        return null;
    }

    @Override
    public boolean getFullDatasetValueOfLastUpdates() {
        return this.fullDataset;
    }

    @Override
    public String getFeedId() {
        return this.feedId;
    }

    public String toString() {
        return "SiriVMHttpTripUpdateSource(" + this.url + ")";
    }

    static interface Parameters {
        public String getUrl();

        public String getRequestorRef();

        public String getFeedId();

        public int getTimeoutSec();
    }
}

