/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.datatype.Duration;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.util.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri20.CallStatusEnumeration;
import uk.org.siri.siri20.DataFrameRefStructure;
import uk.org.siri.siri20.DepartureBoardingActivityEnumeration;
import uk.org.siri.siri20.EstimatedCall;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.MonitoredCallStructure;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.OccupancyEnumeration;
import uk.org.siri.siri20.RecordedCall;
import uk.org.siri.siri20.VehicleActivityStructure;

public class TimetableHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TimetableHelper.class);

    public static Result<TripTimes, UpdateError> createUpdatedTripTimes(Timetable timetable, EstimatedVehicleJourney journey, FeedScopedId tripId, Function<FeedScopedId, StopLocation> getStopById, ZoneId zoneId, Deduplicator deduplicator) {
        Result<?, UpdateError> result;
        if (journey == null) {
            return null;
        }
        TripTimes existingTripTimes = timetable.getTripTimes(tripId);
        if (existingTripTimes == null) {
            LOG.debug("tripId {} not found in pattern.", (Object)tripId);
            return UpdateError.result(tripId, UpdateError.UpdateErrorType.TRIP_NOT_FOUND_IN_PATTERN);
        }
        TripTimes oldTimes = new TripTimes(existingTripTimes);
        if (journey.isCancellation() != null && journey.isCancellation().booleanValue()) {
            oldTimes.cancelTrip();
            return Result.success(oldTimes);
        }
        List<EstimatedCall> estimatedCalls = TimetableHelper.getEstimatedCalls(journey);
        List<RecordedCall> recordedCalls = TimetableHelper.getRecordedCalls(journey);
        EstimatedCall lastEstimatedCall = estimatedCalls.isEmpty() ? null : estimatedCalls.get(estimatedCalls.size() - 1);
        RecordedCall lastRecordedCall = recordedCalls.isEmpty() ? null : recordedCalls.get(recordedCalls.size() - 1);
        boolean stopPatternChanged = false;
        TripPattern pattern = timetable.getPattern();
        List<StopTime> modifiedStopTimes = TimetableHelper.createModifiedStopTimes(pattern, oldTimes, journey, getStopById);
        if (modifiedStopTimes == null) {
            return UpdateError.result(tripId, UpdateError.UpdateErrorType.UNKNOWN);
        }
        TripTimes newTimes = new TripTimes(oldTimes.getTrip(), modifiedStopTimes, deduplicator);
        newTimes.setServiceCode(oldTimes.getServiceCode());
        OccupancyEnumeration journeyOccupancy = journey.getOccupancy();
        int callCounter = 0;
        LocalDate serviceDate = TimetableHelper.getServiceDate(journey, zoneId, oldTimes);
        ZonedDateTime startOfService = ServiceDateUtils.asStartOfService(serviceDate, zoneId);
        HashSet<Object> alreadyVisited = new HashSet<Object>();
        boolean isJourneyPredictionInaccurate = journey.isPredictionInaccurate() != null && journey.isPredictionInaccurate() != false;
        int departureFromPreviousStop = 0;
        int lastArrivalDelay = 0;
        int lastDepartureDelay = 0;
        for (StopLocation stop : pattern.getStops()) {
            boolean foundMatch = false;
            for (RecordedCall recordedCall : recordedCalls) {
                OccupancyEnumeration callOccupancy;
                StopLocation alternativeStop;
                if (alreadyVisited.contains(recordedCall)) continue;
                foundMatch = stop.getId().getId().equals(recordedCall.getStopPointRef().getValue());
                if (!foundMatch && stop.isPartOfStation() && (alternativeStop = getStopById.apply(new FeedScopedId(stop.getId().getFeedId(), recordedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                    foundMatch = true;
                    stopPatternChanged = true;
                }
                if (!foundMatch) continue;
                int arrivalTime = newTimes.getArrivalTime(callCounter);
                Supplier[] supplierArray = new Supplier[6];
                supplierArray[0] = () -> ((RecordedCall)recordedCall).getActualArrivalTime();
                supplierArray[1] = callCounter == 0 ? () -> ((RecordedCall)recordedCall).getActualDepartureTime() : () -> null;
                supplierArray[2] = () -> ((RecordedCall)recordedCall).getExpectedArrivalTime();
                supplierArray[3] = callCounter == 0 ? () -> ((RecordedCall)recordedCall).getExpectedDepartureTime() : () -> null;
                supplierArray[4] = () -> ((RecordedCall)recordedCall).getAimedArrivalTime();
                supplierArray[5] = callCounter == 0 ? () -> ((RecordedCall)recordedCall).getAimedDepartureTime() : () -> null;
                Integer realtimeArrivalTime = TimetableHelper.getAvailableTime(startOfService, supplierArray);
                if (realtimeArrivalTime == null) {
                    realtimeArrivalTime = arrivalTime;
                }
                int arrivalDelay = realtimeArrivalTime - arrivalTime;
                newTimes.updateArrivalDelay(callCounter, arrivalDelay);
                lastArrivalDelay = arrivalDelay;
                int departureTime = newTimes.getDepartureTime(callCounter);
                boolean isLastStop = estimatedCalls.isEmpty() && lastRecordedCall == recordedCall;
                Supplier[] supplierArray2 = new Supplier[5];
                supplierArray2[0] = () -> ((RecordedCall)recordedCall).getActualDepartureTime();
                supplierArray2[1] = () -> ((RecordedCall)recordedCall).getExpectedDepartureTime();
                supplierArray2[2] = isLastStop ? () -> ((RecordedCall)recordedCall).getExpectedArrivalTime() : () -> null;
                supplierArray2[3] = () -> ((RecordedCall)recordedCall).getAimedDepartureTime();
                supplierArray2[4] = isLastStop ? () -> ((RecordedCall)recordedCall).getAimedArrivalTime() : () -> null;
                Integer realtimeDepartureTime = TimetableHelper.getAvailableTime(startOfService, supplierArray2);
                if (realtimeDepartureTime == null) {
                    realtimeDepartureTime = departureTime;
                }
                boolean isCallPredictionInaccurate = Boolean.TRUE.equals(recordedCall.isPredictionInaccurate());
                if (recordedCall.isCancellation() != null && recordedCall.isCancellation().booleanValue()) {
                    modifiedStopTimes.get(callCounter).cancel();
                    newTimes.setCancelled(callCounter);
                } else if (isJourneyPredictionInaccurate | isCallPredictionInaccurate) {
                    newTimes.setPredictionInaccurate(callCounter);
                } else if (recordedCall.getActualArrivalTime() != null || recordedCall.getActualDepartureTime() != null) {
                    newTimes.setRecorded(callCounter);
                }
                int departureDelay = realtimeDepartureTime - departureTime;
                newTimes.updateDepartureDelay(callCounter, departureDelay);
                lastDepartureDelay = departureDelay;
                departureFromPreviousStop = newTimes.getDepartureTime(callCounter);
                OccupancyEnumeration occupancyEnumeration = callOccupancy = recordedCall.getOccupancy() != null ? recordedCall.getOccupancy() : journeyOccupancy;
                if (callOccupancy != null) {
                    newTimes.setOccupancyStatus(callCounter, TimetableHelper.resolveOccupancyStatus(callOccupancy));
                }
                alreadyVisited.add(recordedCall);
                break;
            }
            if (!foundMatch) {
                for (EstimatedCall estimatedCall : estimatedCalls) {
                    OccupancyEnumeration callOccupancy;
                    CallStatusEnumeration departureStatus;
                    boolean isCallPredictionInaccurate;
                    StopLocation alternativeStop;
                    if (alreadyVisited.contains(estimatedCall)) continue;
                    foundMatch = stop.getId().getId().equals(estimatedCall.getStopPointRef().getValue());
                    if (!foundMatch && stop.isPartOfStation() && (alternativeStop = getStopById.apply(new FeedScopedId(stop.getId().getFeedId(), estimatedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        foundMatch = true;
                        stopPatternChanged = true;
                    }
                    if (!foundMatch) continue;
                    boolean bl = isCallPredictionInaccurate = estimatedCall.isPredictionInaccurate() != null && estimatedCall.isPredictionInaccurate() != false;
                    if (estimatedCall.isCancellation() != null && estimatedCall.isCancellation().booleanValue()) {
                        modifiedStopTimes.get(callCounter).cancel();
                        newTimes.setCancelled(callCounter);
                    } else if (isJourneyPredictionInaccurate | isCallPredictionInaccurate) {
                        newTimes.setPredictionInaccurate(callCounter);
                    }
                    CallStatusEnumeration arrivalStatus = estimatedCall.getArrivalStatus();
                    if (arrivalStatus == CallStatusEnumeration.CANCELLED) {
                        modifiedStopTimes.get(callCounter).cancelDropOff();
                    }
                    if ((departureStatus = estimatedCall.getDepartureStatus()) == CallStatusEnumeration.CANCELLED) {
                        modifiedStopTimes.get(callCounter).cancelPickup();
                    }
                    int arrivalTime = newTimes.getArrivalTime(callCounter);
                    Supplier[] supplierArray = new Supplier[4];
                    supplierArray[0] = () -> ((EstimatedCall)estimatedCall).getExpectedArrivalTime();
                    supplierArray[1] = callCounter == 0 ? () -> ((EstimatedCall)estimatedCall).getExpectedDepartureTime() : () -> null;
                    supplierArray[2] = () -> ((EstimatedCall)estimatedCall).getAimedArrivalTime();
                    supplierArray[3] = callCounter == 0 ? () -> ((EstimatedCall)estimatedCall).getAimedDepartureTime() : () -> null;
                    Integer realtimeArrivalTime = TimetableHelper.getAvailableTime(startOfService, supplierArray);
                    int departureTime = newTimes.getDepartureTime(callCounter);
                    boolean isLastStop = lastEstimatedCall == estimatedCall;
                    Supplier[] supplierArray3 = new Supplier[4];
                    supplierArray3[0] = () -> ((EstimatedCall)estimatedCall).getExpectedDepartureTime();
                    supplierArray3[1] = isLastStop ? () -> ((EstimatedCall)estimatedCall).getExpectedArrivalTime() : () -> null;
                    supplierArray3[2] = () -> ((EstimatedCall)estimatedCall).getAimedDepartureTime();
                    supplierArray3[3] = isLastStop ? () -> ((EstimatedCall)estimatedCall).getAimedArrivalTime() : () -> null;
                    Integer realtimeDepartureTime = TimetableHelper.getAvailableTime(startOfService, supplierArray3);
                    if (realtimeDepartureTime == null) {
                        realtimeDepartureTime = departureTime;
                    }
                    if (realtimeArrivalTime == null) {
                        realtimeArrivalTime = realtimeDepartureTime;
                    }
                    int arrivalDelay = realtimeArrivalTime - arrivalTime;
                    newTimes.updateArrivalDelay(callCounter, arrivalDelay);
                    lastArrivalDelay = arrivalDelay;
                    int departureDelay = realtimeDepartureTime - departureTime;
                    newTimes.updateDepartureDelay(callCounter, departureDelay);
                    lastDepartureDelay = departureDelay;
                    departureFromPreviousStop = newTimes.getDepartureTime(callCounter);
                    OccupancyEnumeration occupancyEnumeration = callOccupancy = estimatedCall.getOccupancy() != null ? estimatedCall.getOccupancy() : journeyOccupancy;
                    if (callOccupancy != null) {
                        newTimes.setOccupancyStatus(callCounter, TimetableHelper.resolveOccupancyStatus(callOccupancy));
                    }
                    alreadyVisited.add(estimatedCall);
                    break;
                }
            }
            if (!foundMatch) {
                if (pattern.isBoardAndAlightAt(callCounter, PickDrop.NONE)) {
                    newTimes.updateArrivalTime(callCounter, departureFromPreviousStop);
                    newTimes.updateDepartureTime(callCounter, departureFromPreviousStop);
                } else {
                    int arrivalDelay = lastArrivalDelay;
                    int departureDelay = lastDepartureDelay;
                    if (lastArrivalDelay == 0 && lastDepartureDelay == 0) {
                        arrivalDelay = existingTripTimes.getArrivalDelay(callCounter);
                        departureDelay = existingTripTimes.getDepartureDelay(callCounter);
                    }
                    newTimes.updateArrivalDelay(callCounter, arrivalDelay);
                    newTimes.updateDepartureDelay(callCounter, departureDelay);
                }
                departureFromPreviousStop = newTimes.getDepartureTime(callCounter);
            }
            ++callCounter;
        }
        if (stopPatternChanged) {
            newTimes.setRealTimeState(RealTimeState.MODIFIED);
        } else {
            newTimes.setRealTimeState(RealTimeState.UPDATED);
        }
        if (journey.isCancellation() != null && journey.isCancellation().booleanValue()) {
            LOG.debug("Trip is cancelled");
            newTimes.cancelTrip();
        }
        if ((result = newTimes.validateNonIncreasingTimes()).isFailure()) {
            UpdateError updateError = result.failureValue();
            LOG.info("TripTimes are non-increasing after applying SIRI delay propagation - LineRef {}, TripId {}. Stop index {}", new Object[]{journey.getLineRef().getValue(), tripId, updateError.stopIndex()});
            return Result.failure(updateError);
        }
        if (newTimes.getNumStops() != pattern.numberOfStops()) {
            return UpdateError.result(tripId, UpdateError.UpdateErrorType.TOO_FEW_STOPS);
        }
        LOG.debug("A valid TripUpdate object was applied using the Timetable class update method.");
        return Result.success(newTimes);
    }

    private static int calculateDayOffset(TripTimes oldTimes) {
        if (oldTimes.getDepartureTime(0) > 86400) {
            return oldTimes.getDepartureTime(0) / 86400;
        }
        return 0;
    }

    private static OccupancyStatus resolveOccupancyStatus(OccupancyEnumeration occupancy) {
        if (occupancy != null) {
            return switch (occupancy) {
                default -> throw new IncompatibleClassChangeError();
                case OccupancyEnumeration.SEATS_AVAILABLE -> OccupancyStatus.MANY_SEATS_AVAILABLE;
                case OccupancyEnumeration.STANDING_AVAILABLE -> OccupancyStatus.STANDING_ROOM_ONLY;
                case OccupancyEnumeration.FULL -> OccupancyStatus.FULL;
            };
        }
        return OccupancyStatus.NO_DATA;
    }

    public static List<StopLocation> createModifiedStops(TripPattern pattern, EstimatedVehicleJourney journey, Function<FeedScopedId, StopLocation> getStopForId) {
        if (journey == null) {
            return null;
        }
        List<EstimatedCall> estimatedCalls = TimetableHelper.getEstimatedCalls(journey);
        List<RecordedCall> recordedCalls = TimetableHelper.getRecordedCalls(journey);
        ArrayList<Object> alreadyVisited = new ArrayList<Object>();
        ArrayList<StopLocation> modifiedStops = new ArrayList<StopLocation>();
        for (int i = 0; i < pattern.numberOfStops(); ++i) {
            StopLocation stop = pattern.getStop(i);
            boolean foundMatch = false;
            if (i < recordedCalls.size()) {
                for (RecordedCall recordedCall : recordedCalls) {
                    if (alreadyVisited.contains(recordedCall)) continue;
                    stopsMatchById = stop.getId().getId().equals(recordedCall.getStopPointRef().getValue());
                    if (!stopsMatchById && stop.isPartOfStation() && (alternativeStop = getStopForId.apply(new FeedScopedId(stop.getId().getFeedId(), recordedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        stopsMatchById = true;
                        stop = alternativeStop;
                    }
                    if (!stopsMatchById) continue;
                    foundMatch = true;
                    modifiedStops.add(stop);
                    alreadyVisited.add(recordedCall);
                    break;
                }
            } else {
                for (EstimatedCall estimatedCall : estimatedCalls) {
                    if (alreadyVisited.contains(estimatedCall)) continue;
                    stopsMatchById = stop.getId().getId().equals(estimatedCall.getStopPointRef().getValue());
                    if (!stopsMatchById && stop.isPartOfStation() && (alternativeStop = getStopForId.apply(new FeedScopedId(stop.getId().getFeedId(), estimatedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        stopsMatchById = true;
                        stop = alternativeStop;
                    }
                    if (!stopsMatchById) continue;
                    foundMatch = true;
                    modifiedStops.add(stop);
                    alreadyVisited.add(estimatedCall);
                    break;
                }
            }
            if (foundMatch) continue;
            modifiedStops.add(stop);
        }
        return modifiedStops;
    }

    public static List<StopTime> createModifiedStopTimes(TripPattern pattern, TripTimes oldTimes, EstimatedVehicleJourney journey, Function<FeedScopedId, StopLocation> getStopForId) {
        if (journey == null) {
            return null;
        }
        List<EstimatedCall> estimatedCalls = TimetableHelper.getEstimatedCalls(journey);
        List<RecordedCall> recordedCalls = TimetableHelper.getRecordedCalls(journey);
        List<StopLocation> stops = TimetableHelper.createModifiedStops(pattern, journey, getStopForId);
        ArrayList<StopTime> modifiedStops = new ArrayList<StopTime>();
        int numberOfRecordedCalls = recordedCalls.size();
        HashSet<Object> alreadyVisited = new HashSet<Object>();
        for (int i = 0; i < stops.size(); ++i) {
            StopLocation stop = stops.get(i);
            StopTime stopTime = new StopTime();
            stopTime.setStop(stop);
            stopTime.setTrip(oldTimes.getTrip());
            stopTime.setStopSequence(i);
            stopTime.setDropOffType(pattern.getAlightType(i));
            stopTime.setPickupType(pattern.getBoardType(i));
            stopTime.setArrivalTime(oldTimes.getScheduledArrivalTime(i));
            stopTime.setDepartureTime(oldTimes.getScheduledDepartureTime(i));
            stopTime.setStopHeadsign(oldTimes.getHeadsign(i));
            stopTime.setHeadsignVias(oldTimes.getHeadsignVias(i));
            stopTime.setTimepoint(oldTimes.isTimepoint(i) ? 1 : 0);
            boolean foundMatch = false;
            if (i < numberOfRecordedCalls) {
                for (RecordedCall recordedCall : recordedCalls) {
                    StopLocation alternativeStop;
                    if (alreadyVisited.contains(recordedCall)) continue;
                    String callStopRef = recordedCall.getStopPointRef().getValue();
                    boolean stopsMatchById = stop.getId().getId().equals(callStopRef);
                    if (!stopsMatchById && stop.isPartOfStation() && (alternativeStop = getStopForId.apply(new FeedScopedId(stop.getId().getFeedId(), callStopRef))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        stopsMatchById = true;
                        stopTime.setStop(alternativeStop);
                    }
                    if (!stopsMatchById) continue;
                    foundMatch = true;
                    if (recordedCall.isCancellation() != null && recordedCall.isCancellation().booleanValue()) {
                        stopTime.cancel();
                    }
                    modifiedStops.add(stopTime);
                    alreadyVisited.add(recordedCall);
                    break;
                }
            } else {
                for (EstimatedCall estimatedCall : estimatedCalls) {
                    StopLocation alternativeStop;
                    if (alreadyVisited.contains(estimatedCall)) continue;
                    boolean stopsMatchById = stop.getId().getId().equals(estimatedCall.getStopPointRef().getValue());
                    if (!stopsMatchById && stop.isPartOfStation() && (alternativeStop = getStopForId.apply(new FeedScopedId(stop.getId().getFeedId(), estimatedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        stopsMatchById = true;
                        stopTime.setStop(alternativeStop);
                    }
                    if (!stopsMatchById) continue;
                    foundMatch = true;
                    CallStatusEnumeration arrivalStatus = estimatedCall.getArrivalStatus();
                    if (arrivalStatus == CallStatusEnumeration.CANCELLED) {
                        stopTime.cancelDropOff();
                    }
                    Optional<PickDrop> dropOffType = TimetableHelper.mapDropOffType(stopTime.getDropOffType(), estimatedCall.getArrivalBoardingActivity());
                    dropOffType.ifPresent(stopTime::setDropOffType);
                    CallStatusEnumeration departureStatus = estimatedCall.getDepartureStatus();
                    if (departureStatus == CallStatusEnumeration.CANCELLED) {
                        stopTime.cancelPickup();
                    }
                    Optional<PickDrop> pickUpType = TimetableHelper.mapPickUpType(stopTime.getPickupType(), estimatedCall.getDepartureBoardingActivity());
                    pickUpType.ifPresent(stopTime::setPickupType);
                    if (estimatedCall.isCancellation() != null && estimatedCall.isCancellation().booleanValue()) {
                        stopTime.cancel();
                    }
                    if (estimatedCall.getDestinationDisplaies() != null && !estimatedCall.getDestinationDisplaies().isEmpty()) {
                        NaturalLanguageStringStructure destinationDisplay = (NaturalLanguageStringStructure)estimatedCall.getDestinationDisplaies().get(0);
                        stopTime.setStopHeadsign(new NonLocalizedString(destinationDisplay.getValue()));
                    }
                    modifiedStops.add(stopTime);
                    alreadyVisited.add(estimatedCall);
                    break;
                }
            }
            if (foundMatch) continue;
            modifiedStops.add(stopTime);
        }
        return modifiedStops;
    }

    public static Result<TripTimes, UpdateError> createUpdatedTripTimes(Timetable timetable, VehicleActivityStructure activity, FeedScopedId tripId, Function<FeedScopedId, StopLocation> getStopById) {
        Result<?, UpdateError> result;
        if (activity == null) {
            return Result.failure(new UpdateError(tripId, UpdateError.UpdateErrorType.INVALID_INPUT_STRUCTURE));
        }
        VehicleActivityStructure.MonitoredVehicleJourney mvj = activity.getMonitoredVehicleJourney();
        TripTimes existingTripTimes = timetable.getTripTimes(tripId);
        if (existingTripTimes == null) {
            LOG.trace("tripId {} not found in pattern.", (Object)tripId);
            return Result.failure(new UpdateError(tripId, UpdateError.UpdateErrorType.TRIP_NOT_FOUND_IN_PATTERN));
        }
        TripTimes newTimes = new TripTimes(existingTripTimes);
        MonitoredCallStructure update = mvj.getMonitoredCall();
        if (update == null) {
            return Result.failure(new UpdateError(tripId, UpdateError.UpdateErrorType.INVALID_INPUT_STRUCTURE));
        }
        VehicleActivityStructure.MonitoredVehicleJourney monitoredVehicleJourney = activity.getMonitoredVehicleJourney();
        if (monitoredVehicleJourney != null) {
            MonitoredCallStructure monitoredCall;
            Duration delay = monitoredVehicleJourney.getDelay();
            int updatedDelay = 0;
            if (delay != null) {
                updatedDelay = delay.getSign() * (delay.getHours() * 3600 + delay.getMinutes() * 60 + delay.getSeconds());
            }
            if ((monitoredCall = monitoredVehicleJourney.getMonitoredCall()) != null && monitoredCall.getStopPointRef() != null) {
                boolean matchFound = false;
                int arrivalDelay = 0;
                int departureDelay = 0;
                TripPattern pattern = timetable.getPattern();
                for (int index = 0; index < newTimes.getNumStops(); ++index) {
                    if (!matchFound) {
                        FeedScopedId alternativeId;
                        StopLocation alternativeStop;
                        StopLocation stop = pattern.getStop(index);
                        matchFound = stop.getId().getId().equals(monitoredCall.getStopPointRef().getValue());
                        if (!matchFound && stop.isPartOfStation() && (alternativeStop = getStopById.apply(alternativeId = new FeedScopedId(stop.getId().getFeedId(), monitoredCall.getStopPointRef().getValue()))) != null && alternativeStop.isPartOfStation()) {
                            matchFound = stop.isPartOfSameStationAs(alternativeStop);
                        }
                        if (matchFound) {
                            arrivalDelay = departureDelay = updatedDelay;
                        } else {
                            arrivalDelay = Math.min(existingTripTimes.getArrivalDelay(index), updatedDelay);
                            departureDelay = Math.min(existingTripTimes.getDepartureDelay(index), updatedDelay);
                        }
                    }
                    newTimes.updateArrivalDelay(index, arrivalDelay);
                    newTimes.updateDepartureDelay(index, departureDelay);
                }
            }
        }
        if ((result = newTimes.validateNonIncreasingTimes()).isFailure()) {
            UpdateError error = result.failureValue();
            LOG.info("TripTimes are non-increasing after applying SIRI delay propagation - LineRef {}, TripId {}. Stop index {}", new Object[]{timetable.getPattern().getRoute().getId(), tripId, error.stopIndex()});
            return Result.failure(error);
        }
        if (newTimes.getRealTimeState() != RealTimeState.MODIFIED) {
            newTimes.setRealTimeState(RealTimeState.UPDATED);
        }
        return Result.success(newTimes);
    }

    @SafeVarargs
    private static Integer getAvailableTime(ZonedDateTime startOfService, Supplier<ZonedDateTime> ... timeSuppliers) {
        for (Supplier<ZonedDateTime> supplier : timeSuppliers) {
            ZonedDateTime time = supplier.get();
            if (time == null) continue;
            return ServiceDateUtils.secondsSinceStartOfService(startOfService, time);
        }
        return null;
    }

    private static List<RecordedCall> getRecordedCalls(EstimatedVehicleJourney journey) {
        EstimatedVehicleJourney.RecordedCalls journeyRecordedCalls = journey.getRecordedCalls();
        if (journeyRecordedCalls != null) {
            return journeyRecordedCalls.getRecordedCalls();
        }
        return List.of();
    }

    private static List<EstimatedCall> getEstimatedCalls(EstimatedVehicleJourney journey) {
        EstimatedVehicleJourney.EstimatedCalls journeyEstimatedCalls = journey.getEstimatedCalls();
        if (journeyEstimatedCalls != null) {
            return journeyEstimatedCalls.getEstimatedCalls();
        }
        return List.of();
    }

    public static Optional<PickDrop> mapDropOffType(PickDrop currentValue, ArrivalBoardingActivityEnumeration arrivalBoardingActivityEnumeration) {
        if (arrivalBoardingActivityEnumeration == null) {
            return Optional.empty();
        }
        return switch (arrivalBoardingActivityEnumeration) {
            default -> throw new IncompatibleClassChangeError();
            case ArrivalBoardingActivityEnumeration.ALIGHTING -> {
                if (currentValue.isNotRoutable()) {
                    yield Optional.of(PickDrop.SCHEDULED);
                }
                yield Optional.empty();
            }
            case ArrivalBoardingActivityEnumeration.NO_ALIGHTING -> Optional.of(PickDrop.NONE);
            case ArrivalBoardingActivityEnumeration.PASS_THRU -> Optional.of(PickDrop.CANCELLED);
        };
    }

    public static Optional<PickDrop> mapPickUpType(PickDrop currentValue, DepartureBoardingActivityEnumeration departureBoardingActivityEnumeration) {
        if (departureBoardingActivityEnumeration == null) {
            return Optional.empty();
        }
        return switch (departureBoardingActivityEnumeration) {
            default -> throw new IncompatibleClassChangeError();
            case DepartureBoardingActivityEnumeration.BOARDING -> {
                if (currentValue.isNotRoutable()) {
                    yield Optional.of(PickDrop.SCHEDULED);
                }
                yield Optional.empty();
            }
            case DepartureBoardingActivityEnumeration.NO_BOARDING -> Optional.of(PickDrop.NONE);
            case DepartureBoardingActivityEnumeration.PASS_THRU -> Optional.of(PickDrop.CANCELLED);
        };
    }

    private static LocalDate getServiceDate(EstimatedVehicleJourney journey, ZoneId zoneId, TripTimes oldTimes) {
        DataFrameRefStructure dataFrame;
        if (journey.getFramedVehicleJourneyRef() != null && journey.getFramedVehicleJourneyRef().getDataFrameRef() != null && (dataFrame = journey.getFramedVehicleJourneyRef().getDataFrameRef()) != null) {
            try {
                return LocalDate.parse(dataFrame.getValue());
            }
            catch (DateTimeParseException ignored) {
                LOG.warn("Invalid dataFrame format: {}", (Object)dataFrame.getValue());
            }
        }
        EstimatedVehicleJourney.RecordedCalls recordedCalls = journey.getRecordedCalls();
        EstimatedVehicleJourney.EstimatedCalls estimatedCalls = journey.getEstimatedCalls();
        ZonedDateTime firstDeparture = recordedCalls.getRecordedCalls().isEmpty() ? ((EstimatedCall)estimatedCalls.getEstimatedCalls().get(0)).getAimedDepartureTime() : ((RecordedCall)recordedCalls.getRecordedCalls().get(0)).getAimedDepartureTime();
        return firstDeparture.minusDays(TimetableHelper.calculateDayOffset(oldTimes)).withZoneSameInstant(zoneId).toLocalDate();
    }
}

