/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.SiriTransportModeMapper;
import org.opentripplanner.ext.siri.SiriTripPatternCache;
import org.opentripplanner.ext.siri.SiriTripPatternIdGenerator;
import org.opentripplanner.ext.siri.TimetableHelper;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.TimetableSnapshotProvider;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RouteBuilder;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripBuilder;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.TimetableSnapshotSourceParameters;
import org.opentripplanner.updater.trip.UpdateResult;
import org.opentripplanner.util.time.ServiceDateUtils;
import org.rutebanken.netex.model.BusSubmodeEnumeration;
import org.rutebanken.netex.model.RailSubmodeEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri20.DatedVehicleJourneyRef;
import uk.org.siri.siri20.DepartureBoardingActivityEnumeration;
import uk.org.siri.siri20.EstimatedCall;
import uk.org.siri.siri20.EstimatedTimetableDeliveryStructure;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.EstimatedVersionFrameStructure;
import uk.org.siri.siri20.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri20.MonitoredVehicleJourneyStructure;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.RecordedCall;
import uk.org.siri.siri20.VehicleActivityStructure;
import uk.org.siri.siri20.VehicleModesEnumeration;
import uk.org.siri.siri20.VehicleMonitoringDeliveryStructure;

public class SiriTimetableSnapshotSource
implements TimetableSnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SiriTimetableSnapshotSource.class);
    private static boolean keepLogging = true;
    private final TimetableSnapshot buffer = new TimetableSnapshot();
    private final ReentrantLock bufferLock = new ReentrantLock(true);
    private final SiriTripPatternIdGenerator tripPatternIdGenerator = new SiriTripPatternIdGenerator();
    private final SiriTripPatternCache tripPatternCache = new SiriTripPatternCache(this.tripPatternIdGenerator);
    private final ZoneId timeZone;
    private final TransitService transitService;
    private final TransitLayerUpdater transitLayerUpdater;
    private final int maxSnapshotFrequency;
    private volatile TimetableSnapshot snapshot = null;
    private final boolean purgeExpiredData;
    protected LocalDate lastPurgeDate = null;
    protected long lastSnapshotTime = -1L;

    public SiriTimetableSnapshotSource(TimetableSnapshotSourceParameters parameters, TransitModel transitModel) {
        this.timeZone = transitModel.getTimeZone();
        this.transitService = new DefaultTransitService(transitModel);
        this.transitLayerUpdater = transitModel.getTransitLayerUpdater();
        this.maxSnapshotFrequency = parameters.maxSnapshotFrequencyMs();
        this.purgeExpiredData = parameters.purgeExpiredData();
        transitModel.initTimetableSnapshotProvider(this);
    }

    @Override
    public TimetableSnapshot getTimetableSnapshot() {
        TimetableSnapshot snapshotToReturn;
        if (this.bufferLock.tryLock()) {
            try {
                snapshotToReturn = this.getTimetableSnapshot(false);
            }
            finally {
                this.bufferLock.unlock();
            }
        } else {
            snapshotToReturn = this.snapshot;
        }
        return snapshotToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyVehicleMonitoring(TransitModel transitModel, SiriFuzzyTripMatcher fuzzyTripMatcher, String feedId, boolean fullDataset, List<VehicleMonitoringDeliveryStructure> updates) {
        if (updates == null) {
            LOG.warn("updates is null");
            return;
        }
        this.bufferLock.lock();
        try {
            if (fullDataset) {
                this.buffer.clear(feedId);
            }
            for (VehicleMonitoringDeliveryStructure vmDelivery : updates) {
                List notes;
                List cancellations;
                LocalDate serviceDate = LocalDate.now(this.transitService.getTimeZone());
                List activities = vmDelivery.getVehicleActivities();
                if (activities != null) {
                    LOG.info("Handling {} VM-activities.", (Object)activities.size());
                    int handledCounter = 0;
                    int skippedCounter = 0;
                    for (VehicleActivityStructure activity : activities) {
                        boolean handled = this.handleModifiedTrip(transitModel, fuzzyTripMatcher, activity, serviceDate, feedId);
                        if (handled) {
                            ++handledCounter;
                            continue;
                        }
                        ++skippedCounter;
                    }
                    LOG.info("Applied {} VM-activities, skipped {}.", (Object)handledCounter, (Object)skippedCounter);
                }
                if ((cancellations = vmDelivery.getVehicleActivityCancellations()) != null && !cancellations.isEmpty()) {
                    LOG.info("TODO: Handle {} cancellations.", (Object)cancellations.size());
                }
                if ((notes = vmDelivery.getVehicleActivityNotes()) == null || notes.isEmpty()) continue;
                LOG.info("TODO: Handle {} notes.", (Object)notes.size());
            }
            if (this.purgeExpiredData) {
                boolean modified = this.purgeExpiredData();
                this.getTimetableSnapshot(modified);
            } else {
                this.getTimetableSnapshot(false);
            }
        }
        finally {
            this.bufferLock.unlock();
            if (keepLogging) {
                LOG.info("Reducing SIRI-VM logging until restart");
                keepLogging = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult applyEstimatedTimetable(TransitModel transitModel, SiriFuzzyTripMatcher fuzzyTripMatcher, String feedId, boolean fullDataset, List<EstimatedTimetableDeliveryStructure> updates) {
        if (updates == null) {
            LOG.warn("updates is null");
            return UpdateResult.empty();
        }
        this.bufferLock.lock();
        ArrayList results = new ArrayList();
        try {
            if (fullDataset) {
                this.buffer.clear(feedId);
            }
            for (EstimatedTimetableDeliveryStructure etDelivery : updates) {
                List<Result<?, UpdateError>> res = this.apply(etDelivery, transitModel, feedId, fuzzyTripMatcher);
                results.addAll(res);
            }
            LOG.debug("message contains {} trip updates", (Object)updates.size());
            LOG.debug("end of update message");
            if (this.purgeExpiredData) {
                boolean modified = this.purgeExpiredData();
                this.getTimetableSnapshot(modified);
            } else {
                this.getTimetableSnapshot(false);
            }
        }
        finally {
            this.bufferLock.unlock();
        }
        return UpdateResult.ofResults(results);
    }

    private List<Result<?, UpdateError>> apply(EstimatedTimetableDeliveryStructure etDelivery, TransitModel transitModel, String feedId, SiriFuzzyTripMatcher fuzzyTripMatcher) {
        ArrayList results = new ArrayList();
        List estimatedJourneyVersions = etDelivery.getEstimatedJourneyVersionFrames();
        if (estimatedJourneyVersions != null) {
            for (EstimatedVersionFrameStructure estimatedJourneyVersion : estimatedJourneyVersions) {
                List journeys = estimatedJourneyVersion.getEstimatedVehicleJourneies();
                LOG.debug("Handling {} EstimatedVehicleJourneys.", (Object)journeys.size());
                for (EstimatedVehicleJourney journey : journeys) {
                    if (journey.isExtraJourney() != null && journey.isExtraJourney().booleanValue()) {
                        try {
                            Result<?, UpdateError> res = this.handleAddedTrip(transitModel, feedId, journey);
                            results.add(res);
                        }
                        catch (Throwable t) {
                            LOG.warn("Adding ExtraJourney with id='{}' failed, caused by '{}'.", (Object)journey.getEstimatedVehicleJourneyCode(), (Object)t.getMessage());
                            results.add(Result.failure(UpdateError.noTripId(UpdateError.UpdateErrorType.UNKNOWN)));
                        }
                        continue;
                    }
                    Result<?, List<UpdateError>> result = this.handleModifiedTrip(transitModel, fuzzyTripMatcher, feedId, journey);
                    result.ifSuccess(ignored -> results.add(Result.success()));
                    result.ifFailure(failures -> {
                        failures.stream().map(Result::failure).forEach(results::add);
                        if (journey.isMonitored() != null && !journey.isMonitored().booleanValue()) {
                            results.add(Result.success(UpdateError.noTripId(UpdateError.UpdateErrorType.NOT_MONITORED)));
                        }
                    });
                }
            }
        }
        return results;
    }

    private TimetableSnapshot getTimetableSnapshot(boolean force) {
        long now = System.currentTimeMillis();
        if (force || now - this.lastSnapshotTime > (long)this.maxSnapshotFrequency) {
            if (force || this.buffer.isDirty()) {
                LOG.debug("Committing {}", (Object)this.buffer);
                this.snapshot = this.buffer.commit(this.transitLayerUpdater, force);
            } else {
                LOG.debug("Buffer was unchanged, keeping old snapshot.");
            }
            this.lastSnapshotTime = System.currentTimeMillis();
        } else {
            LOG.debug("Snapshot frequency exceeded. Reusing snapshot {}", (Object)this.snapshot);
        }
        return this.snapshot;
    }

    private boolean handleModifiedTrip(TransitModel transitModel, SiriFuzzyTripMatcher fuzzyTripMatcher, VehicleActivityStructure activity, LocalDate serviceDate, String feedId) {
        if (activity.getValidUntilTime().isBefore(ZonedDateTime.now())) {
            return false;
        }
        VehicleActivityStructure.MonitoredVehicleJourney monitoredVehicleJourney = activity.getMonitoredVehicleJourney();
        if (monitoredVehicleJourney == null || monitoredVehicleJourney.getVehicleRef() == null || monitoredVehicleJourney.getLineRef() == null) {
            return false;
        }
        Boolean isMonitored = monitoredVehicleJourney.isMonitored();
        if (isMonitored != null && !isMonitored.booleanValue()) {
            return false;
        }
        Set<Trip> trips = fuzzyTripMatcher.match((MonitoredVehicleJourneyStructure)monitoredVehicleJourney, feedId);
        if (trips == null || trips.isEmpty()) {
            if (keepLogging) {
                String lineRef = monitoredVehicleJourney.getLineRef() != null ? monitoredVehicleJourney.getLineRef().getValue() : null;
                String vehicleRef = monitoredVehicleJourney.getVehicleRef() != null ? monitoredVehicleJourney.getVehicleRef().getValue() : null;
                String tripId = monitoredVehicleJourney.getCourseOfJourneyRef() != null ? monitoredVehicleJourney.getCourseOfJourneyRef().getValue() : null;
                LOG.debug("No trip found for [isMonitored={}, lineRef={}, vehicleRef={}, tripId={}], skipping VehicleActivity.", new Object[]{isMonitored, lineRef, vehicleRef, tripId});
            }
            return false;
        }
        Trip trip = this.getTripForJourney(trips, (MonitoredVehicleJourneyStructure)monitoredVehicleJourney);
        if (trip == null) {
            return false;
        }
        Set<TripPattern> patterns = this.getPatternsForTrip(trips, (MonitoredVehicleJourneyStructure)monitoredVehicleJourney);
        if (patterns == null) {
            return false;
        }
        boolean success = false;
        for (TripPattern pattern : patterns) {
            if (!this.handleTripPatternUpdate(transitModel, pattern, activity, trip, serviceDate).isSuccess()) continue;
            success = true;
        }
        if (!success) {
            LOG.info("Pattern not updated for trip {}", (Object)trip.getId());
        }
        return success;
    }

    private Result<?, UpdateError> handleTripPatternUpdate(TransitModel transitModel, TripPattern pattern, VehicleActivityStructure activity, Trip trip, LocalDate serviceDate) {
        Timetable currentTimetable = this.getCurrentTimetable(pattern, serviceDate);
        Result<TripTimes, UpdateError> result = TimetableHelper.createUpdatedTripTimes(currentTimetable, activity, trip.getId(), transitModel::getStopLocationById);
        if (result.isFailure()) {
            return result;
        }
        return this.buffer.update(pattern, result.successValue(), serviceDate);
    }

    private Timetable getCurrentTimetable(TripPattern tripPattern, LocalDate serviceDate) {
        TimetableSnapshot timetableSnapshot = this.snapshot;
        if (timetableSnapshot != null) {
            return timetableSnapshot.resolve(tripPattern, serviceDate);
        }
        return tripPattern.getScheduledTimetable();
    }

    private Result<?, UpdateError> handleAddedTrip(TransitModel transitModel, String feedId, EstimatedVehicleJourney estimatedVehicleJourney) {
        String newServiceJourneyRef = estimatedVehicleJourney.getEstimatedVehicleJourneyCode();
        Objects.requireNonNull(newServiceJourneyRef, "EstimatedVehicleJourneyCode is required");
        Objects.requireNonNull(estimatedVehicleJourney.getLineRef(), "LineRef is required");
        String lineRef = estimatedVehicleJourney.getLineRef().getValue();
        Objects.requireNonNull(estimatedVehicleJourney.getOperatorRef(), "OperatorRef is required");
        String operatorRef = estimatedVehicleJourney.getOperatorRef().getValue();
        String externalLineRef = estimatedVehicleJourney.getExternalLineRef() != null ? estimatedVehicleJourney.getExternalLineRef().getValue() : lineRef;
        Operator operator = transitModel.getTransitModelIndex().getOperatorForId().get(new FeedScopedId(feedId, operatorRef));
        FeedScopedId tripId = new FeedScopedId(feedId, newServiceJourneyRef);
        Route replacedRoute = externalLineRef != null ? transitModel.getTransitModelIndex().getRouteForId(new FeedScopedId(feedId, externalLineRef)) : null;
        FeedScopedId routeId = new FeedScopedId(feedId, lineRef);
        Route route = transitModel.getTransitModelIndex().getRouteForId(routeId);
        T2<TransitMode, String> transitMode = this.getTransitMode(estimatedVehicleJourney.getVehicleModes(), replacedRoute);
        if (route == null) {
            RouteBuilder routeBuilder = Route.of(routeId);
            routeBuilder.withMode((TransitMode)((Object)transitMode.first));
            routeBuilder.withNetexSubmode((String)transitMode.second);
            routeBuilder.withOperator(operator);
            Agency agency = transitModel.getTransitModelIndex().getAllRoutes().stream().filter(route1 -> route1 != null && route1.getOperator() != null && route1.getOperator().equals(operator)).findFirst().map(Route::getAgency).orElseGet(() -> replacedRoute.getAgency());
            routeBuilder.withAgency(agency);
            if (estimatedVehicleJourney.getPublishedLineNames() != null && !estimatedVehicleJourney.getPublishedLineNames().isEmpty()) {
                routeBuilder.withShortName(((NaturalLanguageStringStructure)estimatedVehicleJourney.getPublishedLineNames().get(0)).getValue());
            }
            route = (Route)routeBuilder.build();
            LOG.info("Adding route {} to transitModel.", (Object)routeId);
            transitModel.getTransitModelIndex().addRoutes(route);
        }
        TripBuilder tripBuilder = Trip.of(tripId);
        tripBuilder.withRoute(route);
        tripBuilder.withMode((TransitMode)((Object)transitMode.first));
        tripBuilder.withNetexSubmode((String)transitMode.second);
        LocalDate serviceDate = this.getServiceDateForEstimatedVehicleJourney(estimatedVehicleJourney);
        if (serviceDate == null) {
            return UpdateError.result(tripId, UpdateError.UpdateErrorType.NO_START_DATE);
        }
        FeedScopedId calServiceId = transitModel.getOrCreateServiceIdForDate(serviceDate);
        if (calServiceId == null) {
            return UpdateError.result(tripId, UpdateError.UpdateErrorType.NO_START_DATE);
        }
        tripBuilder.withServiceId(calServiceId);
        if (estimatedVehicleJourney.getDestinationNames() != null && !estimatedVehicleJourney.getDestinationNames().isEmpty()) {
            NonLocalizedString str = new NonLocalizedString(((NaturalLanguageStringStructure)estimatedVehicleJourney.getDestinationNames().get(0)).getValue());
            tripBuilder.withHeadsign(str);
        }
        tripBuilder.withOperator(operator);
        tripBuilder.withShapeId(null);
        tripBuilder.withGtfsBlockId(null);
        tripBuilder.withShortName(null);
        Trip trip = (Trip)tripBuilder.build();
        ArrayList<StopLocation> addedStops = new ArrayList<StopLocation>();
        ArrayList<StopTime> aimedStopTimes = new ArrayList<StopTime>();
        ZonedDateTime departureTime = null;
        List estimatedCalls = estimatedVehicleJourney.getEstimatedCalls().getEstimatedCalls();
        for (int i = 0; i < estimatedCalls.size(); ++i) {
            EstimatedCall estimatedCall = (EstimatedCall)estimatedCalls.get(i);
            RegularStop stop = this.transitService.getRegularStop(new FeedScopedId(feedId, estimatedCall.getStopPointRef().getValue()));
            StopTime stopTime = new StopTime();
            stopTime.setStop(stop);
            stopTime.setStopSequence(i);
            stopTime.setTrip(trip);
            ZonedDateTime aimedArrivalTime = estimatedCall.getAimedArrivalTime();
            ZonedDateTime aimedDepartureTime = estimatedCall.getAimedDepartureTime();
            if (departureTime == null) {
                departureTime = aimedDepartureTime;
            }
            if (aimedArrivalTime != null) {
                stopTime.setArrivalTime(this.calculateSecondsSinceMidnight(departureTime, aimedArrivalTime));
            }
            if (aimedDepartureTime != null) {
                stopTime.setDepartureTime(this.calculateSecondsSinceMidnight(departureTime, aimedDepartureTime));
            }
            if (estimatedCall.getArrivalBoardingActivity() == ArrivalBoardingActivityEnumeration.ALIGHTING) {
                stopTime.setDropOffType(PickDrop.SCHEDULED);
            } else {
                stopTime.setDropOffType(PickDrop.NONE);
            }
            if (estimatedCall.getDepartureBoardingActivity() == DepartureBoardingActivityEnumeration.BOARDING) {
                stopTime.setPickupType(PickDrop.SCHEDULED);
            } else {
                stopTime.setPickupType(PickDrop.NONE);
            }
            if (estimatedCall.getDestinationDisplaies() != null && !estimatedCall.getDestinationDisplaies().isEmpty()) {
                NaturalLanguageStringStructure destinationDisplay = (NaturalLanguageStringStructure)estimatedCall.getDestinationDisplaies().get(0);
                stopTime.setStopHeadsign(new NonLocalizedString(destinationDisplay.getValue()));
            } else if (tripBuilder.getHeadsign() == null) {
                stopTime.setStopHeadsign(new NonLocalizedString(""));
            }
            if (i == 0) {
                stopTime.setArrivalTime(stopTime.getDepartureTime());
            } else if (i == estimatedCalls.size() - 1) {
                stopTime.setDepartureTime(stopTime.getArrivalTime());
            }
            if (estimatedCall.isCancellation() != null && estimatedCall.isCancellation().booleanValue()) {
                stopTime.cancel();
            }
            addedStops.add(stop);
            aimedStopTimes.add(stopTime);
        }
        StopPattern stopPattern = new StopPattern(aimedStopTimes);
        FeedScopedId id = this.tripPatternIdGenerator.generateUniqueTripPatternId(trip);
        TripPattern pattern = (TripPattern)TripPattern.of(id).withRoute(tripBuilder.getRoute()).withStopPattern(stopPattern).build();
        TripTimes tripTimes = new TripTimes(trip, aimedStopTimes, transitModel.getDeduplicator());
        boolean isJourneyPredictionInaccurate = estimatedVehicleJourney.isPredictionInaccurate() != null && estimatedVehicleJourney.isPredictionInaccurate() != false;
        for (int i = 0; i < estimatedCalls.size(); ++i) {
            boolean isCallPredictionInaccurate;
            EstimatedCall estimatedCall = (EstimatedCall)estimatedCalls.get(i);
            ZonedDateTime expectedArrival = estimatedCall.getExpectedArrivalTime();
            ZonedDateTime expectedDeparture = estimatedCall.getExpectedDepartureTime();
            int aimedArrivalTime = ((StopTime)aimedStopTimes.get(i)).getArrivalTime();
            int aimedDepartureTime = ((StopTime)aimedStopTimes.get(i)).getDepartureTime();
            if (expectedArrival != null) {
                int expectedArrivalTime = this.calculateSecondsSinceMidnight(departureTime, expectedArrival);
                tripTimes.updateArrivalDelay(i, expectedArrivalTime - aimedArrivalTime);
            }
            if (expectedDeparture != null) {
                int expectedDepartureTime = this.calculateSecondsSinceMidnight(departureTime, expectedDeparture);
                tripTimes.updateDepartureDelay(i, expectedDepartureTime - aimedDepartureTime);
            }
            boolean bl = isCallPredictionInaccurate = estimatedCall.isPredictionInaccurate() != null && estimatedCall.isPredictionInaccurate() != false;
            if (estimatedCall.isCancellation() != null && estimatedCall.isCancellation().booleanValue()) {
                tripTimes.setCancelled(i);
            } else if (isJourneyPredictionInaccurate | isCallPredictionInaccurate) {
                tripTimes.setPredictionInaccurate(i);
            }
            if (i == 0) {
                tripTimes.updateArrivalTime(i, tripTimes.getDepartureTime(i));
                continue;
            }
            if (i != estimatedCalls.size() - 1) continue;
            tripTimes.updateDepartureTime(i, tripTimes.getArrivalTime(i));
        }
        transitModel.getTransitModelIndex().getTripForId().put(tripId, trip);
        transitModel.getTransitModelIndex().getPatternForTrip().put(trip, pattern);
        if (estimatedVehicleJourney.isCancellation() != null && estimatedVehicleJourney.isCancellation().booleanValue()) {
            tripTimes.cancelTrip();
        } else {
            tripTimes.setRealTimeState(RealTimeState.ADDED);
        }
        tripTimes.setServiceCode(transitModel.getServiceCodes().get(calServiceId));
        pattern.add(tripTimes);
        tripTimes.validateNonIncreasingTimes().ifFailure(error -> {
            throw new IllegalStateException(String.format("Non-increasing triptimes for added trip at stop index %d, error %s", new Object[]{error.stopIndex(), error.errorType()}));
        });
        return this.addTripToGraphAndBuffer(feedId, transitModel, trip, aimedStopTimes, addedStops, tripTimes, serviceDate, estimatedVehicleJourney);
    }

    private T2<TransitMode, String> getTransitMode(List<VehicleModesEnumeration> vehicleModes, Route replacedRoute) {
        TransitMode transitMode = SiriTransportModeMapper.mapTransitMainMode(vehicleModes);
        String transitSubMode = this.resolveTransitSubMode(transitMode, replacedRoute);
        return new T2<TransitMode, String>(transitMode, transitSubMode);
    }

    private String resolveTransitSubMode(TransitMode transitMode, Route replacedRoute) {
        TransitMode replacedRouteMode;
        if (replacedRoute != null && (replacedRouteMode = replacedRoute.getMode()) == TransitMode.RAIL) {
            if (transitMode.equals((Object)TransitMode.RAIL)) {
                return RailSubmodeEnumeration.REPLACEMENT_RAIL_SERVICE.value();
            }
            if (transitMode.equals((Object)TransitMode.BUS)) {
                return BusSubmodeEnumeration.RAIL_REPLACEMENT_BUS.value();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Result<?, List<UpdateError>> handleModifiedTrip(TransitModel transitModel, SiriFuzzyTripMatcher fuzzyTripMatcher, String feedId, EstimatedVehicleJourney estimatedVehicleJourney) {
        if (estimatedVehicleJourney.isMonitored() != null && !estimatedVehicleJourney.isMonitored().booleanValue() && estimatedVehicleJourney.isCancellation() != null && !estimatedVehicleJourney.isCancellation().booleanValue()) {
            return Result.success();
        }
        String operatorRef = estimatedVehicleJourney.getOperatorRef() != null ? estimatedVehicleJourney.getOperatorRef().getValue() : null;
        String vehicleModes = "" + estimatedVehicleJourney.getVehicleModes();
        String lineRef = estimatedVehicleJourney.getLineRef().getValue();
        String vehicleRef = estimatedVehicleJourney.getVehicleRef() != null ? estimatedVehicleJourney.getVehicleRef().getValue() : null;
        LocalDate serviceDate = this.getServiceDateForEstimatedVehicleJourney(estimatedVehicleJourney);
        if (serviceDate == null) {
            return Result.success();
        }
        HashSet<TripTimes> times = new HashSet<TripTimes>();
        HashSet<TripPattern> patterns = new HashSet<TripPattern>();
        Trip tripMatchedByServiceJourneyId = SiriFuzzyTripMatcher.findTripByDatedVehicleJourneyRef(estimatedVehicleJourney, feedId, this.transitService);
        if (tripMatchedByServiceJourneyId != null) {
            TripPattern exactPattern = this.transitService.getPatternForTrip(tripMatchedByServiceJourneyId);
            if (exactPattern != null) {
                Timetable currentTimetable = this.getCurrentTimetable(exactPattern, serviceDate);
                Result<TripTimes, UpdateError> updateResult = TimetableHelper.createUpdatedTripTimes(currentTimetable, estimatedVehicleJourney, tripMatchedByServiceJourneyId.getId(), transitModel::getStopLocationById, this.timeZone, transitModel.getDeduplicator());
                if (!updateResult.isSuccess()) {
                    LOG.info("Failed to update TripTimes for trip found by exact match {}", (Object)tripMatchedByServiceJourneyId.getId());
                    return Result.failure(List.of((UpdateError)updateResult.failureValue()));
                }
                times.add((TripTimes)updateResult.successValue());
                patterns.add(exactPattern);
            }
        } else if (fuzzyTripMatcher != null) {
            Set<Trip> trips = fuzzyTripMatcher.match(estimatedVehicleJourney, feedId);
            if (trips == null || trips.isEmpty()) {
                LOG.debug("No trips found for EstimatedVehicleJourney. [operator={}, vehicleModes={}, lineRef={}, vehicleRef={}]", new Object[]{operatorRef, vehicleModes, lineRef, vehicleRef});
                return Result.failure(List.of(new UpdateError(null, UpdateError.UpdateErrorType.NO_FUZZY_TRIP_MATCH)));
            }
            Set<Trip> matchingTrips = this.getTripForJourney(trips, estimatedVehicleJourney);
            if (matchingTrips == null || matchingTrips.isEmpty()) {
                LOG.debug("Found no matching trip for SIRI ET (serviceDate, departureTime). [operator={}, vehicleModes={}, lineRef={}, vehicleJourneyRef={}]", new Object[]{operatorRef, vehicleModes, lineRef, vehicleRef});
                return Result.failure(List.of(new UpdateError(null, UpdateError.UpdateErrorType.NO_FUZZY_TRIP_MATCH)));
            }
            for (Trip matchingTrip : matchingTrips) {
                TripPattern pattern = this.getPatternForTrip(matchingTrip, estimatedVehicleJourney);
                if (pattern == null) continue;
                Timetable currentTimetable = this.getCurrentTimetable(pattern, serviceDate);
                Result<TripTimes, UpdateError> updateResult = TimetableHelper.createUpdatedTripTimes(currentTimetable, estimatedVehicleJourney, matchingTrip.getId(), transitModel::getStopLocationById, this.timeZone, transitModel.getDeduplicator());
                updateResult.ifSuccess(tripTimes -> {
                    patterns.add(pattern);
                    times.add((TripTimes)tripTimes);
                });
            }
        }
        if (patterns.isEmpty()) {
            LOG.debug("Found no matching pattern for SIRI ET (firstStopId, lastStopId, numberOfStops). [operator={}, vehicleModes={}, lineRef={}, vehicleRef={}]", new Object[]{operatorRef, vehicleModes, lineRef, vehicleRef});
            return Result.failure(List.of(new UpdateError(null, UpdateError.UpdateErrorType.TRIP_NOT_FOUND_IN_PATTERN)));
        }
        if (times.isEmpty()) {
            return Result.failure(List.of(new UpdateError(null, UpdateError.UpdateErrorType.NO_UPDATES)));
        }
        ArrayList errors = new ArrayList();
        Iterator iterator = times.iterator();
        block1: while (true) {
            if (!iterator.hasNext()) {
                if (errors.isEmpty()) {
                    return Result.success();
                }
                return Result.failure(errors);
            }
            TripTimes tripTimes2 = (TripTimes)iterator.next();
            Trip trip = tripTimes2.getTrip();
            Iterator iterator2 = patterns.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block1;
                TripPattern pattern = (TripPattern)iterator2.next();
                if (tripTimes2.getNumStops() == pattern.numberOfStops()) {
                    this.cancelScheduledTrip(trip, serviceDate);
                    this.removePreviousRealtimeUpdate(trip, serviceDate);
                    if (!tripTimes2.isCanceled()) {
                        List<StopLocation> modifiedStops = TimetableHelper.createModifiedStops(pattern, estimatedVehicleJourney, transitModel::getStopLocationById);
                        List<StopTime> modifiedStopTimes = TimetableHelper.createModifiedStopTimes(pattern, tripTimes2, estimatedVehicleJourney, transitModel::getStopLocationById);
                        if (modifiedStops != null && modifiedStops.isEmpty()) {
                            tripTimes2.cancelTrip();
                        } else {
                            this.addTripToGraphAndBuffer(feedId, transitModel, trip, modifiedStopTimes, modifiedStops, tripTimes2, serviceDate, estimatedVehicleJourney).ifFailure(errors::add);
                        }
                    }
                    LOG.debug("Applied realtime data for trip {}", (Object)trip.getId().getId());
                    continue;
                }
                LOG.debug("Ignoring update since number of stops do not match");
            }
            break;
        }
    }

    private LocalDate getServiceDateForEstimatedVehicleJourney(EstimatedVehicleJourney estimatedVehicleJourney) {
        ZonedDateTime date;
        if (estimatedVehicleJourney.getRecordedCalls() != null && !estimatedVehicleJourney.getRecordedCalls().getRecordedCalls().isEmpty()) {
            date = ((RecordedCall)estimatedVehicleJourney.getRecordedCalls().getRecordedCalls().get(0)).getAimedDepartureTime();
        } else {
            EstimatedCall firstCall = (EstimatedCall)estimatedVehicleJourney.getEstimatedCalls().getEstimatedCalls().get(0);
            date = firstCall.getAimedDepartureTime();
        }
        if (date == null) {
            return null;
        }
        return date.toLocalDate();
    }

    private int calculateSecondsSinceMidnight(ZonedDateTime dateTime) {
        return ServiceDateUtils.secondsSinceStartOfService(dateTime, dateTime, this.transitService.getTimeZone());
    }

    private int calculateSecondsSinceMidnight(ZonedDateTime startOfService, ZonedDateTime dateTime) {
        return ServiceDateUtils.secondsSinceStartOfService(startOfService, dateTime, this.transitService.getTimeZone());
    }

    private Result<?, UpdateError> addTripToGraphAndBuffer(String feedId, TransitModel transitModel, Trip trip, List<StopTime> stopTimes, List<StopLocation> stops, TripTimes updatedTripTimes, LocalDate serviceDate, EstimatedVehicleJourney estimatedVehicleJourney) {
        Objects.requireNonNull(stops);
        Preconditions.checkArgument((stopTimes.size() == stops.size() ? 1 : 0) != 0, (Object)"number of stop should match the number of stop time updates");
        StopPattern stopPattern = new StopPattern(stopTimes);
        TripPattern pattern = this.tripPatternCache.getOrCreateTripPattern(stopPattern, trip, transitModel, serviceDate);
        Result<?, UpdateError> result = this.buffer.update(pattern, updatedTripTimes, serviceDate);
        this.addTripOnServiceDateToBuffer(trip, serviceDate, estimatedVehicleJourney, feedId);
        return result;
    }

    private void addTripOnServiceDateToBuffer(Trip trip, LocalDate serviceDate, EstimatedVehicleJourney estimatedVehicleJourney, String feedId) {
        Supplier<Optional> getFramedVehicleJourney = () -> Optional.ofNullable(estimatedVehicleJourney.getFramedVehicleJourneyRef()).map(FramedVehicleJourneyRefStructure::getDatedVehicleJourneyRef);
        Optional.ofNullable(estimatedVehicleJourney.getDatedVehicleJourneyRef()).map(DatedVehicleJourneyRef::getValue).or(getFramedVehicleJourney).ifPresent(datedServiceJourneyId -> this.buffer.addLastAddedTripOnServiceDate((TripOnServiceDate)TripOnServiceDate.of(new FeedScopedId(feedId, (String)datedServiceJourneyId)).withTrip(trip).withServiceDate(serviceDate).build()));
    }

    private boolean cancelScheduledTrip(Trip trip, LocalDate serviceDate) {
        boolean success = false;
        TripPattern pattern = this.transitService.getPatternForTrip(trip);
        if (pattern != null) {
            Timetable timetable = pattern.getScheduledTimetable();
            TripTimes tripTimes = timetable.getTripTimes(trip);
            if (tripTimes == null) {
                LOG.warn("Could not cancel scheduled trip {}", (Object)trip.getId());
            } else {
                TripTimes newTripTimes = new TripTimes(tripTimes);
                newTripTimes.cancelTrip();
                this.buffer.update(pattern, newTripTimes, serviceDate);
                success = true;
            }
        }
        return success;
    }

    private boolean removePreviousRealtimeUpdate(Trip trip, LocalDate serviceDate) {
        boolean success = false;
        TripPattern pattern = this.buffer.getRealtimeAddedTripPattern(trip.getId(), serviceDate);
        if (pattern != null) {
            this.buffer.removeLastAddedTripPattern(trip.getId(), serviceDate);
            this.buffer.removeRealtimeUpdatedTripTimes(pattern, trip.getId(), serviceDate);
            success = true;
        }
        return success;
    }

    private boolean purgeExpiredData() {
        LocalDate today = LocalDate.now(this.timeZone);
        LocalDate previously = today.minusDays(2L);
        if (this.lastPurgeDate != null && this.lastPurgeDate.compareTo(previously) > 0) {
            return false;
        }
        LOG.debug("purging expired realtime data");
        this.lastPurgeDate = previously;
        return this.buffer.purgeExpiredData(previously);
    }

    private Set<TripPattern> getPatternsForTrip(Set<Trip> matches, MonitoredVehicleJourneyStructure monitoredVehicleJourney) {
        if (monitoredVehicleJourney.getOriginRef() == null) {
            return null;
        }
        ZonedDateTime date = monitoredVehicleJourney.getOriginAimedDepartureTime();
        if (date == null) {
            date = ZonedDateTime.now(this.transitService.getTimeZone());
        }
        LocalDate realTimeReportedServiceDate = date.toLocalDate();
        HashSet<TripPattern> patterns = new HashSet<TripPattern>();
        for (Trip currentTrip : matches) {
            TripPattern tripPattern = this.transitService.getPatternForTrip(currentTrip);
            Set<LocalDate> serviceDates = this.transitService.getCalendarService().getServiceDatesForServiceId(currentTrip.getServiceId());
            if (!serviceDates.contains(realTimeReportedServiceDate)) continue;
            StopLocation firstStop = tripPattern.getStop(0);
            StopLocation lastStop = tripPattern.lastStop();
            String siriOriginRef = monitoredVehicleJourney.getOriginRef().getValue();
            if (monitoredVehicleJourney.getDestinationRef() != null) {
                String siriDestinationRef = monitoredVehicleJourney.getDestinationRef().getValue();
                boolean firstStopIsMatch = firstStop.getId().getId().equals(siriOriginRef);
                boolean lastStopIsMatch = lastStop.getId().getId().equals(siriDestinationRef);
                if (!firstStopIsMatch && firstStop.isPartOfStation()) {
                    RegularStop otherFirstStop = this.transitService.getRegularStop(new FeedScopedId(firstStop.getId().getFeedId(), siriOriginRef));
                    firstStopIsMatch = firstStop.isPartOfSameStationAs(otherFirstStop);
                }
                if (!lastStopIsMatch && lastStop.isPartOfStation()) {
                    RegularStop otherLastStop = this.transitService.getRegularStop(new FeedScopedId(lastStop.getId().getFeedId(), siriDestinationRef));
                    lastStopIsMatch = lastStop.isPartOfSameStationAs(otherLastStop);
                }
                if (!(firstStopIsMatch & lastStopIsMatch)) continue;
                TripPattern realtimeAddedTripPattern = this.buffer.getRealtimeAddedTripPattern(currentTrip.getId(), realTimeReportedServiceDate);
                if (realtimeAddedTripPattern != null) {
                    patterns.add(realtimeAddedTripPattern);
                    continue;
                }
                patterns.add(tripPattern);
                continue;
            }
            if (!firstStop.getId().getId().equals(siriOriginRef)) continue;
            tripPattern.getScheduledTimetable().getTripTimes().get(0).getDepartureTime(0);
            patterns.add(tripPattern);
        }
        return patterns;
    }

    private TripPattern getPatternForTrip(Trip trip, EstimatedVehicleJourney journey) {
        String journeyLastStopId;
        EstimatedCall estimatedCall;
        LocalDate journeyDate;
        String journeyFirstStopId;
        RecordedCall recordedCall;
        List recordedCalls;
        Set<LocalDate> serviceDates = this.transitService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
        List list = recordedCalls = journey.getRecordedCalls() != null ? journey.getRecordedCalls().getRecordedCalls() : new ArrayList();
        if (journey.getEstimatedCalls() == null) {
            return null;
        }
        List estimatedCalls = journey.getEstimatedCalls().getEstimatedCalls();
        if (recordedCalls != null && !recordedCalls.isEmpty()) {
            recordedCall = (RecordedCall)recordedCalls.get(0);
            journeyFirstStopId = recordedCall.getStopPointRef().getValue();
            journeyDate = recordedCall.getAimedDepartureTime().toLocalDate();
        } else if (estimatedCalls != null && !estimatedCalls.isEmpty()) {
            estimatedCall = (EstimatedCall)estimatedCalls.get(0);
            journeyFirstStopId = estimatedCall.getStopPointRef().getValue();
            journeyDate = estimatedCall.getAimedDepartureTime().toLocalDate();
        } else {
            return null;
        }
        if (estimatedCalls != null && !estimatedCalls.isEmpty()) {
            estimatedCall = (EstimatedCall)estimatedCalls.get(estimatedCalls.size() - 1);
            journeyLastStopId = estimatedCall.getStopPointRef().getValue();
        } else if (recordedCalls != null && !recordedCalls.isEmpty()) {
            recordedCall = (RecordedCall)recordedCalls.get(recordedCalls.size() - 1);
            journeyLastStopId = recordedCall.getStopPointRef().getValue();
        } else {
            return null;
        }
        TripPattern realtimeAddedTripPattern = null;
        TimetableSnapshot timetableSnapshot = this.snapshot;
        if (timetableSnapshot != null) {
            realtimeAddedTripPattern = timetableSnapshot.getRealtimeAddedTripPattern(trip.getId(), journeyDate);
        }
        TripPattern tripPattern = realtimeAddedTripPattern != null ? realtimeAddedTripPattern : this.transitService.getPatternForTrip(trip);
        StopLocation firstStop = tripPattern.firstStop();
        StopLocation lastStop = tripPattern.lastStop();
        if (serviceDates.contains(journeyDate)) {
            boolean firstStopIsMatch = firstStop.getId().getId().equals(journeyFirstStopId);
            boolean lastStopIsMatch = lastStop.getId().getId().equals(journeyLastStopId);
            if (!firstStopIsMatch && firstStop.isPartOfStation()) {
                RegularStop otherFirstStop = this.transitService.getRegularStop(new FeedScopedId(firstStop.getId().getFeedId(), journeyFirstStopId));
                firstStopIsMatch = firstStop.isPartOfSameStationAs(otherFirstStop);
            }
            if (!lastStopIsMatch && lastStop.isPartOfStation()) {
                RegularStop otherLastStop = this.transitService.getRegularStop(new FeedScopedId(lastStop.getId().getFeedId(), journeyLastStopId));
                lastStopIsMatch = lastStop.isPartOfSameStationAs(otherLastStop);
            }
            if (firstStopIsMatch & lastStopIsMatch) {
                return tripPattern;
            }
            return null;
        }
        return null;
    }

    private Trip getTripForJourney(Set<Trip> trips, MonitoredVehicleJourneyStructure monitoredVehicleJourney) {
        ZonedDateTime date = monitoredVehicleJourney.getOriginAimedDepartureTime();
        if (date == null) {
            date = ZonedDateTime.now();
        }
        LocalDate serviceDate = date.toLocalDate();
        ArrayList<Trip> results = new ArrayList<Trip>();
        for (Trip trip : trips) {
            Set<LocalDate> serviceDatesForServiceId = this.transitService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
            for (LocalDate next : serviceDatesForServiceId) {
                if (!next.equals(serviceDate)) continue;
                results.add(trip);
            }
        }
        if (results.size() == 1) {
            return (Trip)results.get(0);
        }
        if (results.size() > 1) {
            if (monitoredVehicleJourney.getLineRef() != null && monitoredVehicleJourney.getLineRef().getValue() != null) {
                String lineRef = monitoredVehicleJourney.getLineRef().getValue();
                for (Trip trip : results) {
                    if (!lineRef.equals(trip.getRoute().getId().getId())) continue;
                    return trip;
                }
            }
            return (Trip)results.get(0);
        }
        return null;
    }

    private Set<Trip> getTripForJourney(Set<Trip> trips, EstimatedVehicleJourney journey) {
        String firstStopId;
        ZonedDateTime date;
        List recordedCalls = journey.getRecordedCalls() != null ? journey.getRecordedCalls().getRecordedCalls() : new ArrayList();
        List estimatedCalls = journey.getEstimatedCalls() != null ? journey.getEstimatedCalls().getEstimatedCalls() : null;
        int stopNumber = 1;
        if (recordedCalls != null && !recordedCalls.isEmpty()) {
            RecordedCall recordedCall = (RecordedCall)recordedCalls.get(0);
            date = recordedCall.getAimedDepartureTime();
            firstStopId = recordedCall.getStopPointRef().getValue();
        } else if (estimatedCalls != null && !estimatedCalls.isEmpty()) {
            EstimatedCall estimatedCall = (EstimatedCall)estimatedCalls.get(0);
            if (estimatedCall.getOrder() != null) {
                stopNumber = estimatedCall.getOrder().intValue();
            } else if (estimatedCall.getVisitNumber() != null) {
                stopNumber = estimatedCall.getVisitNumber().intValue();
            }
            firstStopId = estimatedCall.getStopPointRef().getValue();
            date = estimatedCall.getAimedDepartureTime();
        } else {
            return null;
        }
        if (date == null) {
            date = ZonedDateTime.now(this.transitService.getTimeZone());
        }
        LocalDate serviceDate = date.toLocalDate();
        int departureInSecondsSinceMidnight = this.calculateSecondsSinceMidnight(date);
        HashSet<Trip> result = new HashSet<Trip>();
        for (Trip trip : trips) {
            RegularStop alternativeStop;
            TripPattern pattern;
            Set<LocalDate> serviceDatesForServiceId = this.transitService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
            if (!serviceDatesForServiceId.contains(serviceDate) || stopNumber >= (pattern = this.transitService.getPatternForTrip(trip)).numberOfStops()) continue;
            boolean firstReportedStopIsFound = false;
            StopLocation stop = pattern.getStop(stopNumber - 1);
            if (firstStopId.equals(stop.getId().getId())) {
                firstReportedStopIsFound = true;
            } else if (stop.isPartOfStation() && (alternativeStop = this.transitService.getRegularStop(new FeedScopedId(stop.getId().getFeedId(), firstStopId))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                firstReportedStopIsFound = true;
            }
            if (!firstReportedStopIsFound) continue;
            for (TripTimes times : this.getCurrentTimetable(pattern, serviceDate).getTripTimes()) {
                if (times.getScheduledDepartureTime(stopNumber - 1) != departureInSecondsSinceMidnight || !this.transitService.getCalendarService().getServiceDatesForServiceId(times.getTrip().getServiceId()).contains(serviceDate)) continue;
                result.add(times.getTrip());
            }
        }
        if (result.size() >= 1) {
            return result;
        }
        return null;
    }
}

