/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.service.TransitService;

public class GraphReportBuilder {
    public static GraphStats build(OtpServerRequestContext context) {
        TransitService transitService = context.transitService();
        Graph graph = context.graph();
        List<ConstrainedTransfer> constrainedTransfers = transitService.getTransferService().listAll();
        TypeStats constrainedTransferCounts = GraphReportBuilder.countValues(constrainedTransfers, transfer -> {
            TransferConstraint transferConstraint = transfer.getTransferConstraint();
            if (transferConstraint.isMinTransferTimeSet()) {
                return "minTransferTime";
            }
            if (transferConstraint.isStaySeated()) {
                return "staySeated";
            }
            if (transferConstraint.isGuaranteed()) {
                return "guaranteed";
            }
            if (transferConstraint.isNotAllowed()) {
                return "notAllowed";
            }
            return "unknown";
        });
        TypeStats stopCounts = GraphReportBuilder.countValues(transitService.listStopLocations(), GraphReportBuilder::firstLetterToLowerCase);
        TypeStats edgeTypes = GraphReportBuilder.countValues(graph.getEdges(), GraphReportBuilder::firstLetterToLowerCase);
        TypeStats vertexTypes = GraphReportBuilder.countValues(graph.getVertices(), GraphReportBuilder::firstLetterToLowerCase);
        return new GraphStats(new StreetStats(edgeTypes, vertexTypes), new TransitStats(stopCounts, transitService.getAllTrips().size(), transitService.getAllTripPatterns().size(), transitService.getAllRoutes().size(), constrainedTransferCounts));
    }

    @Nonnull
    private static String firstLetterToLowerCase(Object instance) {
        String className = instance.getClass().getSimpleName();
        return Character.toLowerCase(className.charAt(0)) + className.substring(1);
    }

    @Nonnull
    private static <T> TypeStats countValues(Collection<T> input, Function<T, String> classify) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        input.forEach(item -> {
            String classification = (String)classify.apply(item);
            Integer count = result.getOrDefault(classification, 0);
            count = count + 1;
            result.put(classification, count);
        });
        return new TypeStats(input.size(), result);
    }

    record TypeStats(int total, Map<String, Integer> types) {
    }

    public record GraphStats(StreetStats street, TransitStats transit) {
    }

    record StreetStats(TypeStats edges, TypeStats vertices) {
    }

    record TransitStats(TypeStats stops, int trips, int tripPatterns, int routes, TypeStats constrainedTransfers) {
    }
}

