/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.model;

import org.opentripplanner.ext.reportapi.model.CsvReportBuilder;
import org.opentripplanner.graph_builder.module.osm.SafetyFeatures;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.tagmapping.OsmTagMapper;

public class BicycleSafetyReport {
    public static void main(String[] args) {
        System.out.println(BicycleSafetyReport.makeCsv(OsmTagMapper.Source.NORWAY));
    }

    public static String makeCsv(OsmTagMapper.Source source) {
        WayPropertySet wayPropertySet = new WayPropertySet();
        source.getInstance().populateProperties(wayPropertySet);
        CsvReportBuilder buf = new CsvReportBuilder(",");
        buf.addHeader("OSM tags for osmWayPropertySet " + source, "mixin", "permissions", "safety penalty there", "safety penalty back");
        wayPropertySet.getWayProperties().forEach(p -> {
            buf.addText(p.specifier().toString());
            buf.addBoolean(p.safetyMixin());
            buf.addText(p.properties().getPermission().toString());
            SafetyFeatures safetyProps = p.properties().getBicycleSafetyFeatures();
            buf.addNumber(safetyProps.forward());
            buf.addNumber(safetyProps.back());
            buf.newLine();
        });
        return buf.toString();
    }
}

