/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLUtils;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.time.ServiceDateUtils;

public class LegacyGraphQLStopImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLStop {
    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getTransitService(environment).getTransitAlertService();
            LegacyGraphQLTypes.LegacyGraphQLStopAlertsArgs args = new LegacyGraphQLTypes.LegacyGraphQLStopAlertsArgs(environment.getArguments());
            List types = (List)args.getLegacyGraphQLTypes();
            FeedScopedId id = this.getValue(environment, StopLocation::getId, AbstractTransitEntity::getId);
            if (types != null) {
                ArrayList<TransitAlert> alerts = new ArrayList<TransitAlert>();
                if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP)) {
                    alerts.addAll(alertService.getStopAlerts(id));
                }
                if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP_ON_ROUTES) || types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP_ON_TRIPS)) {
                    alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.getEntities().stream().anyMatch(entity -> types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP_ON_ROUTES) && entity instanceof EntitySelector.StopAndRoute && ((EntitySelector.StopAndRoute)entity).stopAndRoute.stop.equals(id) || types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP_ON_TRIPS) && entity instanceof EntitySelector.StopAndTrip && ((EntitySelector.StopAndTrip)entity).stopAndTrip.stop.equals(id))).collect(Collectors.toList()));
                }
                if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.PATTERNS) || types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.TRIPS)) {
                    this.getPatterns(environment).forEach(pattern -> {
                        if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.PATTERNS)) {
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(pattern.getDirection(), pattern.getRoute().getId()));
                        }
                        if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.TRIPS)) {
                            pattern.scheduledTripsAsStream().forEach(trip -> alerts.addAll(alertService.getTripAlerts(trip.getId(), null)));
                        }
                    });
                }
                if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.ROUTES) || types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.AGENCIES_OF_ROUTES)) {
                    this.getRoutes(environment).forEach(route -> {
                        if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.ROUTES)) {
                            alerts.addAll(alertService.getRouteAlerts(route.getId()));
                        }
                        if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.AGENCIES_OF_ROUTES)) {
                            alerts.addAll(alertService.getAgencyAlerts(route.getAgency().getId()));
                        }
                    });
                }
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return alertService.getStopAlerts(id);
        };
    }

    @Override
    public DataFetcher<Object> cluster() {
        return environment -> null;
    }

    @Override
    public DataFetcher<String> code() {
        return environment -> this.getValue(environment, StopLocation::getCode, Station::getCode);
    }

    @Override
    public DataFetcher<String> desc() {
        return environment -> this.getValue(environment, stop -> LegacyGraphQLUtils.getTranslation(stop.getDescription(), environment), station -> LegacyGraphQLUtils.getTranslation(station.getDescription(), environment));
    }

    @Override
    public DataFetcher<String> url() {
        return environment -> this.getValue(environment, stop -> LegacyGraphQLUtils.getTranslation(stop.getUrl(), environment), station -> LegacyGraphQLUtils.getTranslation(station.getUrl(), environment));
    }

    @Override
    public DataFetcher<Object> locationType() {
        return environment -> this.getValue(environment, stop -> "STOP", station -> "STATION");
    }

    @Override
    public DataFetcher<Object> parentStation() {
        return environment -> this.getValue(environment, StopLocation::getParentStation, station -> null);
    }

    @Override
    public DataFetcher<String> direction() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Object> geometries() {
        return environment -> this.getValue(environment, StopLocation::getGeometry, Station::getGeometry);
    }

    @Override
    public DataFetcher<String> gtfsId() {
        return environment -> this.getValue(environment, stop -> stop.getId().toString(), station -> station.getId().toString());
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> this.getValue(environment, stop -> new Relay.ResolvedGlobalId("Stop", stop.getId().toString()), station -> new Relay.ResolvedGlobalId("Stop", station.getId().toString()));
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getValue(environment, StopLocation::getLat, Station::getLat);
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getValue(environment, StopLocation::getLon, Station::getLon);
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getValue(environment, stop -> LegacyGraphQLUtils.getTranslation(stop.getName(), environment), station -> LegacyGraphQLUtils.getTranslation(station.getName(), environment));
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return this::getPatterns;
    }

    @Override
    public DataFetcher<String> platformCode() {
        return environment -> this.getValue(environment, StopLocation::getPlatformCode, station -> null);
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return this::getRoutes;
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stopTimesForPattern() {
        return environment -> this.getValue(environment, stop -> {
            LegacyGraphQLTypes.LegacyGraphQLStopStopTimesForPatternArgs args;
            TransitService transitService = this.getTransitService(environment);
            TripPattern pattern = transitService.getTripPatternForId(FeedScopedId.parseId((args = new LegacyGraphQLTypes.LegacyGraphQLStopStopTimesForPatternArgs(environment.getArguments())).getLegacyGraphQLId()));
            if (pattern == null) {
                return null;
            }
            if (transitService.hasRealtimeAddedTripPatterns()) {
                return this.getTripTimeOnDatesForPatternAtStopIncludingTripsWithSkippedStops(pattern, (StopLocation)stop, transitService, args);
            }
            return transitService.stopTimesForPatternAtStop((StopLocation)stop, pattern, LegacyGraphQLUtils.getTimeOrNow(args.getLegacyGraphQLStartTime()), Duration.ofSeconds(args.getLegacyGraphQLTimeRange().intValue()), args.getLegacyGraphQLNumberOfDepartures(), args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, args.getLegacyGraphQLOmitCanceled() == false);
        }, station -> null);
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return environment -> this.getValue(environment, stop -> null, station -> new ArrayList<StopLocation>(station.getChildStops()));
    }

    @Override
    public DataFetcher<Iterable<StopTimesInPattern>> stoptimesForPatterns() {
        return environment -> {
            TransitService transitService = this.getTransitService(environment);
            LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForPatternsArgs args = new LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForPatternsArgs(environment.getArguments());
            Function<StopLocation, List> stopTFunction = stop -> transitService.stopTimesForStop((StopLocation)stop, LegacyGraphQLUtils.getTimeOrNow(args.getLegacyGraphQLStartTime()), Duration.ofSeconds(args.getLegacyGraphQLTimeRange().intValue()), args.getLegacyGraphQLNumberOfDepartures(), args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, args.getLegacyGraphQLOmitCanceled() == false);
            return this.getValue(environment, stopTFunction, station -> station.getChildStops().stream().map(stopTFunction).flatMap(Collection::stream).collect(Collectors.toList()));
        };
    }

    @Override
    public DataFetcher<Iterable<StopTimesInPattern>> stoptimesForServiceDate() {
        return environment -> {
            LocalDate date;
            TransitService transitService = this.getTransitService(environment);
            LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForServiceDateArgs args = new LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForServiceDateArgs(environment.getArguments());
            try {
                date = ServiceDateUtils.parseString(args.getLegacyGraphQLDate());
            }
            catch (ParseException e) {
                return null;
            }
            Function<StopLocation, List> stopTFunction = stop -> transitService.getStopTimesForStop((StopLocation)stop, date, args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, args.getLegacyGraphQLOmitCanceled() == false);
            return this.getValue(environment, stopTFunction, station -> station.getChildStops().stream().map(stopTFunction).flatMap(Collection::stream).collect(Collectors.toList()));
        };
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stoptimesWithoutPatterns() {
        return environment -> {
            TransitService transitService = this.getTransitService(environment);
            LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForPatternsArgs args = new LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForPatternsArgs(environment.getArguments());
            Function<StopLocation, Stream> stopTFunction = stop -> transitService.stopTimesForStop((StopLocation)stop, LegacyGraphQLUtils.getTimeOrNow(args.getLegacyGraphQLStartTime()), Duration.ofSeconds(args.getLegacyGraphQLTimeRange().intValue()), args.getLegacyGraphQLNumberOfDepartures(), args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, args.getLegacyGraphQLOmitCanceled() == false).stream();
            Stream stream = this.getValue(environment, stopTFunction, station -> station.getChildStops().stream().flatMap(stopTFunction));
            return stream.flatMap(stoptimesWithPattern -> stoptimesWithPattern.times.stream()).sorted(Comparator.comparing(t -> t.getServiceDayMidnight() + (long)t.getRealtimeDeparture())).limit(args.getLegacyGraphQLNumberOfDepartures().intValue()).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<String> timezone() {
        return environment -> this.getValue(environment, stop -> stop.getTimeZone().toString(), station -> station.getTimezone().toString());
    }

    @Override
    public DataFetcher<Iterable<NearbyStop>> transfers() {
        return environment -> this.getValue(environment, stop -> {
            Integer maxDistance = new LegacyGraphQLTypes.LegacyGraphQLStopTransfersArgs(environment.getArguments()).getLegacyGraphQLMaxDistance();
            return this.getTransitService(environment).getTransfersByStop((StopLocation)stop).stream().filter(transfer -> maxDistance == null || transfer.getDistanceMeters() < (double)maxDistance.intValue()).filter(transfer -> transfer.to instanceof RegularStop).map(transfer -> new NearbyStop(transfer.to, transfer.getDistanceMeters(), transfer.getEdges(), null)).collect(Collectors.toList());
        }, station -> null);
    }

    @Override
    public DataFetcher<String> vehicleMode() {
        return environment -> this.getValue(environment, stop -> {
            if (stop.getGtfsVehicleType() != null) {
                return stop.getGtfsVehicleType().name();
            }
            return this.getTransitService(environment).getPatternsForStop((StopLocation)stop).stream().map(TripPattern::getMode).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(Enum::toString).orElse(null);
        }, station -> {
            TransitService transitService = this.getTransitService(environment);
            return station.getChildStops().stream().flatMap(stop -> transitService.getPatternsForStop((StopLocation)stop).stream().map(TripPattern::getMode)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(Enum::toString).orElse(null);
        });
    }

    @Override
    public DataFetcher<Integer> vehicleType() {
        return environment -> null;
    }

    @Override
    public DataFetcher<LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding> wheelchairBoarding() {
        return environment -> {
            Accessibility boarding = this.getValue(environment, StopLocation::getWheelchairAccessibility, station -> null);
            return LegacyGraphQLUtils.toGraphQL(boarding);
        };
    }

    @Override
    public DataFetcher<String> zoneId() {
        return environment -> this.getValue(environment, StopLocation::getFirstZoneAsString, station -> null);
    }

    private Collection<TripPattern> getPatterns(DataFetchingEnvironment environment) {
        return this.getValue(environment, stop -> this.getTransitService(environment).getPatternsForStop((StopLocation)stop, true), station -> null);
    }

    private Collection<Route> getRoutes(DataFetchingEnvironment environment) {
        return this.getValue(environment, stop -> this.getTransitService(environment).getRoutesForStop((StopLocation)stop), station -> null);
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getTransitService();
    }

    private List<TripTimeOnDate> getTripTimeOnDatesForPatternAtStopIncludingTripsWithSkippedStops(TripPattern originalPattern, StopLocation stop, TransitService transitService, LegacyGraphQLTypes.LegacyGraphQLStopStopTimesForPatternArgs args) {
        Instant startTime = LegacyGraphQLUtils.getTimeOrNow(args.getLegacyGraphQLStartTime());
        LocalDate date = startTime.atZone(transitService.getTimeZone()).toLocalDate();
        return Stream.concat(this.getRealtimeAddedPatternsAsStream(originalPattern, transitService, date), Stream.of(originalPattern)).flatMap(tripPattern -> transitService.stopTimesForPatternAtStop(stop, (TripPattern)tripPattern, startTime, Duration.ofSeconds(args.getLegacyGraphQLTimeRange().intValue()), args.getLegacyGraphQLNumberOfDepartures(), args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, false).stream()).sorted(Comparator.comparing(tts -> tts.getServiceDayMidnight() + (long)tts.getRealtimeDeparture())).limit(args.getLegacyGraphQLNumberOfDepartures().intValue()).toList();
    }

    private Stream<TripPattern> getRealtimeAddedPatternsAsStream(TripPattern originalPattern, TransitService transitService, LocalDate date) {
        return originalPattern.scheduledTripsAsStream().map(trip -> transitService.getRealtimeAddedTripPattern(trip.getId(), date)).filter(tripPattern -> tripPattern != null && tripPattern.isModifiedFromTripPatternWithEqualStops(originalPattern));
    }

    private <T> T getValue(DataFetchingEnvironment environment, Function<StopLocation, T> stopTFunction, Function<Station, T> stationTFunction) {
        Object source = environment.getSource();
        if (source instanceof StopLocation) {
            return stopTFunction.apply((StopLocation)source);
        }
        if (source instanceof Station) {
            return stationTFunction.apply((Station)source);
        }
        return null;
    }
}

