/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.stream.Collectors;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLRouteTypeModel;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.service.TransitService;

public class LegacyGraphQLRouteTypeImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLRouteType {
    @Override
    public DataFetcher<Agency> agency() {
        return environment -> this.getSource(environment).getAgency();
    }

    @Override
    public DataFetcher<Integer> routeType() {
        return environment -> this.getSource(environment).getRouteType();
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return environment -> {
            Agency agency = this.getSource(environment).getAgency();
            return this.getTransitService(environment).getAllRoutes().stream().filter(route -> route.getId().getFeedId().equals(this.getSource(environment).getFeedId()) && route.getGtfsType().intValue() == this.getSource(environment).getRouteType() && (agency == null || route.getAgency().equals(agency))).collect(Collectors.toList());
        };
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getTransitService();
    }

    private LegacyGraphQLRouteTypeModel getSource(DataFetchingEnvironment environment) {
        return (LegacyGraphQLRouteTypeModel)environment.getSource();
    }
}

