/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Locale;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLUtils;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.VehicleParkingWithEntrance;
import org.opentripplanner.model.plan.VertexType;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalVehicle;

public class LegacyGraphQLPlaceImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLPlace {
    @Override
    public DataFetcher<Long> arrivalTime() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).arrival.toInstant().toEpochMilli();
    }

    @Override
    public DataFetcher<VehicleParking> bikePark() {
        return this::getBikePark;
    }

    @Override
    public DataFetcher<VehicleRentalPlace> bikeRentalStation() {
        return environment -> {
            Place place = this.getSource((DataFetchingEnvironment)environment).place;
            if (!place.vertexType.equals((Object)VertexType.VEHICLERENTAL)) {
                return null;
            }
            return place.vehicleRentalPlace;
        };
    }

    @Override
    public DataFetcher<VehicleParking> carPark() {
        return this::getCarPark;
    }

    @Override
    public DataFetcher<Long> departureTime() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).departure.toInstant().toEpochMilli();
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).place.coordinate.latitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).place.coordinate.longitude();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> {
            Locale locale = LegacyGraphQLUtils.getLocale(environment);
            return this.getSource((DataFetchingEnvironment)environment).place.name.toString(locale);
        };
    }

    @Override
    public DataFetcher<VehicleRentalVehicle> rentalVehicle() {
        return environment -> {
            Place place = this.getSource((DataFetchingEnvironment)environment).place;
            if (!place.vertexType.equals((Object)VertexType.VEHICLERENTAL) || !(place.vehicleRentalPlace instanceof VehicleRentalVehicle)) {
                return null;
            }
            return (VehicleRentalVehicle)place.vehicleRentalPlace;
        };
    }

    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).place.stop;
    }

    @Override
    public DataFetcher<VehicleParking> vehicleParking() {
        return this::getVehicleParking;
    }

    @Override
    public DataFetcher<VehicleRentalStation> vehicleRentalStation() {
        return environment -> {
            Place place = this.getSource((DataFetchingEnvironment)environment).place;
            if (!place.vertexType.equals((Object)VertexType.VEHICLERENTAL) || !(place.vehicleRentalPlace instanceof VehicleRentalStation)) {
                return null;
            }
            return (VehicleRentalStation)place.vehicleRentalPlace;
        };
    }

    @Override
    public DataFetcher<String> vertexType() {
        return environment -> {
            Place place = this.getSource((DataFetchingEnvironment)environment).place;
            switch (place.vertexType) {
                case NORMAL: {
                    return LegacyGraphQLTypes.LegacyGraphQLVertexType.NORMAL.name();
                }
                case TRANSIT: {
                    return LegacyGraphQLTypes.LegacyGraphQLVertexType.TRANSIT.name();
                }
                case VEHICLERENTAL: {
                    return LegacyGraphQLTypes.LegacyGraphQLVertexType.BIKESHARE.name();
                }
                case VEHICLEPARKING: {
                    return LegacyGraphQLTypes.LegacyGraphQLVertexType.BIKEPARK.name();
                }
            }
            throw new IllegalStateException("Unhandled vertexType: " + place.vertexType.name());
        };
    }

    private VehicleParking getBikePark(DataFetchingEnvironment environment) {
        VehicleParkingWithEntrance vehicleParkingWithEntrance = this.getSource((DataFetchingEnvironment)environment).place.vehicleParkingWithEntrance;
        if (vehicleParkingWithEntrance == null || !vehicleParkingWithEntrance.getVehicleParking().hasBicyclePlaces()) {
            return null;
        }
        return vehicleParkingWithEntrance.getVehicleParking();
    }

    private VehicleParking getCarPark(DataFetchingEnvironment environment) {
        VehicleParkingWithEntrance vehicleParkingWithEntrance = this.getSource((DataFetchingEnvironment)environment).place.vehicleParkingWithEntrance;
        if (vehicleParkingWithEntrance == null || !vehicleParkingWithEntrance.getVehicleParking().hasAnyCarPlaces()) {
            return null;
        }
        return vehicleParkingWithEntrance.getVehicleParking();
    }

    private VehicleParking getVehicleParking(DataFetchingEnvironment environment) {
        VehicleParkingWithEntrance vehicleParkingWithEntrance = this.getSource((DataFetchingEnvironment)environment).place.vehicleParkingWithEntrance;
        if (vehicleParkingWithEntrance == null) {
            return null;
        }
        return vehicleParkingWithEntrance.getVehicleParking();
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private StopArrival getSource(DataFetchingEnvironment environment) {
        return (StopArrival)environment.getSource();
    }
}

