/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.service.TransitService;

public class LegacyGraphQLFeedImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLFeed {
    @Override
    public DataFetcher<Iterable<Agency>> agencies() {
        return environment -> this.getAgencies(environment);
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getTransitService(environment).getTransitAlertService();
            LegacyGraphQLTypes.LegacyGraphQLFeedAlertsArgs args = new LegacyGraphQLTypes.LegacyGraphQLFeedAlertsArgs(environment.getArguments());
            Iterable<LegacyGraphQLTypes.LegacyGraphQLFeedAlertType> types = args.getLegacyGraphQLTypes();
            if (types != null) {
                ArrayList alerts = new ArrayList();
                types.forEach(type -> {
                    switch (type) {
                        case AGENCIES: {
                            List<Agency> agencies = this.getAgencies(environment);
                            agencies.forEach(agency -> alerts.addAll(alertService.getAgencyAlerts(agency.getId())));
                            break;
                        }
                        case ROUTE_TYPES: {
                            alertService.getAllAlerts().stream().filter(alert -> alert.getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.RouteType).map(EntitySelector.RouteType.class::cast).anyMatch(entity -> entity.feedId.equals(this.getSource(environment)))).forEach(alert -> alerts.add(alert));
                        }
                    }
                });
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return null;
        };
    }

    @Override
    public DataFetcher<String> feedId() {
        return this::getSource;
    }

    private List<Agency> getAgencies(DataFetchingEnvironment environment) {
        String id = this.getSource(environment);
        return this.getTransitService(environment).getAgencies().stream().filter(agency -> agency.getId().getFeedId().equals(id)).collect(Collectors.toList());
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getTransitService();
    }

    private String getSource(DataFetchingEnvironment environment) {
        return (String)environment.getSource();
    }
}

