/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi;

import graphql.schema.DataFetchingEnvironment;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.I18NString;

public class LegacyGraphQLUtils {
    public static Locale getLocale(DataFetchingEnvironment environment) {
        return LegacyGraphQLUtils.getLocale(environment, (String)environment.getArgument("language"));
    }

    public static Locale getLocale(DataFetchingEnvironment environment, String localeString) {
        if (localeString != null) {
            return Locale.forLanguageTag(localeString);
        }
        Map localContext = (Map)environment.getLocalContext();
        if (localContext != null && localContext.get("locale") != null) {
            return (Locale)localContext.get("locale");
        }
        return environment.getLocale();
    }

    public static String getTranslation(I18NString input, DataFetchingEnvironment environment) {
        if (input == null) {
            return null;
        }
        return input.toString(LegacyGraphQLUtils.getLocale(environment));
    }

    public static LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding toGraphQL(Accessibility boarding) {
        if (boarding == null) {
            return null;
        }
        return switch (boarding) {
            default -> throw new IncompatibleClassChangeError();
            case Accessibility.NO_INFORMATION -> LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding.NO_INFORMATION;
            case Accessibility.POSSIBLE -> LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding.POSSIBLE;
            case Accessibility.NOT_POSSIBLE -> LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding.NOT_POSSIBLE;
        };
    }

    public static LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode toGraphQL(RoutingErrorCode code) {
        if (code == null) {
            return null;
        }
        return switch (code) {
            default -> throw new IncompatibleClassChangeError();
            case RoutingErrorCode.LOCATION_NOT_FOUND -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.LOCATION_NOT_FOUND;
            case RoutingErrorCode.NO_STOPS_IN_RANGE -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.NO_STOPS_IN_RANGE;
            case RoutingErrorCode.NO_TRANSIT_CONNECTION -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.NO_TRANSIT_CONNECTION;
            case RoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW;
            case RoutingErrorCode.OUTSIDE_BOUNDS -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.OUTSIDE_BOUNDS;
            case RoutingErrorCode.OUTSIDE_SERVICE_PERIOD -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.OUTSIDE_SERVICE_PERIOD;
            case RoutingErrorCode.SYSTEM_ERROR -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.SYSTEM_ERROR;
            case RoutingErrorCode.WALKING_BETTER_THAN_TRANSIT -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.WALKING_BETTER_THAN_TRANSIT;
        };
    }

    public static LegacyGraphQLTypes.LegacyGraphQLInputField toGraphQL(InputField inputField) {
        if (inputField == null) {
            return null;
        }
        return switch (inputField) {
            default -> throw new IncompatibleClassChangeError();
            case InputField.DATE_TIME -> LegacyGraphQLTypes.LegacyGraphQLInputField.DATE_TIME;
            case InputField.FROM_PLACE -> LegacyGraphQLTypes.LegacyGraphQLInputField.FROM;
            case InputField.TO_PLACE, InputField.INTERMEDIATE_PLACE -> LegacyGraphQLTypes.LegacyGraphQLInputField.TO;
        };
    }

    public static RentalVehicleType.FormFactor toModel(LegacyGraphQLTypes.LegacyGraphQLFormFactor formFactor) {
        if (formFactor == null) {
            return null;
        }
        return switch (formFactor) {
            default -> throw new IncompatibleClassChangeError();
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.BICYCLE -> RentalVehicleType.FormFactor.BICYCLE;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.SCOOTER -> RentalVehicleType.FormFactor.SCOOTER;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.CAR -> RentalVehicleType.FormFactor.CAR;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.MOPED -> RentalVehicleType.FormFactor.MOPED;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.OTHER -> RentalVehicleType.FormFactor.OTHER;
        };
    }

    public static PlaceType toModel(LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.BICYCLE_RENT, LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.VEHICLE_RENT -> PlaceType.VEHICLE_RENT;
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.BIKE_PARK -> PlaceType.BIKE_PARK;
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.CAR_PARK -> PlaceType.CAR_PARK;
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.DEPARTURE_ROW -> PlaceType.PATTERN_AT_STOP;
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.STOP -> PlaceType.STOP;
        };
    }

    public static Instant getTimeOrNow(long epochSeconds) {
        return epochSeconds != 0L ? Instant.ofEpochSecond(epochSeconds) : Instant.now();
    }

    public static boolean startsWith(String str, String name, Locale locale) {
        return str != null && str.toLowerCase(locale).startsWith(name);
    }

    public static boolean startsWith(I18NString str, String name, Locale locale) {
        return str != null && str.toString(locale).toLowerCase(locale).startsWith(name);
    }
}

