/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.geocoder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opentripplanner.api.mapping.FeedScopedIdMapper;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.site.StopLocation;

@Path(value="/routers/{ignoreRouterId}/geocode")
@Produces(value={"application/json"})
public class GeocoderResource {
    private final OtpServerRequestContext serverContext;
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;

    public GeocoderResource(@Context OtpServerRequestContext requestContext) {
        this.serverContext = requestContext;
    }

    @GET
    public Response textSearch(@QueryParam(value="query") String query, @QueryParam(value="autocomplete") @DefaultValue(value="false") boolean autocomplete, @QueryParam(value="stops") @DefaultValue(value="true") boolean stops, @QueryParam(value="clusters") @DefaultValue(value="false") boolean clusters, @QueryParam(value="corners") @DefaultValue(value="true") boolean corners) {
        return Response.status((Response.Status)Response.Status.OK).entity(this.query(query, autocomplete, stops, clusters, corners)).build();
    }

    private List<SearchResult> query(String query, boolean autocomplete, boolean stops, boolean clusters, boolean corners) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if (stops) {
            results.addAll(this.queryStopLocations(query, autocomplete));
        }
        if (clusters) {
            results.addAll(this.queryStations(query, autocomplete));
        }
        if (corners) {
            results.addAll(this.queryCorners(query, autocomplete));
        }
        return results;
    }

    private Collection<SearchResult> queryStopLocations(String query, boolean autocomplete) {
        return LuceneIndex.forServer(this.serverContext).queryStopLocations(query, autocomplete).map(sl -> new SearchResult(sl.getCoordinate().latitude(), sl.getCoordinate().longitude(), this.stringifyStopLocation((StopLocation)sl), FeedScopedIdMapper.mapToApi(sl.getId()))).collect(Collectors.toList());
    }

    private Collection<? extends SearchResult> queryStations(String query, boolean autocomplete) {
        return LuceneIndex.forServer(this.serverContext).findStopLocationGroups(query, autocomplete).map(sc -> new SearchResult(sc.getCoordinate().latitude(), sc.getCoordinate().longitude(), Objects.toString(sc.getName()), FeedScopedIdMapper.mapToApi(sc.getId()))).collect(Collectors.toList());
    }

    private Collection<? extends SearchResult> queryCorners(String query, boolean autocomplete) {
        return LuceneIndex.forServer(this.serverContext).queryStreetVertices(query, autocomplete).map(v -> new SearchResult(v.getLat(), v.getLon(), this.stringifyStreetVertex((StreetVertex)v), v.getLabel())).collect(Collectors.toList());
    }

    private String stringifyStreetVertex(StreetVertex v) {
        return String.format("%s (%s)", v.getIntersectionName(), v.getLabel());
    }

    private String stringifyStopLocation(StopLocation sl) {
        return sl.getCode() != null ? String.format("%s (%s)", sl.getName(), sl.getCode()) : Objects.toString(sl.getName());
    }

    public static class SearchResult {
        public double lat;
        public double lng;
        public String description;
        public String id;

        private SearchResult(double lat, double lng, String description, String id) {
            this.lat = lat;
            this.lng = lng;
            this.description = description;
            this.id = id;
        }
    }
}

