/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.edgetype;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPath;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.site.StopLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexTripEdge
extends Edge {
    private static final Logger LOG = LoggerFactory.getLogger(FlexTripEdge.class);
    private final FlexTrip trip;
    public StopLocation s1;
    public StopLocation s2;
    public FlexAccessEgressTemplate flexTemplate;
    public FlexPath flexPath;

    public FlexTripEdge(Vertex v1, Vertex v2, StopLocation s1, StopLocation s2, FlexTrip trip, FlexAccessEgressTemplate flexTemplate, FlexPathCalculator calculator) {
        super(new Vertex(null, null, 0.0, 0.0){}, new Vertex(null, null, 0.0, 0.0){});
        this.s1 = s1;
        this.s2 = s2;
        this.trip = trip;
        this.flexTemplate = flexTemplate;
        this.fromv = v1;
        this.tov = v2;
        this.flexPath = calculator.calculateFlexPath(this.fromv, this.tov, flexTemplate.fromStopIndex, flexTemplate.toStopIndex);
    }

    public int getTimeInSeconds() {
        return this.flexPath.durationSeconds;
    }

    @Override
    public State traverse(State s0) {
        if (this.flexPath == null) {
            return null;
        }
        StateEditor editor = s0.edit(this);
        editor.setBackMode(TraverseMode.FLEX);
        editor.incrementWeight(600.0);
        int timeInSeconds = this.getTimeInSeconds();
        editor.incrementTimeInSeconds(timeInSeconds);
        editor.incrementWeight(timeInSeconds);
        editor.resetEnteredNoThroughTrafficArea();
        return editor.makeState();
    }

    @Override
    public I18NString getName() {
        return null;
    }

    @Override
    public LineString getGeometry() {
        return this.flexPath.getGeometry();
    }

    @Override
    public double getDistanceMeters() {
        return this.flexPath.distanceMeters;
    }

    public FlexTrip getFlexTrip() {
        return this.trip;
    }
}

