/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.ext.fares.model.FareAttribute;
import org.opentripplanner.ext.fares.model.RouteOriginDestination;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class FareRuleSet
implements Serializable {
    private static final long serialVersionUID = 7218355718876553028L;
    private FeedScopedId agency = null;
    private final Set<FeedScopedId> routes;
    private final Set<P2<String>> originDestinations;
    private final Set<RouteOriginDestination> routeOriginDestinations;
    private final Set<String> contains;
    private final FareAttribute fareAttribute;
    private final Set<FeedScopedId> trips;

    public FareRuleSet(FareAttribute fareAttribute) {
        this.fareAttribute = fareAttribute;
        this.routes = new HashSet<FeedScopedId>();
        this.originDestinations = new HashSet<P2<String>>();
        this.routeOriginDestinations = new HashSet<RouteOriginDestination>();
        this.contains = new HashSet<String>();
        this.trips = new HashSet<FeedScopedId>();
    }

    public void addOriginDestination(String origin, String destination) {
        this.originDestinations.add(new P2<String>(origin, destination));
    }

    public Set<P2<String>> getOriginDestinations() {
        return this.originDestinations;
    }

    public void addRouteOriginDestination(String route, String origin, String destination) {
        this.routeOriginDestinations.add(new RouteOriginDestination(route, origin, destination));
    }

    public Set<RouteOriginDestination> getRouteOriginDestinations() {
        return this.routeOriginDestinations;
    }

    public void addContains(String containsId) {
        this.contains.add(containsId);
    }

    public Set<String> getContains() {
        return this.contains;
    }

    public void addRoute(FeedScopedId route) {
        this.routes.add(route);
    }

    public Set<FeedScopedId> getRoutes() {
        return this.routes;
    }

    public FareAttribute getFareAttribute() {
        return this.fareAttribute;
    }

    public void addTrip(FeedScopedId trip) {
        this.trips.add(trip);
    }

    public Set<FeedScopedId> getTrips() {
        return this.trips;
    }

    public boolean matches(String startZone, String endZone, Set<String> zonesVisited, Set<FeedScopedId> routesVisited, Set<FeedScopedId> tripsVisited) {
        P2<Object> od2;
        P2<String> od;
        if (!(this.originDestinations.size() <= 0 || this.originDestinations.contains(od = new P2<String>(startZone, endZone)) || this.originDestinations.contains(od2 = new P2<Object>(((String)od.first), null)) || this.originDestinations.contains(od2 = new P2<String>(null, (String)od.first)))) {
            return false;
        }
        if (this.contains.size() > 0 && !zonesVisited.equals(this.contains)) {
            return false;
        }
        if (this.routes.size() != 0 && !this.routes.containsAll(routesVisited)) {
            return false;
        }
        return this.trips.size() == 0 || this.trips.containsAll(tripsVisited);
    }

    public boolean hasAgencyDefined() {
        return this.agency != null;
    }

    public FeedScopedId getAgency() {
        return this.agency;
    }

    public void setAgency(FeedScopedId agency) {
        this.agency = agency;
    }
}

