/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import java.time.Duration;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import org.opentripplanner.ext.fares.impl.DefaultFareService;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.ItineraryFares;

public class HighestFareInFreeTransferWindowFareService
extends DefaultFareService {
    private final boolean analyzeInterlinedTransfers;
    private final Duration freeTransferWindow;

    public HighestFareInFreeTransferWindowFareService(Collection<FareRuleSet> regularFareRules, Duration freeTransferWindow, boolean analyzeInterlinedTransfers) {
        this.addFareRules(FareType.regular, regularFareRules);
        this.freeTransferWindow = freeTransferWindow;
        this.analyzeInterlinedTransfers = analyzeInterlinedTransfers;
    }

    public boolean analyzeInterlinedTransfers() {
        return this.analyzeInterlinedTransfers;
    }

    public Duration freeTransferWindow() {
        return this.freeTransferWindow;
    }

    @Override
    protected boolean populateFare(ItineraryFares fare, Currency currency, FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        float cost = 0.0f;
        float currentTransferWindowCost = 0.0f;
        long freeTransferWindowEndTimeEpochSeconds = -1L;
        for (Leg leg : legs) {
            float rideCost = this.calculateCost(fareType, List.of(leg), fareRules);
            if (leg.getStartTime().toEpochSecond() > freeTransferWindowEndTimeEpochSeconds) {
                cost += currentTransferWindowCost;
                currentTransferWindowCost = 0.0f;
                freeTransferWindowEndTimeEpochSeconds = -1L;
            }
            if (freeTransferWindowEndTimeEpochSeconds == -1L) {
                freeTransferWindowEndTimeEpochSeconds = leg.getStartTime().plus(this.freeTransferWindow).toEpochSecond();
            }
            currentTransferWindowCost = Float.max(currentTransferWindowCost, rideCost);
        }
        if ((cost += currentTransferWindowCost) < Float.POSITIVE_INFINITY) {
            fare.addFare(fareType, HighestFareInFreeTransferWindowFareService.getMoney(currency, cost));
        }
        return cost > 0.0f && cost < Float.POSITIVE_INFINITY;
    }

    @Override
    protected boolean shouldCombineInterlinedLegs(ScheduledTransitLeg current, ScheduledTransitLeg previous) {
        return !this.analyzeInterlinedTransfers;
    }
}

