/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.datastore.gs;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.base.DataSourceRepository;
import org.opentripplanner.datastore.base.ZipStreamDataSourceDecorator;
import org.opentripplanner.ext.datastore.gs.GsDirectoryDataSource;
import org.opentripplanner.ext.datastore.gs.GsFileDataSource;
import org.opentripplanner.ext.datastore.gs.GsHelper;
import org.opentripplanner.ext.datastore.gs.GsOutFileDataSource;

public class GsDataSourceRepository
implements DataSourceRepository {
    private final String credentialsFilename;
    private Storage storage;

    public GsDataSourceRepository(String credentialsFilename) {
        this.credentialsFilename = credentialsFilename;
    }

    @Override
    public String description() {
        return "Google Cloud Storage";
    }

    @Override
    public void open() {
        this.storage = this.connectToStorage();
    }

    @Override
    public DataSource findSource(@Nonnull URI uri, @Nonnull FileType type) {
        if (GsDataSourceRepository.skipUri(uri)) {
            return null;
        }
        BlobId blobId = GsHelper.toBlobId(uri);
        return this.createSource(blobId, type);
    }

    @Override
    public CompositeDataSource findCompositeSource(@Nonnull URI uri, @Nonnull FileType type) {
        if (GsDataSourceRepository.skipUri(uri)) {
            return null;
        }
        return this.createCompositeSource(GsHelper.toBlobId(uri), type);
    }

    private static boolean skipUri(URI uri) {
        return !"gs".equals(uri.getScheme());
    }

    private DataSource createSource(BlobId blobId, FileType type) {
        Blob blob = this.storage.get(blobId);
        if (blob != null) {
            return new GsFileDataSource(blob, type);
        }
        return new GsOutFileDataSource(this.storage, blobId, type);
    }

    private CompositeDataSource createCompositeSource(BlobId blobId, FileType type) {
        if (GsHelper.isRoot(blobId)) {
            return new GsDirectoryDataSource(this.storage, blobId, type);
        }
        if (blobId.getName().endsWith(".zip")) {
            Blob blob = this.storage.get(blobId);
            if (blob == null) {
                throw new IllegalArgumentException(type.text() + " not found: " + GsHelper.toUriString(blobId));
            }
            GsFileDataSource gsSource = new GsFileDataSource(blob, type);
            return new ZipStreamDataSourceDecorator(gsSource);
        }
        return new GsDirectoryDataSource(this.storage, blobId, type);
    }

    private Storage connectToStorage() {
        try {
            StorageOptions.Builder builder = StorageOptions.getDefaultInstance().toBuilder();
            if (this.credentialsFilename != null) {
                GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)new FileInputStream(this.credentialsFilename)).createScoped(Collections.singletonList("https://www.googleapis.com/auth/cloud-platform"));
                builder.setCredentials((Credentials)credentials);
            }
            return (Storage)builder.build().getService();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

