/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.actuator;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.ValidationError;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MicrometerGraphQLInstrumentation
implements Instrumentation {
    private static final String QUERY_TIME_METRIC_NAME = "graphql.timer.query";
    private static final String RESOLVER_TIME_METRIC_NAME = "graphql.timer.resolver";
    private static final String OPERATION_NAME_TAG = "operationName";
    private static final String OPERATION = "operation";
    private static final String PARENT = "parent";
    private static final String FIELD = "field";
    private static final String TIMER_DESCRIPTION = "Timer that records the time to fetch the data by Operation Name";
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> tags;

    public MicrometerGraphQLInstrumentation(MeterRegistry meterRegistry, Iterable<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new TraceState(parameters.getExecutionInput().getOperationName());
    }

    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters) {
        TraceState state = (TraceState)parameters.getInstrumentationState();
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return SimpleInstrumentationContext.whenCompleted((res, err) -> sample.stop(this.buildQueryTimer(state.operationName, "execution")));
    }

    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters) {
        TraceState state = (TraceState)parameters.getInstrumentationState();
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return SimpleInstrumentationContext.whenCompleted((res, err) -> sample.stop(this.buildQueryTimer(state.operationName, "parse")));
    }

    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        TraceState state = (TraceState)parameters.getInstrumentationState();
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return SimpleInstrumentationContext.whenCompleted((res, err) -> sample.stop(this.buildQueryTimer(state.operationName, "validation")));
    }

    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        return SimpleInstrumentationContext.noOp();
    }

    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters) {
        return new ExecutionStrategyInstrumentationContext(){

            public void onDispatched(CompletableFuture<ExecutionResult> result) {
            }

            public void onCompleted(ExecutionResult result, Throwable t) {
            }
        };
    }

    public InstrumentationContext<ExecutionResult> beginField(InstrumentationFieldParameters parameters) {
        return SimpleInstrumentationContext.noOp();
    }

    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters) {
        if (parameters.getField().getDirective("timingData") == null) {
            return SimpleInstrumentationContext.noOp();
        }
        TraceState state = (TraceState)parameters.getInstrumentationState();
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return SimpleInstrumentationContext.whenCompleted((res, err) -> {
            String parentType = GraphQLTypeUtil.simplePrint((GraphQLType)parameters.getExecutionStepInfo().getParent().getUnwrappedNonNullType());
            String fieldName = parameters.getExecutionStepInfo().getFieldDefinition().getName();
            sample.stop(this.buildFieldTimer(state.operationName, parentType, fieldName));
        });
    }

    private Timer buildQueryTimer(String operationName, String operation) {
        return Timer.builder((String)QUERY_TIME_METRIC_NAME).description(TIMER_DESCRIPTION).tag(OPERATION_NAME_TAG, operationName).tag(OPERATION, operation).tags(this.tags).register(this.meterRegistry);
    }

    private Timer buildFieldTimer(String operationName, String parent, String field) {
        return Timer.builder((String)RESOLVER_TIME_METRIC_NAME).description(TIMER_DESCRIPTION).tag(OPERATION_NAME_TAG, operationName).tag(PARENT, parent).tag(FIELD, field).tags(this.tags).register(this.meterRegistry);
    }

    private static class TraceState
    implements InstrumentationState {
        private final String operationName;

        private TraceState(String operationName) {
            this.operationName = operationName == null ? "__UNKNOWN__" : operationName;
        }
    }
}

