/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.actuator;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.updater.GraphUpdaterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/actuators")
@Produces(value={"application/json"})
public class ActuatorAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ActuatorAPI.class);

    @GET
    public Response actuator(@Context UriInfo uriInfo) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)String.format("{\n  \"_links\" : {\n    \"self\" : {\n      \"href\" : \"%1$s\",\n      \"templated\" : false\n    },\n    \"health\" : {\n      \"href\" : \"%1$s/health\",\n      \"templated\" : false\n    },\n    \"prometheus\" : {\n      \"href\" : \"%1$s/prometheus\",\n      \"templated\" : false\n    }\n  }\n}", uriInfo.getRequestUri().toString().replace("$/", ""))).type("application/json").build();
    }

    @GET
    @Path(value="/health")
    public Response health(@Context OtpServerRequestContext serverContext) {
        List<String> listUnprimedUpdaters;
        GraphUpdaterStatus updaterStatus = serverContext.transitService().getUpdaterStatus();
        if (updaterStatus != null && !(listUnprimedUpdaters = updaterStatus.listUnprimedUpdaters()).isEmpty()) {
            LOG.info("Graph ready, waiting for updaters: {}", listUnprimedUpdaters);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Graph ready, waiting for updaters: " + listUnprimedUpdaters + "\n")).type("text/plain").build());
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"{\n  \"status\" : \"UP\"\n}").type("application/json").build();
    }

    @GET
    @Path(value="/prometheus")
    public Response prometheus(@Context PrometheusMeterRegistry prometheusRegistry) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)prometheusRegistry.scrape()).type("text/plain").build();
    }
}

