/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.https;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.Header;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.base.DataSourceRepository;
import org.opentripplanner.datastore.base.ZipStreamDataSourceDecorator;
import org.opentripplanner.datastore.https.HttpsDataSourceMetadata;
import org.opentripplanner.datastore.https.HttpsFileDataSource;
import org.opentripplanner.util.HttpUtils;

public class HttpsDataSourceRepository
implements DataSourceRepository {
    private static final Duration HTTP_HEAD_REQUEST_TIMEOUT = Duration.ofSeconds(20L);

    @Override
    public String description() {
        return "HTTPS";
    }

    @Override
    public void open() {
    }

    @Override
    public DataSource findSource(@Nonnull URI uri, @Nonnull FileType type) {
        if (HttpsDataSourceRepository.skipUri(uri)) {
            return null;
        }
        return this.createSource(uri, type);
    }

    @Override
    public CompositeDataSource findCompositeSource(@Nonnull URI uri, @Nonnull FileType type) {
        if (HttpsDataSourceRepository.skipUri(uri)) {
            return null;
        }
        return this.createCompositeSource(uri, type);
    }

    private static boolean skipUri(URI uri) {
        return !"https".equals(uri.getScheme());
    }

    private DataSource createSource(URI uri, FileType type) {
        HttpsDataSourceMetadata httpsDataSourceMetadata = new HttpsDataSourceMetadata(this.getHttpHeaders(uri));
        return new HttpsFileDataSource(uri, type, httpsDataSourceMetadata);
    }

    private CompositeDataSource createCompositeSource(URI uri, FileType type) {
        HttpsDataSourceMetadata httpsDataSourceMetadata = new HttpsDataSourceMetadata(this.getHttpHeaders(uri));
        if (httpsDataSourceMetadata.isZipContentType() || uri.getPath().endsWith(".zip")) {
            HttpsFileDataSource httpsSource = new HttpsFileDataSource(uri, type, httpsDataSourceMetadata);
            return new ZipStreamDataSourceDecorator(httpsSource);
        }
        throw new UnsupportedOperationException("Only ZIP archives are supported as composite sources for the HTTPS data source");
    }

    protected List<Header> getHttpHeaders(URI uri) {
        return HttpUtils.getHeaders(uri, HTTP_HEAD_REQUEST_TIMEOUT, Map.of());
    }
}

